/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import com.facebook.FacebookException;
import com.facebook.R;
import com.facebook.appevents.AppEventsLogger;

public abstract class FacebookButtonBase
extends Button {
    private String analyticsButtonCreatedEventName;
    private String analyticsButtonTappedEventName;
    private View.OnClickListener externalOnClickListener;
    private View.OnClickListener internalOnClickListener;
    private boolean overrideCompoundPadding;
    private int overrideCompoundPaddingLeft;
    private int overrideCompoundPaddingRight;
    private Fragment parentFragment;

    protected FacebookButtonBase(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, String analyticsButtonCreatedEventName, String analyticsButtonTappedEventName) {
        super(context, attrs, 0);
        defStyleRes = defStyleRes == 0 ? this.getDefaultStyleResource() : defStyleRes;
        defStyleRes = defStyleRes == 0 ? R.style.com_facebook_button : defStyleRes;
        this.configureButton(context, attrs, defStyleAttr, defStyleRes);
        this.analyticsButtonCreatedEventName = analyticsButtonCreatedEventName;
        this.analyticsButtonTappedEventName = analyticsButtonTappedEventName;
    }

    protected abstract int getDefaultRequestCode();

    public void setFragment(Fragment fragment) {
        this.parentFragment = fragment;
    }

    public Fragment getFragment() {
        return this.parentFragment;
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.externalOnClickListener = l;
    }

    public int getRequestCode() {
        return this.getDefaultRequestCode();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.logButtonCreated(this.getContext());
        }
    }

    protected void onDraw(Canvas canvas) {
        boolean centered;
        boolean bl = centered = (this.getGravity() & 1) != 0;
        if (centered) {
            int compoundPaddingLeft = this.getCompoundPaddingLeft();
            int compoundPaddingRight = this.getCompoundPaddingRight();
            int compoundDrawablePadding = this.getCompoundDrawablePadding();
            int textX = compoundPaddingLeft + compoundDrawablePadding;
            int textContentWidth = this.getWidth() - textX - compoundPaddingRight;
            int textWidth = this.measureTextWidth(this.getText().toString());
            int textPaddingWidth = (textContentWidth - textWidth) / 2;
            int imagePaddingWidth = (compoundPaddingLeft - this.getPaddingLeft()) / 2;
            int inset = Math.min(textPaddingWidth, imagePaddingWidth);
            this.overrideCompoundPaddingLeft = compoundPaddingLeft - inset;
            this.overrideCompoundPaddingRight = compoundPaddingRight + inset;
            this.overrideCompoundPadding = true;
        }
        super.onDraw(canvas);
        this.overrideCompoundPadding = false;
    }

    public int getCompoundPaddingLeft() {
        return this.overrideCompoundPadding ? this.overrideCompoundPaddingLeft : super.getCompoundPaddingLeft();
    }

    public int getCompoundPaddingRight() {
        return this.overrideCompoundPadding ? this.overrideCompoundPaddingRight : super.getCompoundPaddingRight();
    }

    protected Activity getActivity() {
        Context context = this.getContext();
        while (!(context instanceof Activity) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        throw new FacebookException("Unable to get Activity.");
    }

    protected int getDefaultStyleResource() {
        return 0;
    }

    protected int measureTextWidth(String text) {
        return (int)Math.ceil(this.getPaint().measureText(text));
    }

    protected void configureButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.parseBackgroundAttributes(context, attrs, defStyleAttr, defStyleRes);
        this.parseCompoundDrawableAttributes(context, attrs, defStyleAttr, defStyleRes);
        this.parseContentAttributes(context, attrs, defStyleAttr, defStyleRes);
        this.parseTextAttributes(context, attrs, defStyleAttr, defStyleRes);
        this.setupOnClickListener();
    }

    protected void callExternalOnClickListener(View v) {
        if (this.externalOnClickListener != null) {
            this.externalOnClickListener.onClick(v);
        }
    }

    protected void setInternalOnClickListener(View.OnClickListener l) {
        this.internalOnClickListener = l;
    }

    private void logButtonCreated(Context context) {
        AppEventsLogger logger = AppEventsLogger.newLogger(context);
        logger.logSdkEvent(this.analyticsButtonCreatedEventName, null, null);
    }

    private void logButtonTapped(Context context) {
        AppEventsLogger logger = AppEventsLogger.newLogger(context);
        logger.logSdkEvent(this.analyticsButtonTappedEventName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBackgroundAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (this.isInEditMode()) {
            return;
        }
        int[] attrsResources = new int[]{16842964};
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, attrsResources, defStyleAttr, defStyleRes);
        try {
            if (a.hasValue(0)) {
                int backgroundResource = a.getResourceId(0, 0);
                if (backgroundResource != 0) {
                    this.setBackgroundResource(backgroundResource);
                } else {
                    this.setBackgroundColor(a.getColor(0, 0));
                }
            } else {
                this.setBackgroundColor(a.getColor(0, R.color.com_facebook_blue));
            }
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCompoundDrawableAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int[] attrsResources = new int[]{16843119, 16843117, 0x1010170, 16843118, 0x1010171};
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, attrsResources, defStyleAttr, defStyleRes);
        try {
            this.setCompoundDrawablesWithIntrinsicBounds(a.getResourceId(0, 0), a.getResourceId(1, 0), a.getResourceId(2, 0), a.getResourceId(3, 0));
            this.setCompoundDrawablePadding(a.getDimensionPixelSize(4, 0));
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseContentAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int[] attrsResources = new int[]{16842966, 16842967, 16842968, 16842969};
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, attrsResources, defStyleAttr, defStyleRes);
        try {
            this.setPadding(a.getDimensionPixelSize(0, 0), a.getDimensionPixelSize(1, 0), a.getDimensionPixelSize(2, 0), a.getDimensionPixelSize(3, 0));
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseTextAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int[] colorResources = new int[]{16842904};
        TypedArray colorAttrs = context.getTheme().obtainStyledAttributes(attrs, colorResources, defStyleAttr, defStyleRes);
        try {
            this.setTextColor(colorAttrs.getColor(0, -1));
        }
        finally {
            colorAttrs.recycle();
        }
        int[] gravityResources = new int[]{16842927};
        TypedArray gravityAttrs = context.getTheme().obtainStyledAttributes(attrs, gravityResources, defStyleAttr, defStyleRes);
        try {
            this.setGravity(gravityAttrs.getInt(0, 17));
        }
        finally {
            gravityAttrs.recycle();
        }
        int[] attrsResources = new int[]{16842901, 16842903, 16843087};
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, attrsResources, defStyleAttr, defStyleRes);
        try {
            this.setTextSize(0, a.getDimensionPixelSize(0, 0));
            this.setTypeface(Typeface.defaultFromStyle((int)a.getInt(1, 1)));
            this.setText(a.getString(2));
        }
        finally {
            a.recycle();
        }
    }

    private void setupOnClickListener() {
        super.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FacebookButtonBase.this.logButtonTapped(FacebookButtonBase.this.getContext());
                if (FacebookButtonBase.this.internalOnClickListener != null) {
                    FacebookButtonBase.this.internalOnClickListener.onClick(v);
                } else if (FacebookButtonBase.this.externalOnClickListener != null) {
                    FacebookButtonBase.this.externalOnClickListener.onClick(v);
                }
            }
        });
    }
}

