/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import com.facebook.internal.Utility;
import java.util.HashSet;

public class FacebookSignatureValidator {
    private static final String FBI_HASH = "a4b7452e2ed8f5f191058ca7bbfd26b0d3214bfc";
    private static final String FBL_HASH = "5e8f16062ea3cd2c4a0d547876baa6f38cabf625";
    private static final String FBR_HASH = "8a3c4b262d721acd49a4bf97d5213199c86fa2b9";
    private static final HashSet<String> validAppSignatureHashes = FacebookSignatureValidator.buildAppSignatureHashes();

    private static HashSet<String> buildAppSignatureHashes() {
        HashSet<String> set = new HashSet<String>();
        set.add(FBR_HASH);
        set.add(FBI_HASH);
        set.add(FBL_HASH);
        return set;
    }

    public static boolean validateSignature(Context context, String packageName) {
        PackageInfo packageInfo;
        String brand = Build.BRAND;
        int applicationFlags = context.getApplicationInfo().flags;
        if (brand.startsWith("generic") && (applicationFlags & 2) != 0) {
            return true;
        }
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        if (packageInfo.signatures == null || packageInfo.signatures.length <= 0) {
            return false;
        }
        for (Signature signature : packageInfo.signatures) {
            String hashedSignature = Utility.sha1hash(signature.toByteArray());
            if (validAppSignatureHashes.contains(hashedSignature)) continue;
            return false;
        }
        return true;
    }
}

