/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import com.facebook.FacebookException;
import com.facebook.internal.Mutable;
import java.util.Iterator;
import java.util.LinkedList;

public class CollectionMapper {
    public static <T> void iterate(final Collection<T> collection, ValueMapper valueMapper, final OnMapperCompleteListener onMapperCompleteListener) {
        final Mutable<Boolean> didReturnError = new Mutable<Boolean>(false);
        final Mutable<Integer> pendingJobCount = new Mutable<Integer>(1);
        final OnMapperCompleteListener jobCompleteListener = new OnMapperCompleteListener(){

            @Override
            public void onComplete() {
                if (((Boolean)didReturnError.value).booleanValue()) {
                    return;
                }
                pendingJobCount.value = (Integer)pendingJobCount.value - 1;
                if ((Integer)pendingJobCount.value == 0) {
                    onMapperCompleteListener.onComplete();
                }
            }

            @Override
            public void onError(FacebookException exception) {
                if (((Boolean)didReturnError.value).booleanValue()) {
                    return;
                }
                didReturnError.value = true;
                onMapperCompleteListener.onError(exception);
            }
        };
        Iterator<T> keyIterator = collection.keyIterator();
        LinkedList<T> keys = new LinkedList<T>();
        while (keyIterator.hasNext()) {
            keys.add(keyIterator.next());
        }
        for (final Object key : keys) {
            Object value = collection.get(key);
            OnMapValueCompleteListener onMapValueCompleteListener = new OnMapValueCompleteListener(){

                @Override
                public void onComplete(Object mappedValue) {
                    collection.set(key, mappedValue, jobCompleteListener);
                    jobCompleteListener.onComplete();
                }

                @Override
                public void onError(FacebookException exception) {
                    jobCompleteListener.onError(exception);
                }
            };
            Integer n = (Integer)pendingJobCount.value;
            pendingJobCount.value = (Integer)pendingJobCount.value + 1;
            Integer n2 = pendingJobCount.value;
            valueMapper.mapValue(value, onMapValueCompleteListener);
        }
        jobCompleteListener.onComplete();
    }

    private CollectionMapper() {
    }

    public static interface Collection<T> {
        public Iterator<T> keyIterator();

        public Object get(T var1);

        public void set(T var1, Object var2, OnErrorListener var3);
    }

    public static interface ValueMapper {
        public void mapValue(Object var1, OnMapValueCompleteListener var2);
    }

    public static interface OnMapValueCompleteListener
    extends OnErrorListener {
        public void onComplete(Object var1);
    }

    public static interface OnMapperCompleteListener
    extends OnErrorListener {
        public void onComplete();
    }

    public static interface OnErrorListener {
        public void onError(FacebookException var1);
    }
}

