/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginMethodHandler;

class KatanaProxyLoginMethodHandler
extends LoginMethodHandler {
    public static final Parcelable.Creator<KatanaProxyLoginMethodHandler> CREATOR = new Parcelable.Creator(){

        public KatanaProxyLoginMethodHandler createFromParcel(Parcel source) {
            return new KatanaProxyLoginMethodHandler(source);
        }

        public KatanaProxyLoginMethodHandler[] newArray(int size) {
            return new KatanaProxyLoginMethodHandler[size];
        }
    };

    KatanaProxyLoginMethodHandler(LoginClient loginClient) {
        super(loginClient);
    }

    @Override
    String getNameForLogging() {
        return "katana_proxy_auth";
    }

    @Override
    boolean tryAuthorize(LoginClient.Request request) {
        String e2e = LoginClient.getE2E();
        Intent intent = NativeProtocol.createProxyAuthIntent((Context)this.loginClient.getActivity(), request.getApplicationId(), request.getPermissions(), e2e, request.isRerequest(), request.hasPublishPermission(), request.getDefaultAudience());
        this.addLoggingExtra("e2e", e2e);
        return this.tryIntent(intent, LoginClient.getLoginRequestCode());
    }

    @Override
    boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        LoginClient.Request request = this.loginClient.getPendingRequest();
        LoginClient.Result outcome = data == null ? LoginClient.Result.createCancelResult(request, "Operation canceled") : (resultCode == 0 ? LoginClient.Result.createCancelResult(request, data.getStringExtra("error")) : (resultCode != -1 ? LoginClient.Result.createErrorResult(request, "Unexpected resultCode from authorization.", null) : this.handleResultOk(request, data)));
        if (outcome != null) {
            this.loginClient.completeAndValidate(outcome);
        } else {
            this.loginClient.tryNextHandler();
        }
        return true;
    }

    private LoginClient.Result handleResultOk(LoginClient.Request request, Intent data) {
        String e2e;
        Bundle extras = data.getExtras();
        String error = extras.getString("error");
        if (error == null) {
            error = extras.getString("error_type");
        }
        String errorCode = extras.getString("error_code");
        String errorMessage = extras.getString("error_message");
        if (errorMessage == null) {
            errorMessage = extras.getString("error_description");
        }
        if (!Utility.isNullOrEmpty(e2e = extras.getString("e2e"))) {
            this.logWebLoginCompleted(e2e);
        }
        if (error == null && errorCode == null && errorMessage == null) {
            try {
                AccessToken token = KatanaProxyLoginMethodHandler.createAccessTokenFromWebBundle(request.getPermissions(), extras, AccessTokenSource.FACEBOOK_APPLICATION_WEB, request.getApplicationId());
                return LoginClient.Result.createTokenResult(request, token);
            }
            catch (FacebookException ex) {
                return LoginClient.Result.createErrorResult(request, null, ex.getMessage());
            }
        }
        if (ServerProtocol.errorsProxyAuthDisabled.contains(error)) {
            return null;
        }
        if (ServerProtocol.errorsUserCanceled.contains(error)) {
            return LoginClient.Result.createCancelResult(request, null);
        }
        return LoginClient.Result.createErrorResult(request, error, errorMessage, errorCode);
    }

    protected boolean tryIntent(Intent intent, int requestCode) {
        if (intent == null) {
            return false;
        }
        try {
            this.loginClient.getFragment().startActivityForResult(intent, requestCode);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    KatanaProxyLoginMethodHandler(Parcel source) {
        super(source);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
    }
}

