/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.Parcelable;
import com.facebook.FacebookActivity;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.internal.FragmentWrapper;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareOpenGraphContent;
import java.util.List;

public class DeviceShareDialog
extends FacebookDialogBase<ShareContent, Result> {
    private static final int DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.DeviceShare.toRequestCode();

    public DeviceShareDialog(Activity activity) {
        super(activity, DEFAULT_REQUEST_CODE);
    }

    public DeviceShareDialog(Fragment fragment) {
        super(new FragmentWrapper(fragment), DEFAULT_REQUEST_CODE);
    }

    public DeviceShareDialog(android.support.v4.app.Fragment fragment) {
        super(new FragmentWrapper(fragment), DEFAULT_REQUEST_CODE);
    }

    @Override
    protected boolean canShowImpl(ShareContent content, Object mode) {
        return content instanceof ShareLinkContent || content instanceof ShareOpenGraphContent;
    }

    @Override
    protected void showImpl(ShareContent content, Object mode) {
        if (content == null) {
            throw new FacebookException("Must provide non-null content to share");
        }
        if (!(content instanceof ShareLinkContent) && !(content instanceof ShareOpenGraphContent)) {
            throw new FacebookException(this.getClass().getSimpleName() + " only supports ShareLinkContent or ShareOpenGraphContent");
        }
        Intent intent = new Intent();
        intent.setClass(FacebookSdk.getApplicationContext(), FacebookActivity.class);
        intent.setAction("DeviceShareDialogFragment");
        intent.putExtra("content", (Parcelable)content);
        this.startActivityForResult(intent, this.getRequestCode());
    }

    @Override
    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        return null;
    }

    @Override
    protected AppCall createBaseAppCall() {
        return null;
    }

    @Override
    protected void registerCallbackImpl(CallbackManagerImpl callbackManager, final FacebookCallback<Result> callback) {
        callbackManager.registerCallback(this.getRequestCode(), new CallbackManagerImpl.Callback(){

            @Override
            public boolean onActivityResult(int resultCode, Intent data) {
                if (data.hasExtra("error")) {
                    FacebookRequestError error = (FacebookRequestError)data.getParcelableExtra("error");
                    callback.onError(error.getException());
                    return true;
                }
                callback.onSuccess(new Result());
                return true;
            }
        });
    }

    public static class Result {
    }
}

