/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import com.facebook.FacebookContentProvider;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;

public final class NativeAppCallAttachmentStore {
    private static final String TAG = NativeAppCallAttachmentStore.class.getName();
    static final String ATTACHMENTS_DIR_NAME = "com.facebook.NativeAppCallAttachmentStore.files";
    private static File attachmentsDirectory;

    private NativeAppCallAttachmentStore() {
    }

    public static Attachment createAttachment(UUID callId, Bitmap attachmentBitmap) {
        Validate.notNull(callId, "callId");
        Validate.notNull(attachmentBitmap, "attachmentBitmap");
        return new Attachment(callId, attachmentBitmap, null);
    }

    public static Attachment createAttachment(UUID callId, Uri attachmentUri) {
        Validate.notNull(callId, "callId");
        Validate.notNull(attachmentUri, "attachmentUri");
        return new Attachment(callId, null, attachmentUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAttachmentBitmap(Bitmap bitmap, File outputFile) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        try {
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
        }
        finally {
            Utility.closeQuietly(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAttachmentFile(Uri imageUri, boolean isContentUri, File outputFile) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        try {
            InputStream inputStream = null;
            inputStream = !isContentUri ? new FileInputStream(imageUri.getPath()) : FacebookSdk.getApplicationContext().getContentResolver().openInputStream(imageUri);
            Utility.copyAndCloseInputStream(inputStream, outputStream);
        }
        finally {
            Utility.closeQuietly(outputStream);
        }
    }

    public static void addAttachments(Collection<Attachment> attachments) {
        if (attachments == null || attachments.size() == 0) {
            return;
        }
        if (attachmentsDirectory == null) {
            NativeAppCallAttachmentStore.cleanupAllAttachments();
        }
        NativeAppCallAttachmentStore.ensureAttachmentsDirectoryExists();
        ArrayList<File> filesToCleanup = new ArrayList<File>();
        try {
            for (Attachment attachment : attachments) {
                if (!attachment.shouldCreateFile) continue;
                File file = NativeAppCallAttachmentStore.getAttachmentFile(attachment.callId, attachment.attachmentName, true);
                filesToCleanup.add(file);
                if (attachment.bitmap != null) {
                    NativeAppCallAttachmentStore.processAttachmentBitmap(attachment.bitmap, file);
                    continue;
                }
                if (attachment.originalUri == null) continue;
                NativeAppCallAttachmentStore.processAttachmentFile(attachment.originalUri, attachment.isContentUri, file);
            }
        }
        catch (IOException exception) {
            Log.e((String)TAG, (String)("Got unexpected exception:" + exception));
            for (File file : filesToCleanup) {
                try {
                    file.delete();
                }
                catch (Exception exception2) {}
            }
            throw new FacebookException(exception);
        }
    }

    public static void cleanupAttachmentsForCall(UUID callId) {
        File dir = NativeAppCallAttachmentStore.getAttachmentsDirectoryForCall(callId, false);
        if (dir != null) {
            Utility.deleteDirectory(dir);
        }
    }

    public static File openAttachment(UUID callId, String attachmentName) throws FileNotFoundException {
        if (Utility.isNullOrEmpty(attachmentName) || callId == null) {
            throw new FileNotFoundException();
        }
        try {
            return NativeAppCallAttachmentStore.getAttachmentFile(callId, attachmentName, false);
        }
        catch (IOException e) {
            throw new FileNotFoundException();
        }
    }

    static synchronized File getAttachmentsDirectory() {
        if (attachmentsDirectory == null) {
            attachmentsDirectory = new File(FacebookSdk.getApplicationContext().getCacheDir(), ATTACHMENTS_DIR_NAME);
        }
        return attachmentsDirectory;
    }

    static File ensureAttachmentsDirectoryExists() {
        File dir = NativeAppCallAttachmentStore.getAttachmentsDirectory();
        dir.mkdirs();
        return dir;
    }

    static File getAttachmentsDirectoryForCall(UUID callId, boolean create) {
        if (attachmentsDirectory == null) {
            return null;
        }
        File dir = new File(attachmentsDirectory, callId.toString());
        if (create && !dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    static File getAttachmentFile(UUID callId, String attachmentName, boolean createDirs) throws IOException {
        File dir = NativeAppCallAttachmentStore.getAttachmentsDirectoryForCall(callId, createDirs);
        if (dir == null) {
            return null;
        }
        try {
            return new File(dir, URLEncoder.encode(attachmentName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static void cleanupAllAttachments() {
        File dir = NativeAppCallAttachmentStore.getAttachmentsDirectory();
        Utility.deleteDirectory(dir);
    }

    public static final class Attachment {
        private final UUID callId;
        private final String attachmentUrl;
        private final String attachmentName;
        private Bitmap bitmap;
        private Uri originalUri;
        private boolean isContentUri;
        private boolean shouldCreateFile;

        private Attachment(UUID callId, Bitmap bitmap, Uri uri) {
            this.callId = callId;
            this.bitmap = bitmap;
            this.originalUri = uri;
            if (uri != null) {
                String scheme = uri.getScheme();
                if ("content".equalsIgnoreCase(scheme)) {
                    this.isContentUri = true;
                    this.shouldCreateFile = uri.getAuthority() != null && !uri.getAuthority().startsWith("media");
                } else if ("file".equalsIgnoreCase(uri.getScheme())) {
                    this.shouldCreateFile = true;
                } else if (!Utility.isWebUri(uri)) {
                    throw new FacebookException("Unsupported scheme for media Uri : " + scheme);
                }
            } else if (bitmap != null) {
                this.shouldCreateFile = true;
            } else {
                throw new FacebookException("Cannot share media without a bitmap or Uri set");
            }
            this.attachmentName = !this.shouldCreateFile ? null : UUID.randomUUID().toString();
            this.attachmentUrl = !this.shouldCreateFile ? this.originalUri.toString() : FacebookContentProvider.getAttachmentUrl(FacebookSdk.getApplicationId(), callId, this.attachmentName);
        }

        public String getAttachmentUrl() {
            return this.attachmentUrl;
        }
    }
}

