/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.util.Log;
import com.facebook.appevents.AccessTokenAppIdPair;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.AppEventCollection;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.PersistedEvents;
import com.facebook.appevents.SessionEventsState;
import com.facebook.internal.Utility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.List;

class AppEventStore {
    private static final String TAG = AppEventStore.class.getName();
    private static final String PERSISTED_EVENTS_FILENAME = "AppEventsLogger.persistedevents";

    AppEventStore() {
    }

    public static synchronized void persistEvents(AccessTokenAppIdPair accessTokenAppIdPair, SessionEventsState appEvents) {
        AppEventStore.assertIsNotMainThread();
        PersistedEvents persistedEvents = AppEventStore.readAndClearStore();
        if (persistedEvents.containsKey(accessTokenAppIdPair)) {
            ((List)persistedEvents.get(accessTokenAppIdPair)).addAll(appEvents.getEventsToPersist());
        } else {
            persistedEvents.put(accessTokenAppIdPair, appEvents.getEventsToPersist());
        }
        AppEventStore.saveEventsToDisk(persistedEvents);
    }

    public static synchronized void persistEvents(AppEventCollection eventsToPersist) {
        AppEventStore.assertIsNotMainThread();
        PersistedEvents persistedEvents = new PersistedEvents();
        for (AccessTokenAppIdPair accessTokenAppIdPair : eventsToPersist.keySet()) {
            SessionEventsState sessionEventsState = eventsToPersist.get(accessTokenAppIdPair);
            persistedEvents.put(accessTokenAppIdPair, sessionEventsState.getEventsToPersist());
        }
        AppEventStore.saveEventsToDisk(persistedEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized PersistedEvents readAndClearStore() {
        PersistedEvents persistedEvents;
        block19: {
            AppEventStore.assertIsNotMainThread();
            MovedClassObjectInputStream ois = null;
            HashMap obj = null;
            persistedEvents = null;
            Context context = AppEventsLogger.getApplicationContext();
            FileInputStream is = context.openFileInput(PERSISTED_EVENTS_FILENAME);
            ois = new MovedClassObjectInputStream(new BufferedInputStream(is));
            obj = (HashMap)ois.readObject();
            Utility.closeQuietly(ois);
            try {
                context.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                if (obj != null) {
                    persistedEvents = new PersistedEvents(obj);
                }
                break block19;
            }
            catch (Exception ex) {
                Log.w((String)TAG, (String)"Got unexpected exception when removing events file: ", (Throwable)ex);
            }
            break block19;
            catch (FileNotFoundException ex) {
                Utility.closeQuietly(ois);
                try {
                    context.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                    if (obj != null) {
                        persistedEvents = new PersistedEvents(obj);
                    }
                    break block19;
                }
                catch (Exception ex2) {
                    Log.w((String)TAG, (String)"Got unexpected exception when removing events file: ", (Throwable)ex2);
                }
                break block19;
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Got unexpected exception while reading events: ", (Throwable)e);
                break block19;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Utility.closeQuietly(ois);
                try {
                    context.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                    if (obj != null) {
                        persistedEvents = new PersistedEvents(obj);
                    }
                }
                catch (Exception ex) {
                    Log.w((String)TAG, (String)"Got unexpected exception when removing events file: ", (Throwable)ex);
                }
            }
        }
        if (persistedEvents == null) {
            persistedEvents = new PersistedEvents();
        }
        return persistedEvents;
    }

    private static void saveEventsToDisk(PersistedEvents eventsToPersist) {
        ObjectOutputStream oos = null;
        try {
            Context context = AppEventsLogger.getApplicationContext();
            oos = new ObjectOutputStream(new BufferedOutputStream(context.openFileOutput(PERSISTED_EVENTS_FILENAME, 0)));
            oos.writeObject(eventsToPersist);
            Utility.closeQuietly(oos);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Got unexpected exception while persisting events: ", (Throwable)e);
        }
        finally {
            Utility.closeQuietly(oos);
        }
    }

    private static void assertIsNotMainThread() {
    }

    private static class MovedClassObjectInputStream
    extends ObjectInputStream {
        private static final String ACCESS_TOKEN_APP_ID_PAIR_SERIALIZATION_PROXY_V1_CLASS_NAME = "com.facebook.appevents.AppEventsLogger$AccessTokenAppIdPair$SerializationProxyV1";
        private static final String APP_EVENT_SERIALIZATION_PROXY_V1_CLASS_NAME = "com.facebook.appevents.AppEventsLogger$AppEvent$SerializationProxyV1";

        public MovedClassObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
            if (resultClassDescriptor.getName().equals(ACCESS_TOKEN_APP_ID_PAIR_SERIALIZATION_PROXY_V1_CLASS_NAME)) {
                resultClassDescriptor = ObjectStreamClass.lookup(AccessTokenAppIdPair.SerializationProxyV1.class);
            } else if (resultClassDescriptor.getName().equals(APP_EVENT_SERIALIZATION_PROXY_V1_CLASS_NAME)) {
                resultClassDescriptor = ObjectStreamClass.lookup(AppEvent.SerializationProxyV1.class);
            }
            return resultClassDescriptor;
        }
    }
}

