/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Handler;
import com.facebook.Request;
import com.facebook.Settings;

class RequestProgress {
    private final Request request;
    private final Handler callbackHandler;
    private final long threshold;
    private long progress;
    private long lastReportedProgress;
    private long maxProgress;

    RequestProgress(Handler callbackHandler, Request request) {
        this.request = request;
        this.callbackHandler = callbackHandler;
        this.threshold = Settings.getOnProgressThreshold();
    }

    long getProgress() {
        return this.progress;
    }

    long getMaxProgress() {
        return this.maxProgress;
    }

    void addProgress(long size) {
        this.progress += size;
        if (this.progress >= this.lastReportedProgress + this.threshold || this.progress >= this.maxProgress) {
            this.reportProgress();
        }
    }

    void addToMax(long size) {
        this.maxProgress += size;
    }

    void reportProgress() {
        if (this.progress > this.lastReportedProgress) {
            Request.Callback callback = this.request.getCallback();
            if (this.maxProgress > 0L && callback instanceof Request.OnProgressCallback) {
                final long currentCopy = this.progress;
                final long maxProgressCopy = this.maxProgress;
                final Request.OnProgressCallback callbackCopy = (Request.OnProgressCallback)callback;
                if (this.callbackHandler == null) {
                    callbackCopy.onProgress(currentCopy, maxProgressCopy);
                } else {
                    this.callbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callbackCopy.onProgress(currentCopy, maxProgressCopy);
                        }
                    });
                }
                this.lastReportedProgress = this.progress;
            }
        }
    }
}

