/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.android;

import android.app.Activity;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookAuthorizationException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.LegacyHelper;
import com.facebook.Session;
import com.facebook.SessionLoginBehavior;
import com.facebook.SessionState;
import com.facebook.Settings;
import com.facebook.TokenCachingStrategy;
import com.facebook.android.DialogError;
import com.facebook.android.FacebookError;
import com.facebook.android.FbDialog;
import com.facebook.android.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Facebook {
    @Deprecated
    public static final String REDIRECT_URI = "fbconnect://success";
    @Deprecated
    public static final String CANCEL_URI = "fbconnect://cancel";
    @Deprecated
    public static final String TOKEN = "access_token";
    @Deprecated
    public static final String EXPIRES = "expires_in";
    @Deprecated
    public static final String SINGLE_SIGN_ON_DISABLED = "service_disabled";
    @Deprecated
    public static final Uri ATTRIBUTION_ID_CONTENT_URI = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
    @Deprecated
    public static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    @Deprecated
    public static final int FORCE_DIALOG_AUTH = -1;
    private static final String LOGIN = "oauth";
    private static final int DEFAULT_AUTH_ACTIVITY_CODE = 32665;
    @Deprecated
    protected static String DIALOG_BASE_URL = "https://m.facebook.com/dialog/";
    @Deprecated
    protected static String GRAPH_BASE_URL = "https://graph.facebook.com/";
    @Deprecated
    protected static String RESTSERVER_URL = "https://api.facebook.com/restserver.php";
    private final Object lock = new Object();
    private String accessToken = null;
    private long accessExpiresMillisecondsAfterEpoch = 0L;
    private long lastAccessUpdateMillisecondsAfterEpoch = 0L;
    private String mAppId;
    private Activity pendingAuthorizationActivity;
    private String[] pendingAuthorizationPermissions;
    private Session pendingOpeningSession;
    private volatile Session session;
    private boolean sessionInvalidated;
    private SetterTokenCachingStrategy tokenCache;
    private volatile Session userSetSession;
    private static final long REFRESH_TOKEN_BARRIER = 86400000L;
    @Deprecated
    public static final String FB_APP_SIGNATURE = "30820268308201d102044a9c4610300d06092a864886f70d0101040500307a310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f31183016060355040a130f46616365626f6f6b204d6f62696c653111300f060355040b130846616365626f6f6b311d301b0603550403131446616365626f6f6b20436f72706f726174696f6e3020170d3039303833313231353231365a180f32303530303932353231353231365a307a310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f31183016060355040a130f46616365626f6f6b204d6f62696c653111300f060355040b130846616365626f6f6b311d301b0603550403131446616365626f6f6b20436f72706f726174696f6e30819f300d06092a864886f70d010101050003818d0030818902818100c207d51df8eb8c97d93ba0c8c1002c928fab00dc1b42fca5e66e99cc3023ed2d214d822bc59e8e35ddcf5f44c7ae8ade50d7e0c434f500e6c131f4a2834f987fc46406115de2018ebbb0d5a3c261bd97581ccfef76afc7135a6d59e8855ecd7eacc8f8737e794c60a761c536b72b11fac8e603f5da1a2d54aa103b8a13c0dbc10203010001300d06092a864886f70d0101040500038181005ee9be8bcbb250648d3b741290a82a1c9dc2e76a0af2f2228f1d9f9c4007529c446a70175c5a900d5141812866db46be6559e2141616483998211f4a673149fb2232a10d247663b26a9031e15f84bc1c74d141ff98a02d76f85b2c8ab2571b6469b232d8e768a7f7ca04f7abe4a775615916c07940656b58717457b42bd928a2";

    @Deprecated
    public Facebook(String appId) {
        if (appId == null) {
            throw new IllegalArgumentException("You must specify your application ID when instantiating a Facebook object. See README for details.");
        }
        this.mAppId = appId;
    }

    @Deprecated
    public void authorize(Activity activity, DialogListener listener) {
        this.authorize(activity, new String[0], 32665, SessionLoginBehavior.SSO_WITH_FALLBACK, listener);
    }

    @Deprecated
    public void authorize(Activity activity, String[] permissions, DialogListener listener) {
        this.authorize(activity, permissions, 32665, SessionLoginBehavior.SSO_WITH_FALLBACK, listener);
    }

    @Deprecated
    public void authorize(Activity activity, String[] permissions, int activityCode, DialogListener listener) {
        SessionLoginBehavior behavior = activityCode >= 0 ? SessionLoginBehavior.SSO_WITH_FALLBACK : SessionLoginBehavior.SUPPRESS_SSO;
        this.authorize(activity, permissions, activityCode, behavior, listener);
    }

    private void authorize(Activity activity, String[] permissions, int activityCode, SessionLoginBehavior behavior, final DialogListener listener) {
        this.checkUserSession("authorize");
        this.pendingOpeningSession = new Session.Builder((Context)activity).setApplicationId(this.mAppId).setTokenCachingStrategy(this.getTokenCache()).build();
        this.pendingAuthorizationActivity = activity;
        this.pendingAuthorizationPermissions = permissions != null ? permissions : new String[]{};
        Session.StatusCallback callback = new Session.StatusCallback(){

            @Override
            public void call(Session callbackSession, SessionState state, Exception exception) {
                Facebook.this.onSessionCallback(callbackSession, state, exception, listener);
            }
        };
        Session.AuthorizationRequest openRequest = new Session.OpenRequest(activity).setCallback(callback).setLoginBehavior(behavior).setRequestCode(activityCode).setPermissions((List)Arrays.asList(this.pendingAuthorizationPermissions));
        this.openSession(this.pendingOpeningSession, (Session.OpenRequest)openRequest, this.pendingAuthorizationPermissions.length > 0);
    }

    private void openSession(Session session, Session.OpenRequest openRequest, boolean isPublish) {
        openRequest.setIsLegacy(true);
        if (isPublish) {
            session.openForPublish(openRequest);
        } else {
            session.openForRead(openRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSessionCallback(Session callbackSession, SessionState state, Exception exception, DialogListener listener) {
        Bundle extras = callbackSession.getAuthorizationBundle();
        if (state == SessionState.OPENED) {
            Session sessionToClose = null;
            Object object = this.lock;
            synchronized (object) {
                if (callbackSession != this.session) {
                    sessionToClose = this.session;
                    this.session = callbackSession;
                    this.sessionInvalidated = false;
                }
            }
            if (sessionToClose != null) {
                sessionToClose.close();
            }
            listener.onComplete(extras);
        } else if (exception != null) {
            if (exception instanceof FacebookOperationCanceledException) {
                listener.onCancel();
            } else if (exception instanceof FacebookAuthorizationException && extras != null && extras.containsKey("com.facebook.sdk.WebViewErrorCode") && extras.containsKey("com.facebook.sdk.FailingUrl")) {
                DialogError error = new DialogError(exception.getMessage(), extras.getInt("com.facebook.sdk.WebViewErrorCode"), extras.getString("com.facebook.sdk.FailingUrl"));
                listener.onError(error);
            } else {
                FacebookError error = new FacebookError(exception.getMessage());
                listener.onFacebookError(error);
            }
        }
    }

    private boolean validateServiceIntent(Context context, Intent intent) {
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
        if (resolveInfo == null) {
            return false;
        }
        return this.validateAppSignatureForPackage(context, resolveInfo.serviceInfo.packageName);
    }

    private boolean validateAppSignatureForPackage(Context context, String packageName) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        for (Signature signature : packageInfo.signatures) {
            if (!signature.toCharsString().equals(FB_APP_SIGNATURE)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void authorizeCallback(int requestCode, int resultCode, Intent data) {
        this.checkUserSession("authorizeCallback");
        Session pending = this.pendingOpeningSession;
        if (pending != null && pending.onActivityResult(this.pendingAuthorizationActivity, requestCode, resultCode, data)) {
            this.pendingOpeningSession = null;
            this.pendingAuthorizationActivity = null;
            this.pendingAuthorizationPermissions = null;
        }
    }

    @Deprecated
    public boolean extendAccessToken(Context context, ServiceListener serviceListener) {
        this.checkUserSession("extendAccessToken");
        Intent intent = new Intent();
        intent.setClassName("com.facebook.katana", "com.facebook.katana.platform.TokenRefreshService");
        if (!this.validateServiceIntent(context, intent)) {
            return false;
        }
        return context.bindService(intent, (ServiceConnection)new TokenRefreshServiceConnection(context, serviceListener), 1);
    }

    @Deprecated
    public boolean extendAccessTokenIfNeeded(Context context, ServiceListener serviceListener) {
        this.checkUserSession("extendAccessTokenIfNeeded");
        if (this.shouldExtendAccessToken()) {
            return this.extendAccessToken(context, serviceListener);
        }
        return true;
    }

    @Deprecated
    public boolean shouldExtendAccessToken() {
        this.checkUserSession("shouldExtendAccessToken");
        return this.isSessionValid() && System.currentTimeMillis() - this.lastAccessUpdateMillisecondsAfterEpoch >= 86400000L;
    }

    @Deprecated
    public String logout(Context context) throws MalformedURLException, IOException {
        return this.logoutImpl(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String logoutImpl(Context context) throws MalformedURLException, IOException {
        this.checkUserSession("logout");
        Bundle b = new Bundle();
        b.putString("method", "auth.expireSession");
        String response = this.request(b);
        long currentTimeMillis = System.currentTimeMillis();
        Session sessionToClose = null;
        Object object = this.lock;
        synchronized (object) {
            sessionToClose = this.session;
            this.session = null;
            this.accessToken = null;
            this.accessExpiresMillisecondsAfterEpoch = 0L;
            this.lastAccessUpdateMillisecondsAfterEpoch = currentTimeMillis;
            this.sessionInvalidated = false;
        }
        if (sessionToClose != null) {
            sessionToClose.closeAndClearTokenInformation();
        }
        return response;
    }

    @Deprecated
    public String request(Bundle parameters) throws MalformedURLException, IOException {
        if (!parameters.containsKey("method")) {
            throw new IllegalArgumentException("API method must be specified. (parameters must contain key \"method\" and value). See http://developers.facebook.com/docs/reference/rest/");
        }
        return this.requestImpl(null, parameters, "GET");
    }

    @Deprecated
    public String request(String graphPath) throws MalformedURLException, IOException {
        return this.requestImpl(graphPath, new Bundle(), "GET");
    }

    @Deprecated
    public String request(String graphPath, Bundle parameters) throws MalformedURLException, IOException {
        return this.requestImpl(graphPath, parameters, "GET");
    }

    @Deprecated
    public String request(String graphPath, Bundle params, String httpMethod) throws FileNotFoundException, MalformedURLException, IOException {
        return this.requestImpl(graphPath, params, httpMethod);
    }

    String requestImpl(String graphPath, Bundle params, String httpMethod) throws FileNotFoundException, MalformedURLException, IOException {
        params.putString("format", "json");
        if (this.isSessionValid()) {
            params.putString(TOKEN, this.getAccessToken());
        }
        String url = graphPath != null ? GRAPH_BASE_URL + graphPath : RESTSERVER_URL;
        return Util.openUrl(url, httpMethod, params);
    }

    @Deprecated
    public void dialog(Context context, String action, DialogListener listener) {
        this.dialog(context, action, new Bundle(), listener);
    }

    @Deprecated
    public void dialog(Context context, String action, Bundle parameters, DialogListener listener) {
        parameters.putString("display", "touch");
        parameters.putString("redirect_uri", REDIRECT_URI);
        if (action.equals(LOGIN)) {
            parameters.putString("type", "user_agent");
            parameters.putString("client_id", this.mAppId);
        } else {
            parameters.putString("app_id", this.mAppId);
            if (this.isSessionValid()) {
                parameters.putString(TOKEN, this.getAccessToken());
            }
        }
        if (context.checkCallingOrSelfPermission("android.permission.INTERNET") != 0) {
            Util.showAlert(context, "Error", "Application requires permission to access the Internet");
        } else {
            new FbDialog(context, action, parameters, listener).show();
        }
    }

    @Deprecated
    public boolean isSessionValid() {
        return this.getAccessToken() != null && (this.getAccessExpires() == 0L || System.currentTimeMillis() < this.getAccessExpires());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setSession(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("session cannot be null");
        }
        Object object = this.lock;
        synchronized (object) {
            this.userSetSession = session;
        }
    }

    private void checkUserSession(String methodName) {
        if (this.userSetSession != null) {
            throw new UnsupportedOperationException(String.format("Cannot call %s after setSession has been called.", methodName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final Session getSession() {
        Session returnSession;
        do {
            String cachedToken = null;
            Session oldSession = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.userSetSession != null) {
                    return this.userSetSession;
                }
                if (this.session != null || !this.sessionInvalidated) {
                    return this.session;
                }
                cachedToken = this.accessToken;
                oldSession = this.session;
            }
            if (cachedToken == null) {
                return null;
            }
            List<String> permissions = oldSession != null ? oldSession.getPermissions() : (this.pendingAuthorizationPermissions != null ? Arrays.asList(this.pendingAuthorizationPermissions) : Collections.emptyList());
            Session newSession = new Session.Builder((Context)this.pendingAuthorizationActivity).setApplicationId(this.mAppId).setTokenCachingStrategy(this.getTokenCache()).build();
            if (newSession.getState() != SessionState.CREATED_TOKEN_LOADED) {
                return null;
            }
            Session.AuthorizationRequest openRequest = new Session.OpenRequest(this.pendingAuthorizationActivity).setPermissions((List)permissions);
            this.openSession(newSession, (Session.OpenRequest)openRequest, !permissions.isEmpty());
            Session invalidatedSession = null;
            returnSession = null;
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.sessionInvalidated || this.session == null) {
                    invalidatedSession = this.session;
                    returnSession = this.session = newSession;
                    this.sessionInvalidated = false;
                }
            }
            if (invalidatedSession == null) continue;
            invalidatedSession.close();
        } while (returnSession == null);
        return returnSession;
    }

    @Deprecated
    public String getAccessToken() {
        Session s = this.getSession();
        if (s != null) {
            return s.getAccessToken();
        }
        return null;
    }

    @Deprecated
    public long getAccessExpires() {
        Session s = this.getSession();
        if (s != null) {
            return s.getExpirationDate().getTime();
        }
        return this.accessExpiresMillisecondsAfterEpoch;
    }

    @Deprecated
    public long getLastAccessUpdate() {
        return this.lastAccessUpdateMillisecondsAfterEpoch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setTokenFromCache(String accessToken, long accessExpires, long lastAccessUpdate) {
        this.checkUserSession("setTokenFromCache");
        Object object = this.lock;
        synchronized (object) {
            this.accessToken = accessToken;
            this.accessExpiresMillisecondsAfterEpoch = accessExpires;
            this.lastAccessUpdateMillisecondsAfterEpoch = lastAccessUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setAccessToken(String token) {
        this.checkUserSession("setAccessToken");
        Object object = this.lock;
        synchronized (object) {
            this.accessToken = token;
            this.lastAccessUpdateMillisecondsAfterEpoch = System.currentTimeMillis();
            this.sessionInvalidated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setAccessExpires(long timestampInMsec) {
        this.checkUserSession("setAccessExpires");
        Object object = this.lock;
        synchronized (object) {
            this.accessExpiresMillisecondsAfterEpoch = timestampInMsec;
            this.lastAccessUpdateMillisecondsAfterEpoch = System.currentTimeMillis();
            this.sessionInvalidated = true;
        }
    }

    @Deprecated
    public void setAccessExpiresIn(String expiresInSecsFromNow) {
        this.checkUserSession("setAccessExpiresIn");
        if (expiresInSecsFromNow != null) {
            long expires = expiresInSecsFromNow.equals("0") ? 0L : System.currentTimeMillis() + Long.parseLong(expiresInSecsFromNow) * 1000L;
            this.setAccessExpires(expires);
        }
    }

    @Deprecated
    public String getAppId() {
        return this.mAppId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setAppId(String appId) {
        this.checkUserSession("setAppId");
        Object object = this.lock;
        synchronized (object) {
            this.mAppId = appId;
            this.sessionInvalidated = true;
        }
    }

    private TokenCachingStrategy getTokenCache() {
        if (this.tokenCache == null) {
            this.tokenCache = new SetterTokenCachingStrategy();
        }
        return this.tokenCache;
    }

    private static String[] stringArray(List<String> list) {
        int size = list != null ? list.size() : 0;
        String[] array = new String[size];
        if (list != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = list.get(i);
            }
        }
        return array;
    }

    private static List<String> stringList(String[] array) {
        if (array != null) {
            return Arrays.asList(array);
        }
        return Collections.emptyList();
    }

    @Deprecated
    public static String getAttributionId(ContentResolver contentResolver) {
        return Settings.getAttributionId(contentResolver);
    }

    @Deprecated
    public boolean getShouldAutoPublishInstall() {
        return Settings.getShouldAutoPublishInstall();
    }

    @Deprecated
    public void setShouldAutoPublishInstall(boolean value) {
        Settings.setShouldAutoPublishInstall(value);
    }

    static /* synthetic */ String[] access$502(Facebook x0, String[] x1) {
        x0.pendingAuthorizationPermissions = x1;
        return x1;
    }

    public static interface ServiceListener {
        public void onComplete(Bundle var1);

        public void onFacebookError(FacebookError var1);

        public void onError(Error var1);
    }

    public static interface DialogListener {
        public void onComplete(Bundle var1);

        public void onFacebookError(FacebookError var1);

        public void onError(DialogError var1);

        public void onCancel();
    }

    private class SetterTokenCachingStrategy
    extends TokenCachingStrategy {
        private SetterTokenCachingStrategy() {
        }

        @Override
        public Bundle load() {
            Bundle bundle = new Bundle();
            if (Facebook.this.accessToken != null) {
                TokenCachingStrategy.putToken(bundle, Facebook.this.accessToken);
                TokenCachingStrategy.putExpirationMilliseconds(bundle, Facebook.this.accessExpiresMillisecondsAfterEpoch);
                TokenCachingStrategy.putPermissions(bundle, Facebook.stringList(Facebook.this.pendingAuthorizationPermissions));
                TokenCachingStrategy.putSource(bundle, AccessTokenSource.WEB_VIEW);
                TokenCachingStrategy.putLastRefreshMilliseconds(bundle, Facebook.this.lastAccessUpdateMillisecondsAfterEpoch);
            }
            return bundle;
        }

        @Override
        public void save(Bundle bundle) {
            Facebook.this.accessToken = TokenCachingStrategy.getToken(bundle);
            Facebook.this.accessExpiresMillisecondsAfterEpoch = TokenCachingStrategy.getExpirationMilliseconds(bundle);
            Facebook.access$502(Facebook.this, Facebook.stringArray(TokenCachingStrategy.getPermissions(bundle)));
            Facebook.this.lastAccessUpdateMillisecondsAfterEpoch = TokenCachingStrategy.getLastRefreshMilliseconds(bundle);
        }

        @Override
        public void clear() {
            Facebook.this.accessToken = null;
        }
    }

    private static class TokenRefreshConnectionHandler
    extends Handler {
        WeakReference<Facebook> facebookWeakReference;
        WeakReference<TokenRefreshServiceConnection> connectionWeakReference;

        TokenRefreshConnectionHandler(Facebook facebook, TokenRefreshServiceConnection connection) {
            this.facebookWeakReference = new WeakReference<Facebook>(facebook);
            this.connectionWeakReference = new WeakReference<TokenRefreshServiceConnection>(connection);
        }

        public void handleMessage(Message msg) {
            Facebook facebook = (Facebook)this.facebookWeakReference.get();
            TokenRefreshServiceConnection connection = (TokenRefreshServiceConnection)this.connectionWeakReference.get();
            if (facebook == null || connection == null) {
                return;
            }
            String token = msg.getData().getString(Facebook.TOKEN);
            long expiresAtMsecFromEpoch = msg.getData().getLong(Facebook.EXPIRES) * 1000L;
            if (token != null) {
                facebook.setAccessToken(token);
                facebook.setAccessExpires(expiresAtMsecFromEpoch);
                Session refreshSession = facebook.session;
                if (refreshSession != null) {
                    LegacyHelper.extendTokenCompleted(refreshSession, msg.getData());
                }
                if (connection.serviceListener != null) {
                    Bundle resultBundle = (Bundle)msg.getData().clone();
                    resultBundle.putLong(Facebook.EXPIRES, expiresAtMsecFromEpoch);
                    connection.serviceListener.onComplete(resultBundle);
                }
            } else if (connection.serviceListener != null) {
                String error = msg.getData().getString("error");
                if (msg.getData().containsKey("error_code")) {
                    int errorCode = msg.getData().getInt("error_code");
                    connection.serviceListener.onFacebookError(new FacebookError(error, null, errorCode));
                } else {
                    connection.serviceListener.onError(new Error(error != null ? error : "Unknown service error"));
                }
            }
            connection.applicationsContext.unbindService((ServiceConnection)connection);
        }
    }

    private class TokenRefreshServiceConnection
    implements ServiceConnection {
        final Messenger messageReceiver;
        final ServiceListener serviceListener;
        final Context applicationsContext;
        Messenger messageSender;

        public TokenRefreshServiceConnection(Context applicationsContext, ServiceListener serviceListener) {
            this.messageReceiver = new Messenger((Handler)new TokenRefreshConnectionHandler(Facebook.this, this));
            this.messageSender = null;
            this.applicationsContext = applicationsContext;
            this.serviceListener = serviceListener;
        }

        public void onServiceConnected(ComponentName className, IBinder service) {
            this.messageSender = new Messenger(service);
            this.refreshToken();
        }

        public void onServiceDisconnected(ComponentName arg) {
            this.serviceListener.onError(new Error("Service disconnected"));
            try {
                this.applicationsContext.unbindService((ServiceConnection)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void refreshToken() {
            Bundle requestData = new Bundle();
            requestData.putString(Facebook.TOKEN, Facebook.this.accessToken);
            Message request = Message.obtain();
            request.setData(requestData);
            request.replyTo = this.messageReceiver;
            try {
                this.messageSender.send(request);
            }
            catch (RemoteException e) {
                this.serviceListener.onError(new Error("Service connection error"));
            }
        }
    }
}

