/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.facebook.FacebookDialogException;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookServiceException;
import com.facebook.Session;
import com.facebook.android.R;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;

public class WebDialog
extends Dialog {
    private static final String LOG_TAG = "FacebookSDK.WebDialog";
    private static final String DISPLAY_TOUCH = "touch";
    static final String REDIRECT_URI = "fbconnect://success";
    static final String CANCEL_URI = "fbconnect://cancel";
    static final boolean DISABLE_SSL_CHECK_FOR_TESTING = false;
    private static final int NO_PADDING_SCREEN_WIDTH = 480;
    private static final int MAX_PADDING_SCREEN_WIDTH = 800;
    private static final int NO_PADDING_SCREEN_HEIGHT = 800;
    private static final int MAX_PADDING_SCREEN_HEIGHT = 1280;
    private static final double MIN_SCALE_FACTOR = 0.5;
    private static final int BACKGROUND_GRAY = -872415232;
    public static final int DEFAULT_THEME = 0x1030010;
    private String url;
    private String expectedRedirectUrl = "fbconnect://success";
    private OnCompleteListener onCompleteListener;
    private WebView webView;
    private ProgressDialog spinner;
    private ImageView crossImageView;
    private FrameLayout contentFrameLayout;
    private boolean listenerCalled = false;
    private boolean isDetached = false;

    public WebDialog(Context context, String url) {
        this(context, url, 0x1030010);
    }

    public WebDialog(Context context, String url, int theme) {
        super(context, theme);
        this.url = url;
    }

    public WebDialog(Context context, String action, Bundle parameters, int theme, OnCompleteListener listener) {
        super(context, theme);
        if (parameters == null) {
            parameters = new Bundle();
        }
        parameters.putString("redirect_uri", REDIRECT_URI);
        parameters.putString("display", DISPLAY_TOUCH);
        Uri uri = Utility.buildUri(ServerProtocol.getDialogAuthority(), ServerProtocol.getAPIVersion() + "/" + "dialog/" + action, parameters);
        this.url = uri.toString();
        this.onCompleteListener = listener;
    }

    public void setOnCompleteListener(OnCompleteListener listener) {
        this.onCompleteListener = listener;
    }

    public OnCompleteListener getOnCompleteListener() {
        return this.onCompleteListener;
    }

    public void dismiss() {
        if (this.webView != null) {
            this.webView.stopLoading();
        }
        if (!this.isDetached) {
            if (this.spinner.isShowing()) {
                this.spinner.dismiss();
            }
            super.dismiss();
        }
    }

    public void onDetachedFromWindow() {
        this.isDetached = true;
        super.onDetachedFromWindow();
    }

    public void onAttachedToWindow() {
        this.isDetached = false;
        super.onAttachedToWindow();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                WebDialog.this.sendCancelToListener();
            }
        });
        this.spinner = new ProgressDialog(this.getContext());
        this.spinner.requestWindowFeature(1);
        this.spinner.setMessage((CharSequence)this.getContext().getString(R.string.com_facebook_loading));
        this.spinner.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                WebDialog.this.sendCancelToListener();
                WebDialog.this.dismiss();
            }
        });
        this.requestWindowFeature(1);
        this.contentFrameLayout = new FrameLayout(this.getContext());
        this.calculateSize();
        this.getWindow().setGravity(17);
        this.getWindow().setSoftInputMode(16);
        this.createCrossImage();
        int crossWidth = this.crossImageView.getDrawable().getIntrinsicWidth();
        this.setUpWebView(crossWidth / 2 + 1);
        this.contentFrameLayout.addView((View)this.crossImageView, new ViewGroup.LayoutParams(-2, -2));
        this.setContentView((View)this.contentFrameLayout);
    }

    protected void setExpectedRedirectUrl(String expectedRedirectUrl) {
        this.expectedRedirectUrl = expectedRedirectUrl;
    }

    protected Bundle parseResponseUri(String urlString) {
        Uri u = Uri.parse((String)urlString);
        Bundle b = Utility.parseUrlQueryString(u.getQuery());
        b.putAll(Utility.parseUrlQueryString(u.getFragment()));
        return b;
    }

    private void calculateSize() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        int width = metrics.widthPixels < metrics.heightPixels ? metrics.widthPixels : metrics.heightPixels;
        int height = metrics.widthPixels < metrics.heightPixels ? metrics.heightPixels : metrics.widthPixels;
        int dialogWidth = Math.min(this.getScaledSize(width, metrics.density, 480, 800), metrics.widthPixels);
        int dialogHeight = Math.min(this.getScaledSize(height, metrics.density, 800, 1280), metrics.heightPixels);
        this.getWindow().setLayout(dialogWidth, dialogHeight);
    }

    private int getScaledSize(int screenSize, float density, int noPaddingSize, int maxPaddingSize) {
        int scaledSize = (int)((float)screenSize / density);
        double scaleFactor = scaledSize <= noPaddingSize ? 1.0 : (scaledSize >= maxPaddingSize ? 0.5 : 0.5 + (double)(maxPaddingSize - scaledSize) / (double)(maxPaddingSize - noPaddingSize) * 0.5);
        return (int)((double)screenSize * scaleFactor);
    }

    private void sendSuccessToListener(Bundle values) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            this.onCompleteListener.onComplete(values, null);
        }
    }

    private void sendErrorToListener(Throwable error) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            FacebookException facebookException = null;
            facebookException = error instanceof FacebookException ? (FacebookException)error : new FacebookException(error);
            this.onCompleteListener.onComplete(null, facebookException);
        }
    }

    private void sendCancelToListener() {
        this.sendErrorToListener(new FacebookOperationCanceledException());
    }

    private void createCrossImage() {
        this.crossImageView = new ImageView(this.getContext());
        this.crossImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WebDialog.this.sendCancelToListener();
                WebDialog.this.dismiss();
            }
        });
        Drawable crossDrawable = this.getContext().getResources().getDrawable(R.drawable.com_facebook_close);
        this.crossImageView.setImageDrawable(crossDrawable);
        this.crossImageView.setVisibility(4);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setUpWebView(int margin) {
        LinearLayout webViewContainer = new LinearLayout(this.getContext());
        this.webView = new WebView(this.getContext());
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setHorizontalScrollBarEnabled(false);
        this.webView.setWebViewClient((WebViewClient)new DialogWebViewClient());
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.loadUrl(this.url);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.webView.setVisibility(4);
        this.webView.getSettings().setSavePassword(false);
        this.webView.getSettings().setSaveFormData(false);
        webViewContainer.setPadding(margin, margin, margin, margin);
        webViewContainer.addView((View)this.webView);
        webViewContainer.setBackgroundColor(-872415232);
        this.contentFrameLayout.addView((View)webViewContainer);
    }

    public static class RequestsDialogBuilder
    extends BuilderBase<RequestsDialogBuilder> {
        private static final String APPREQUESTS_DIALOG = "apprequests";
        private static final String MESSAGE_PARAM = "message";
        private static final String TO_PARAM = "to";
        private static final String DATA_PARAM = "data";
        private static final String TITLE_PARAM = "title";

        public RequestsDialogBuilder(Context context) {
            super(context, APPREQUESTS_DIALOG);
        }

        public RequestsDialogBuilder(Context context, Session session) {
            super(context, session, APPREQUESTS_DIALOG, null);
        }

        public RequestsDialogBuilder(Context context, Session session, Bundle parameters) {
            super(context, session, APPREQUESTS_DIALOG, parameters);
        }

        public RequestsDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super(context, applicationId, APPREQUESTS_DIALOG, parameters);
        }

        public RequestsDialogBuilder setMessage(String message) {
            this.getParameters().putString(MESSAGE_PARAM, message);
            return this;
        }

        public RequestsDialogBuilder setTo(String id2) {
            this.getParameters().putString(TO_PARAM, id2);
            return this;
        }

        public RequestsDialogBuilder setData(String data) {
            this.getParameters().putString(DATA_PARAM, data);
            return this;
        }

        public RequestsDialogBuilder setTitle(String title) {
            this.getParameters().putString(TITLE_PARAM, title);
            return this;
        }
    }

    public static class FeedDialogBuilder
    extends BuilderBase<FeedDialogBuilder> {
        private static final String FEED_DIALOG = "feed";
        private static final String FROM_PARAM = "from";
        private static final String TO_PARAM = "to";
        private static final String LINK_PARAM = "link";
        private static final String PICTURE_PARAM = "picture";
        private static final String SOURCE_PARAM = "source";
        private static final String NAME_PARAM = "name";
        private static final String CAPTION_PARAM = "caption";
        private static final String DESCRIPTION_PARAM = "description";

        public FeedDialogBuilder(Context context) {
            super(context, FEED_DIALOG);
        }

        public FeedDialogBuilder(Context context, Session session) {
            super(context, session, FEED_DIALOG, null);
        }

        public FeedDialogBuilder(Context context, Session session, Bundle parameters) {
            super(context, session, FEED_DIALOG, parameters);
        }

        public FeedDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super(context, applicationId, FEED_DIALOG, parameters);
        }

        public FeedDialogBuilder setFrom(String id2) {
            this.getParameters().putString(FROM_PARAM, id2);
            return this;
        }

        public FeedDialogBuilder setTo(String id2) {
            this.getParameters().putString(TO_PARAM, id2);
            return this;
        }

        public FeedDialogBuilder setLink(String link) {
            this.getParameters().putString(LINK_PARAM, link);
            return this;
        }

        public FeedDialogBuilder setPicture(String picture) {
            this.getParameters().putString(PICTURE_PARAM, picture);
            return this;
        }

        public FeedDialogBuilder setSource(String source) {
            this.getParameters().putString(SOURCE_PARAM, source);
            return this;
        }

        public FeedDialogBuilder setName(String name) {
            this.getParameters().putString(NAME_PARAM, name);
            return this;
        }

        public FeedDialogBuilder setCaption(String caption) {
            this.getParameters().putString(CAPTION_PARAM, caption);
            return this;
        }

        public FeedDialogBuilder setDescription(String description) {
            this.getParameters().putString(DESCRIPTION_PARAM, description);
            return this;
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        public Builder(Context context, String action) {
            super(context, action);
        }

        public Builder(Context context, Session session, String action, Bundle parameters) {
            super(context, session, action, parameters);
        }

        public Builder(Context context, String applicationId, String action, Bundle parameters) {
            super(context, applicationId, action, parameters);
        }
    }

    private static class BuilderBase<CONCRETE extends BuilderBase<?>> {
        private Context context;
        private Session session;
        private String applicationId;
        private String action;
        private int theme = 0x1030010;
        private OnCompleteListener listener;
        private Bundle parameters;

        protected BuilderBase(Context context, String action) {
            Session activeSession = Session.getActiveSession();
            if (activeSession != null && activeSession.isOpened()) {
                this.session = activeSession;
            } else {
                String applicationId = Utility.getMetadataApplicationId(context);
                if (applicationId != null) {
                    this.applicationId = applicationId;
                } else {
                    throw new FacebookException("Attempted to create a builder without an open Active Session or a valid default Application ID.");
                }
            }
            this.finishInit(context, action, null);
        }

        protected BuilderBase(Context context, Session session, String action, Bundle parameters) {
            Validate.notNull(session, "session");
            if (!session.isOpened()) {
                throw new FacebookException("Attempted to use a Session that was not open.");
            }
            this.session = session;
            this.finishInit(context, action, parameters);
        }

        protected BuilderBase(Context context, String applicationId, String action, Bundle parameters) {
            if (applicationId == null) {
                applicationId = Utility.getMetadataApplicationId(context);
            }
            Validate.notNullOrEmpty(applicationId, "applicationId");
            this.applicationId = applicationId;
            this.finishInit(context, action, parameters);
        }

        public CONCRETE setTheme(int theme) {
            this.theme = theme;
            BuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setOnCompleteListener(OnCompleteListener listener) {
            this.listener = listener;
            BuilderBase result = this;
            return (CONCRETE)result;
        }

        public WebDialog build() {
            if (this.session != null && this.session.isOpened()) {
                this.parameters.putString("app_id", this.session.getApplicationId());
                this.parameters.putString("access_token", this.session.getAccessToken());
            } else {
                this.parameters.putString("app_id", this.applicationId);
            }
            return new WebDialog(this.context, this.action, this.parameters, this.theme, this.listener);
        }

        protected String getApplicationId() {
            return this.applicationId;
        }

        protected Context getContext() {
            return this.context;
        }

        protected int getTheme() {
            return this.theme;
        }

        protected Bundle getParameters() {
            return this.parameters;
        }

        protected OnCompleteListener getListener() {
            return this.listener;
        }

        private void finishInit(Context context, String action, Bundle parameters) {
            this.context = context;
            this.action = action;
            this.parameters = parameters != null ? parameters : new Bundle();
        }
    }

    private class DialogWebViewClient
    extends WebViewClient {
        private DialogWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Utility.logd(WebDialog.LOG_TAG, "Redirect URL: " + url);
            if (url.startsWith(WebDialog.this.expectedRedirectUrl)) {
                String errorMessage;
                Bundle values = WebDialog.this.parseResponseUri(url);
                String error = values.getString("error");
                if (error == null) {
                    error = values.getString("error_type");
                }
                if ((errorMessage = values.getString("error_msg")) == null) {
                    errorMessage = values.getString("error_description");
                }
                String errorCodeString = values.getString("error_code");
                int errorCode = -1;
                if (!Utility.isNullOrEmpty(errorCodeString)) {
                    try {
                        errorCode = Integer.parseInt(errorCodeString);
                    }
                    catch (NumberFormatException ex) {
                        errorCode = -1;
                    }
                }
                if (Utility.isNullOrEmpty(error) && Utility.isNullOrEmpty(errorMessage) && errorCode == -1) {
                    WebDialog.this.sendSuccessToListener(values);
                } else if (error != null && (error.equals("access_denied") || error.equals("OAuthAccessDeniedException"))) {
                    WebDialog.this.sendCancelToListener();
                } else {
                    FacebookRequestError requestError = new FacebookRequestError(errorCode, error, errorMessage);
                    WebDialog.this.sendErrorToListener(new FacebookServiceException(requestError, errorMessage));
                }
                WebDialog.this.dismiss();
                return true;
            }
            if (url.startsWith(WebDialog.CANCEL_URI)) {
                WebDialog.this.sendCancelToListener();
                WebDialog.this.dismiss();
                return true;
            }
            if (url.contains(WebDialog.DISPLAY_TOUCH)) {
                return false;
            }
            WebDialog.this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
            return true;
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            WebDialog.this.sendErrorToListener(new FacebookDialogException(description, errorCode, failingUrl));
            WebDialog.this.dismiss();
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            super.onReceivedSslError(view, handler, error);
            WebDialog.this.sendErrorToListener(new FacebookDialogException(null, -11, null));
            handler.cancel();
            WebDialog.this.dismiss();
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            Utility.logd(WebDialog.LOG_TAG, "Webview loading URL: " + url);
            super.onPageStarted(view, url, favicon);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.show();
            }
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.dismiss();
            }
            WebDialog.this.contentFrameLayout.setBackgroundColor(0);
            WebDialog.this.webView.setVisibility(0);
            WebDialog.this.crossImageView.setVisibility(0);
        }
    }

    public static interface OnCompleteListener {
        public void onComplete(Bundle var1, FacebookException var2);
    }
}

