/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.VideoAutoplayBehavior;
import com.facebook.ads.internal.api.NativeAdApi;
import com.facebook.ads.internal.api.NativeAdBaseApi;
import com.facebook.ads.internal.bench.Benchmark;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import com.facebook.ads.internal.util.common.Preconditions;
import com.facebook.infer.annotation.Nullsafe;
import java.util.List;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@Keep
@UiThread
public class NativeAd
extends NativeAdBase {
    private NativeAdApi mNativeAdApi;
    @Nullable
    private NativeOptions mNativeOptions;

    public NativeAd(Context context, String placementId) {
        super(context, placementId);
        this.mNativeAdApi = DynamicLoaderFactory.makeLoader(context).createNativeAdApi(this, this.mNativeAdBaseApi);
    }

    public NativeAd(Context context, NativeAdBaseApi nativeAdBaseApi) {
        super(nativeAdBaseApi);
        this.mNativeAdApi = DynamicLoaderFactory.makeLoader(context).createNativeAdApi(this, this.mNativeAdBaseApi);
    }

    public NativeAd(Context context, NativeAdBase other) {
        super(context, other);
        this.mNativeAdApi = DynamicLoaderFactory.makeLoader(context).createNativeAdApi(other, this, this.mNativeAdBaseApi);
    }

    public NativeAd(Context context, NativeAdBase other, @Nullable NativeOptions nativeOptions) {
        super(context, other);
        this.mNativeOptions = nativeOptions;
        this.mNativeAdApi = DynamicLoaderFactory.makeLoader(context).createNativeAdApi(other, this, this.mNativeAdBaseApi);
    }

    public NativeAd(Context context, String placementId, @Nullable NativeOptions nativeOptions) {
        super(context, placementId);
        this.mNativeOptions = nativeOptions;
        this.mNativeAdApi = DynamicLoaderFactory.makeLoader(context).createNativeAdApi(this, this.mNativeAdBaseApi);
    }

    public NativeAd(Context context, NativeAdBaseApi nativeAdBaseApi, @Nullable NativeOptions nativeOptions) {
        super(nativeAdBaseApi);
        this.mNativeOptions = nativeOptions;
        this.mNativeAdApi = DynamicLoaderFactory.makeLoader(context).createNativeAdApi(this, this.mNativeAdBaseApi);
    }

    @Nullable
    public NativeOptions getNativeOptions() {
        return this.mNativeOptions;
    }

    public NativeAdApi getNativeAdApi() {
        return this.mNativeAdApi;
    }

    @Deprecated
    VideoAutoplayBehavior getVideoAutoplayBehavior() {
        return this.mNativeAdApi.getVideoAutoplayBehavior();
    }

    public AdCreativeType getAdCreativeType() {
        return this.mNativeAdApi.getAdCreativeType();
    }

    public void registerViewForInteraction(View view, MediaView mediaView) {
        Preconditions.checkIsOnMainThread();
        this.mNativeAdApi.registerViewForInteraction(view, mediaView);
    }

    public void registerViewForInteraction(View view, MediaView mediaView, @Nullable MediaView adIconView) {
        Preconditions.checkIsOnMainThread();
        this.mNativeAdApi.registerViewForInteraction(view, mediaView, adIconView);
    }

    public void registerViewForInteraction(View view, MediaView mediaView, @Nullable List<View> clickableViews) {
        Preconditions.checkIsOnMainThread();
        this.mNativeAdApi.registerViewForInteraction(view, mediaView, clickableViews);
    }

    public void registerViewForInteraction(View view, MediaView mediaView, @Nullable MediaView adIconView, @Nullable List<View> clickableViews) {
        Preconditions.checkIsOnMainThread();
        this.mNativeAdApi.registerViewForInteraction(view, mediaView, adIconView, clickableViews);
    }

    public void registerViewForInteraction(View view, MediaView mediaView, @Nullable ImageView iconView) {
        Preconditions.checkIsOnMainThread();
        this.mNativeAdApi.registerViewForInteraction(view, mediaView, iconView);
    }

    public void registerViewForInteraction(View view, MediaView mediaView, @Nullable ImageView iconView, @Nullable List<View> clickableViews) {
        Preconditions.checkIsOnMainThread();
        this.mNativeAdApi.registerViewForInteraction(view, mediaView, iconView, clickableViews);
    }

    @Keep
    public static class NativeOptions {
        @Nullable
        private Boolean mDisableFullScreen = null;
        @Nullable
        private Boolean mHideMediaControls = null;
        @Nullable
        private Boolean mUnMuteVolume = null;

        @Benchmark
        public NativeOptions() {
        }

        public NativeOptions setDisableFullScreen(Boolean disableFullScreen) {
            this.mDisableFullScreen = disableFullScreen;
            return this;
        }

        public NativeOptions setHideMediaControls(Boolean hideMediaControls) {
            this.mHideMediaControls = hideMediaControls;
            return this;
        }

        public NativeOptions setUnMuteVolume(Boolean unMuteVolume) {
            this.mUnMuteVolume = unMuteVolume;
            return this;
        }

        @Nullable
        public Boolean getDisableFullScreen() {
            return this.mDisableFullScreen;
        }

        @Nullable
        public Boolean getHideMediaControls() {
            return this.mHideMediaControls;
        }

        @Nullable
        public Boolean getUnMuteVolume() {
            return this.mUnMuteVolume;
        }
    }

    @Keep
    public static enum AdCreativeType {
        IMAGE,
        VIDEO,
        CAROUSEL,
        UNKNOWN;

    }
}

