/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.facebook.ads.AdClosedListener;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdLayout;
import com.facebook.ads.internal.api.AdComponentFrameLayout;
import com.facebook.ads.internal.api.AdOptionsViewApi;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@Keep
public class AdOptionsView
extends AdComponentFrameLayout {
    private final AdOptionsViewApi mAdOptionsViewApi;

    public AdOptionsView(Context context, NativeAdBase nativeAdBase, @Nullable NativeAdLayout nativeAdLayout) {
        super(context);
        this.mAdOptionsViewApi = DynamicLoaderFactory.makeLoader(context).createAdOptionsView(context, nativeAdBase, nativeAdLayout, this);
        this.attachAdComponentViewApi(this.mAdOptionsViewApi);
    }

    public AdOptionsView(Context context, NativeAdBase nativeAdBase, @Nullable NativeAdLayout nativeAdLayout, Orientation orientation, int iconSizeDp) {
        super(context);
        this.mAdOptionsViewApi = DynamicLoaderFactory.makeLoader(context).createAdOptionsView(context, nativeAdBase, nativeAdLayout, orientation, iconSizeDp, this);
        this.attachAdComponentViewApi(this.mAdOptionsViewApi);
    }

    public void setIconColor(int color) {
        this.mAdOptionsViewApi.setIconColor(color);
    }

    public void setIconSizeDp(int iconSizeDp) {
        this.mAdOptionsViewApi.setIconSizeDp(iconSizeDp);
    }

    public void setSingleIcon(boolean singleIcon) {
        this.mAdOptionsViewApi.setSingleIcon(singleIcon);
    }

    public void setOnAdClosedListener(AdClosedListener adClosedListener) {
        this.mAdOptionsViewApi.setOnAdClosedListener(adClosedListener);
    }

    @Keep
    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

