/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.UiThread;
import com.facebook.ads.MediaViewListener;
import com.facebook.ads.MediaViewVideoRenderer;
import com.facebook.ads.internal.api.AdNativeComponentView;
import com.facebook.ads.internal.api.AdViewConstructorParams;
import com.facebook.ads.internal.api.MediaViewApi;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@Keep
@UiThread
public class MediaView
extends AdNativeComponentView {
    private MediaViewApi mMediaViewApi;
    private AdViewConstructorParams mConstructorParams;

    public MediaView(Context context) {
        super(context);
        this.initializeSelf(new AdViewConstructorParams(context));
    }

    public MediaView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initializeSelf(new AdViewConstructorParams(context, attrs));
    }

    public MediaView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeSelf(new AdViewConstructorParams(context, attrs, defStyleAttr));
    }

    @TargetApi(value=21)
    public MediaView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initializeSelf(new AdViewConstructorParams(context, attrs, defStyleAttr, defStyleRes));
    }

    private void initializeSelf(AdViewConstructorParams constructorParams) {
        this.mConstructorParams = constructorParams;
        this.mMediaViewApi = DynamicLoaderFactory.makeLoader(constructorParams.getContext()).createMediaViewApi();
        this.attachAdComponentViewApi(this.mMediaViewApi);
        this.mMediaViewApi.initialize(constructorParams, this);
    }

    public MediaViewApi getMediaViewApi() {
        return this.mMediaViewApi;
    }

    public void setVideoRenderer(MediaViewVideoRenderer newVideoRenderer) {
        this.mMediaViewApi.setVideoRenderer(newVideoRenderer);
    }

    public int getMediaWidth() {
        return this.mMediaViewApi.getMediaWidth();
    }

    public int getMediaHeight() {
        return this.mMediaViewApi.getMediaHeight();
    }

    @Override
    public View getAdContentsView() {
        return this.mMediaViewApi.getAdContentsView();
    }

    public void setListener(MediaViewListener listener) {
        this.mMediaViewApi.setListener(listener);
    }

    public void destroy() {
        this.mMediaViewApi.destroy();
    }

    public void repair(Throwable t) {
        this.post(new Runnable(){

            @Override
            public void run() {
                MediaView.this.removeAllViews();
                MediaView.this.mAdComponentViewApi = null;
                MediaView.this.mMediaViewApi = DynamicLoaderFactory.makeLoader(MediaView.this.mConstructorParams.getContext()).createMediaViewApi();
                MediaView.this.attachAdComponentViewApi(MediaView.this.mMediaViewApi);
                MediaView.this.mMediaViewApi.initialize(MediaView.this.mConstructorParams, MediaView.this);
            }
        });
    }
}

