/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import com.facebook.ads.AdSettings;
import com.facebook.ads.internal.api.NativeAdViewAttributesApi;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;

@Keep
public class NativeAdViewAttributes {
    private final NativeAdViewAttributesApi mNativeAdViewAttributesApi;

    public NativeAdViewAttributes(Context context) {
        this.mNativeAdViewAttributesApi = DynamicLoaderFactory.makeLoader(context).createNativeAdViewAttributesApi();
    }

    @Deprecated
    public NativeAdViewAttributes() {
        this.mNativeAdViewAttributesApi = DynamicLoaderFactory.makeLoaderUnsafe().createNativeAdViewAttributesApi();
    }

    public NativeAdViewAttributesApi getInternalAttributes() {
        return this.mNativeAdViewAttributesApi;
    }

    public NativeAdViewAttributes setTypeface(Typeface typeface) {
        this.mNativeAdViewAttributesApi.setTypeface(typeface);
        return this;
    }

    public NativeAdViewAttributes setBackgroundColor(int backgroundColor) {
        this.mNativeAdViewAttributesApi.setBackgroundColor(backgroundColor);
        return this;
    }

    public NativeAdViewAttributes setTitleTextColor(int titleTextColor) {
        this.mNativeAdViewAttributesApi.setPrimaryTextColor(titleTextColor);
        return this;
    }

    public NativeAdViewAttributes setDescriptionTextColor(int descriptionTextColor) {
        this.mNativeAdViewAttributesApi.setSecondaryTextColor(descriptionTextColor);
        return this;
    }

    public NativeAdViewAttributes setButtonColor(int buttonColor) {
        this.mNativeAdViewAttributesApi.setCTABackgroundColor(buttonColor);
        return this;
    }

    public NativeAdViewAttributes setButtonTextColor(int buttonTextColor) {
        this.mNativeAdViewAttributesApi.setCTATextColor(buttonTextColor);
        return this;
    }

    public NativeAdViewAttributes setButtonBorderColor(int buttonBorderColor) {
        this.mNativeAdViewAttributesApi.setCTABorderColor(buttonBorderColor);
        return this;
    }

    @Deprecated
    public NativeAdViewAttributes setAutoplayOnMobile(boolean autoplay) {
        return this;
    }

    @Deprecated
    public NativeAdViewAttributes setAutoplay(boolean autoplay) {
        return this;
    }

    @Deprecated
    public boolean getAutoplay() {
        return AdSettings.isVideoAutoplay();
    }

    @Deprecated
    public boolean getAutoplayOnMobile() {
        return AdSettings.isVideoAutoplayOnMobile();
    }

    @Deprecated
    @Nullable
    public Typeface getTypeface() {
        return null;
    }

    @Deprecated
    public int getBackgroundColor() {
        return 0;
    }

    @Deprecated
    public int getTitleTextColor() {
        return 0;
    }

    @Deprecated
    public int getDescriptionTextColor() {
        return 0;
    }

    @Deprecated
    public int getButtonColor() {
        return 0;
    }

    @Deprecated
    public int getButtonTextColor() {
        return 0;
    }

    @Deprecated
    public int getButtonBorderColor() {
        return 0;
    }

    @Deprecated
    public int getTitleTextSize() {
        return 0;
    }

    @Deprecated
    public int getDescriptionTextSize() {
        return 0;
    }
}

