/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.dynamicloading;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.BuildConfig;
import com.facebook.ads.internal.dynamicloading.DynamicLoader;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderImpl;
import com.facebook.ads.internal.settings.MultithreadedBundleWrapper;
import com.facebook.ads.internal.util.common.Preconditions;
import dalvik.system.DexClassLoader;
import dalvik.system.InMemoryDexClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

@Keep
public class DynamicLoaderFactory {
    private static final String DYNAMIC_LOADING_BUILD_TYPE = "releaseDL";
    public static final boolean LOAD_FROM_ASSETS = "releaseDL".equals(BuildConfig.BUILD_TYPE);
    private static final String CODE_CACHE_DIR = "code_cache";
    private static final String AUDIENCE_NETWORK_DEX = "audience_network.dex";
    private static final String AUDIENCE_NETWORK_CODE_PATH = "audience_network";
    private static final String OPTIMIZED_DEX_PATH = "optimized";
    private static DynamicLoader sDynamicLoader;
    private static boolean sUseLegacyClassLoader;

    @SuppressLint(value={"CatchGeneralException"})
    public static synchronized DynamicLoader makeLoaderUnsafe() {
        if (sDynamicLoader == null) {
            if (!LOAD_FROM_ASSETS) {
                try {
                    sDynamicLoader = (DynamicLoader)Class.forName(DynamicLoaderImpl.class.getName()).newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                Context appContext = DynamicLoaderFactory.getApplicationContextViaReflection();
                if (appContext != null) {
                    return DynamicLoaderFactory.makeLoader(appContext);
                }
                throw new RuntimeException("You must call AudienceNetworkAds.buildInitSettings(Context).initialize() before you can use Audience Network SDK.");
            }
        }
        return sDynamicLoader;
    }

    public static synchronized void initialize(final Context context, final @Nullable MultithreadedBundleWrapper initSettings, final @Nullable AudienceNetworkAds.InitListener initListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                DynamicLoaderFactory.makeLoader(context).createAudienceNetworkAdsApi().initialize(context, initSettings, initListener);
            }
        }).start();
    }

    public static synchronized DynamicLoader makeLoader(Context context) {
        Preconditions.checkNotNull(context, "Context can not be null.");
        if (sDynamicLoader == null) {
            try {
                if (!LOAD_FROM_ASSETS) {
                    sDynamicLoader = (DynamicLoader)Class.forName(DynamicLoaderImpl.class.getName()).newInstance();
                } else {
                    long startTime = System.currentTimeMillis();
                    ClassLoader adsSdkClassLoader = DynamicLoaderFactory.makeAdsSdkClassLoader(context.getApplicationContext());
                    sDynamicLoader = (DynamicLoader)adsSdkClassLoader.loadClass("com.facebook.ads.internal.dynamicloading.DynamicLoaderImpl").newInstance();
                    long loadingTime = System.currentTimeMillis() - startTime;
                    Log.d((String)"FBAudienceNetwork", (String)("SDK dex loading time: " + loadingTime));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sDynamicLoader;
    }

    public static void setUseLegacyClassLoader(boolean useLegacyClassLoader) {
        sUseLegacyClassLoader = useLegacyClassLoader;
    }

    @Nullable
    public static synchronized DynamicLoader getDynamicLoader() {
        return sDynamicLoader;
    }

    private static DexClassLoader makeLegacyAdsSdkClassLoader(Context context) throws Exception {
        int length;
        String adsSdkDataDirLocation = context.getFilesDir().getPath() + File.separator + AUDIENCE_NETWORK_DEX;
        InputStream is = context.getAssets().open(AUDIENCE_NETWORK_DEX);
        FileOutputStream os = new FileOutputStream(adsSdkDataDirLocation);
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) > 0) {
            ((OutputStream)os).write(buffer, 0, length);
        }
        is.close();
        os.flush();
        ((OutputStream)os).close();
        File optimizedLibraryPath = context.getDir(OPTIMIZED_DEX_PATH, 0);
        return new DexClassLoader(adsSdkDataDirLocation, optimizedLibraryPath.getPath(), null, DynamicLoaderFactory.class.getClassLoader());
    }

    private static ClassLoader makeAdsSdkClassLoader(Context context) throws Exception {
        int length;
        if (sUseLegacyClassLoader) {
            return DynamicLoaderFactory.makeLegacyAdsSdkClassLoader(context);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return DynamicLoaderFactory.createInMemoryClassLoader(context);
        }
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        File codeCacheDir = DynamicLoaderFactory.getCodeCacheDir(context, new File(applicationInfo.dataDir));
        File audienceNetworkCodeCacheDir = DynamicLoaderFactory.getSecondaryDir(codeCacheDir);
        String adsSdkDataDirLocation = audienceNetworkCodeCacheDir.getPath() + File.separator + AUDIENCE_NETWORK_DEX;
        InputStream is = context.getAssets().open(AUDIENCE_NETWORK_DEX);
        FileOutputStream os = new FileOutputStream(adsSdkDataDirLocation);
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) > 0) {
            ((OutputStream)os).write(buffer, 0, length);
        }
        is.close();
        os.flush();
        ((OutputStream)os).close();
        File optimizedAdsSdkDataDirLocation = new File(audienceNetworkCodeCacheDir.getPath() + File.separator + OPTIMIZED_DEX_PATH);
        DynamicLoaderFactory.mkdirChecked(optimizedAdsSdkDataDirLocation);
        return new DexClassLoader(adsSdkDataDirLocation, optimizedAdsSdkDataDirLocation.getPath(), null, context.getClassLoader());
    }

    @TargetApi(value=26)
    private static ClassLoader createInMemoryClassLoader(Context context) throws IOException {
        int length;
        InputStream is = context.getAssets().open(AUDIENCE_NETWORK_DEX);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) > 0) {
            os.write(buffer, 0, length);
        }
        is.close();
        os.flush();
        os.close();
        ByteBuffer dexBytesBuffer = ByteBuffer.wrap(os.toByteArray());
        return new InMemoryDexClassLoader(dexBytesBuffer, DynamicLoaderFactory.class.getClassLoader());
    }

    @Nullable
    @SuppressLint(value={"PrivateApi", "CatchGeneralException"})
    private static Context getApplicationContextViaReflection() {
        try {
            return (Context)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
        }
        catch (Throwable t) {
            Log.e((String)"FBAudienceNetwork", (String)"Failed to fetch Context from  ActivityThread. Audience Network SDK won't work unless you call AudienceNetworkAds.buildInitSettings().withListener(InitListener).initialize().", (Throwable)t);
            return null;
        }
    }

    private static File getCodeCacheDir(Context context, File dataDir) throws IOException {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getCodeCacheDir();
        }
        return DynamicLoaderFactory.getCacheCodeDirLegacy(context, dataDir);
    }

    private static File getCacheCodeDirLegacy(Context context, File dataDir) throws IOException {
        File cache = new File(dataDir, CODE_CACHE_DIR);
        try {
            DynamicLoaderFactory.mkdirChecked(cache);
        }
        catch (IOException var5) {
            cache = context.getDir(CODE_CACHE_DIR, 0);
            DynamicLoaderFactory.mkdirChecked(cache);
        }
        return cache;
    }

    private static File getSecondaryDir(File cache) throws IOException {
        File dexDir = new File(cache, AUDIENCE_NETWORK_CODE_PATH);
        DynamicLoaderFactory.mkdirChecked(dexDir);
        return dexDir;
    }

    private static void mkdirChecked(File dir) throws IOException {
        dir.mkdir();
        if (!dir.isDirectory()) {
            File parent = dir.getParentFile();
            if (parent == null) {
                Log.e((String)"FBAudienceNetwork", (String)("Failed to create dir " + dir.getPath() + ". Parent file is null."));
            } else {
                Log.e((String)"FBAudienceNetwork", (String)("Failed to create dir " + dir.getPath() + ". parent file is a dir " + parent.isDirectory() + ", a file " + parent.isFile() + ", exists " + parent.exists() + ", readable " + parent.canRead() + ", writable " + parent.canWrite()));
            }
            throw new IOException("Failed to create directory " + dir.getPath());
        }
    }

    static {
        sUseLegacyClassLoader = true;
    }
}

