/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.settings;

import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.facebook.ads.internal.dynamicloading.DynamicLoader;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import com.facebook.ads.internal.settings.MultithreadedBundleWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public class AdInternalSettings {
    public static final MultithreadedBundleWrapper sSettingsBundle = new MultithreadedBundleWrapper();
    public static final AtomicBoolean sDataProcessingOptionsUpdate = new AtomicBoolean(false);
    private static final String LIST_TEST_DEVICES_KEY = "LIST_TEST_DEVICES_KEY";
    private static final String BOOL_EXPLICIT_TEST_MODE_KEY = "BOOL_EXPLICIT_TEST_MODE_KEY";
    private static final String BOOL_VISIBLE_ANIMATION_KEY = "BOOL_VISIBLE_ANIMATION_KEY";
    private static final String STR_URL_PREFIX_KEY = "STR_URL_PREFIX_KEY";
    private static final String STR_MEDIATION_SERVICE_KEY = "STR_MEDIATION_SERVICE_KEY";
    private static final String BOOL_DEBUG_BUILD_KEY = "BOOL_DEBUG_BUILD_KEY";
    private static final String BOOL_DEBUGGER_STATE_KEY = "BOOL_DEBUGGER_STATE_KEY";
    private static final String BOOL_VIDEO_AUTOPLAY_KEY = "BOOL_VIDEO_AUTOPLAY_KEY";
    private static final String BOOL_AUTOPLAY_ON_MOBILE_KEY = "BOOL_AUTOPLAY_ON_MOBILE_KEY";
    public static final String BOOL_CHILD_DIRECTED_KEY = "BOOL_CHILD_DIRECTED_KEY";
    public static final String BOOL_MIXED_AUDIENCE_KEY = "BOOL_MIXED_AUDIENCE_KEY";
    public static final String TEST_AD_TYPE_KEY = "TEST_AD_TYPE_KEY";
    public static final String SRL_INTEGRATION_ERROR_MODE_KEY = "SRL_INTEGRATION_ERROR_MODE_KEY";
    public static final String DATA_PROCESSING_OPTIONS_KEY = "DATA_PROCESSING_OPTIONS_KEY";
    public static final String DATA_PROCESSING_OPTIONS_COUNTRY_KEY = "DATA_PROCESSING_OPTIONS_COUNTRY_KEY";
    public static final String DATA_PROCESSING_OPTIONS_STATE_KEY = "DATA_PROCESSING_OPTIONS_STATE_KEY";

    public static void setTestMode(boolean enabled) {
        sSettingsBundle.putBoolean(BOOL_EXPLICIT_TEST_MODE_KEY, enabled);
    }

    public static void setVisibleAnimation(boolean enabled) {
        sSettingsBundle.putBoolean(BOOL_VISIBLE_ANIMATION_KEY, enabled);
    }

    public static void setUrlPrefix(@Nullable String urlPrefix) {
        sSettingsBundle.putString(STR_URL_PREFIX_KEY, urlPrefix);
    }

    public static void setMediationService(String mediationService) {
        sSettingsBundle.putString(STR_MEDIATION_SERVICE_KEY, mediationService);
    }

    public static boolean isExplicitTestMode() {
        return sSettingsBundle.getBoolean(BOOL_EXPLICIT_TEST_MODE_KEY, false);
    }

    public static boolean isTestMode(Context context) {
        return DynamicLoaderFactory.makeLoader(context).createAdSettingsApi().isTestMode(context);
    }

    public static boolean isVisibleAnimation() {
        return sSettingsBundle.getBoolean(BOOL_VISIBLE_ANIMATION_KEY, false);
    }

    @Nullable
    public static String getUrlPrefix() {
        return sSettingsBundle.getString(STR_URL_PREFIX_KEY, null);
    }

    @Nullable
    public static String getMediationService() {
        return sSettingsBundle.getString(STR_MEDIATION_SERVICE_KEY, null);
    }

    public static void addTestDevices(Collection<String> deviceIdHashes) {
        AdInternalSettings.getTestDevicesList().addAll(deviceIdHashes);
    }

    public static void addTestDevice(String deviceIdHash) {
        AdInternalSettings.getTestDevicesList().add(deviceIdHash);
    }

    public static void clearTestDevices() {
        AdInternalSettings.getTestDevicesList().clear();
    }

    public static void turnOnSDKDebugger(Context context) {
        DynamicLoader dynamicLoader = DynamicLoaderFactory.getDynamicLoader();
        if (dynamicLoader != null) {
            dynamicLoader.createAdSettingsApi().turnOnDebugger();
        } else {
            sSettingsBundle.putBoolean(BOOL_DEBUGGER_STATE_KEY, true);
        }
    }

    public static void setDebugBuild(boolean isDebugBuild) {
        DynamicLoader dynamicLoader = DynamicLoaderFactory.getDynamicLoader();
        if (dynamicLoader != null && isDebugBuild) {
            dynamicLoader.createAdSettingsApi().turnOnDebugger();
        }
        sSettingsBundle.putBoolean(BOOL_DEBUG_BUILD_KEY, isDebugBuild);
    }

    public static boolean isVideoAutoplay() {
        return sSettingsBundle.getBoolean(BOOL_VIDEO_AUTOPLAY_KEY);
    }

    public static void setVideoAutoplay(boolean enabled) {
        sSettingsBundle.putBoolean(BOOL_VIDEO_AUTOPLAY_KEY, enabled);
    }

    public static void setVideoAutoplayOnMobile(boolean enabled) {
        sSettingsBundle.putBoolean(BOOL_AUTOPLAY_ON_MOBILE_KEY, enabled);
    }

    public static boolean isVideoAutoplayOnMobile() {
        return sSettingsBundle.getBoolean(BOOL_AUTOPLAY_ON_MOBILE_KEY, false);
    }

    public static boolean isDebugBuild() {
        return sSettingsBundle.getBoolean(BOOL_DEBUG_BUILD_KEY, false);
    }

    public static boolean isDebuggerOn() {
        return sSettingsBundle.getBoolean(BOOL_DEBUGGER_STATE_KEY, false);
    }

    public static ArrayList<String> getTestDevicesList() {
        ArrayList<String> stringArrayList = sSettingsBundle.getStringArrayList(LIST_TEST_DEVICES_KEY);
        if (stringArrayList == null) {
            stringArrayList = new ArrayList();
            sSettingsBundle.putStringArrayList(LIST_TEST_DEVICES_KEY, stringArrayList);
        }
        return stringArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDataProcessingOptions(String[] options, @Nullable Integer country, @Nullable Integer state) {
        MultithreadedBundleWrapper multithreadedBundleWrapper = sSettingsBundle;
        synchronized (multithreadedBundleWrapper) {
            sDataProcessingOptionsUpdate.set(true);
            sSettingsBundle.putStringArray(DATA_PROCESSING_OPTIONS_KEY, options);
            sSettingsBundle.putInteger(DATA_PROCESSING_OPTIONS_COUNTRY_KEY, country);
            sSettingsBundle.putInteger(DATA_PROCESSING_OPTIONS_STATE_KEY, state);
        }
    }
}

