/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.facebook.ads.NativeAd;
import com.facebook.ads.VideoAutoplayBehavior;
import com.facebook.ads.VideoStartReason;
import com.facebook.ads.internal.h.f;
import com.facebook.ads.internal.h.q;
import com.facebook.ads.internal.h.s;
import com.facebook.ads.internal.k.a.a;
import com.facebook.ads.internal.view.c.a.b;
import com.facebook.ads.internal.view.c.a.c;
import com.facebook.ads.internal.view.c.a.d;
import com.facebook.ads.internal.view.c.a.e;
import com.facebook.ads.internal.view.c.a.h;
import com.facebook.ads.internal.view.c.a.i;
import com.facebook.ads.internal.view.c.a.j;
import com.facebook.ads.internal.view.c.a.k;
import com.facebook.ads.internal.view.c.a.l;
import com.facebook.ads.internal.view.c.a.m;
import com.facebook.ads.internal.view.c.a.p;
import com.facebook.ads.internal.view.c.a.u;
import com.facebook.ads.internal.view.c.a.v;

public abstract class MediaViewVideoRenderer
extends FrameLayout {
    private static final String d = MediaViewVideoRenderer.class.getSimpleName();
    private final m e = new m(){

        @Override
        public void a(l l2) {
            MediaViewVideoRenderer.this.onPrepared();
        }
    };
    private final k f = new k(){

        @Override
        public void a(j j2) {
            MediaViewVideoRenderer.this.onPlayed();
        }
    };
    private final i g = new i(){

        @Override
        public void a(h h2) {
            MediaViewVideoRenderer.this.onPaused();
        }
    };
    private final com.facebook.ads.internal.view.c.a.q h = new com.facebook.ads.internal.view.c.a.q(){

        @Override
        public void a(p p2) {
            MediaViewVideoRenderer.this.onSeek();
        }
    };
    private final c i = new c(){

        @Override
        public void a(b b2) {
            MediaViewVideoRenderer.this.onCompleted();
        }
    };
    private final v j = new v(){

        @Override
        public void a(u u2) {
            MediaViewVideoRenderer.this.onVolumeChanged();
        }
    };
    private final e k = new e(){

        @Override
        public void a(d d2) {
            MediaViewVideoRenderer.this.onError();
        }
    };
    @Nullable
    protected NativeAd a;
    protected VideoAutoplayBehavior b;
    private boolean l;
    private boolean m;
    private boolean n = true;
    private boolean o = true;
    final com.facebook.ads.internal.view.p c;

    public MediaViewVideoRenderer(Context context) {
        super(context);
        this.c = new com.facebook.ads.internal.view.p(context);
        this.a();
    }

    public MediaViewVideoRenderer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.c = new com.facebook.ads.internal.view.p(context, attributeSet);
        this.a();
    }

    public MediaViewVideoRenderer(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.c = new com.facebook.ads.internal.view.p(context, attributeSet, n2);
        this.a();
    }

    @TargetApi(value=21)
    public MediaViewVideoRenderer(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        this.c = new com.facebook.ads.internal.view.p(context, attributeSet, n2, n3);
        this.a();
    }

    private void a() {
        this.c.setEnableBackgroundVideo(this.shouldAllowBackgroundPlayback());
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        this.c.setLayoutParams(layoutParams);
        this.addView((View)this.c);
        this.c.getEventBus().a((q)new s[]{this.e, this.f, this.g, this.h, this.i, this.j, this.k});
    }

    public void setNativeAd(NativeAd nativeAd) {
        this.a = nativeAd;
        this.c.a(nativeAd.d(), nativeAd.g());
        this.c.setVideoMPD(nativeAd.c());
        this.c.setVideoURI(nativeAd.b());
        this.c.setVideoCTA(nativeAd.getAdCallToAction());
        this.c.setNativeAd(nativeAd);
        this.b = nativeAd.e();
    }

    public void unsetNativeAd() {
        this.pause(false);
        this.c.a(null, null);
        this.c.setVideoMPD(null);
        this.c.setVideoURI((Uri)null);
        this.c.setVideoCTA(null);
        this.c.setNativeAd(null);
        this.b = VideoAutoplayBehavior.DEFAULT;
        this.a = null;
    }

    public final void play(VideoStartReason videoStartReason) {
        this.c.a(videoStartReason);
    }

    public final void pause(boolean bl) {
        this.c.a(bl);
    }

    @IntRange(from=0L)
    public final int getCurrentTimeMs() {
        return this.c.getCurrentPosition();
    }

    public final void engageSeek() {
        if (this.l) {
            Log.w((String)d, (String)"engageSeek called without disengageSeek.");
            return;
        }
        this.l = true;
        this.m = com.facebook.ads.internal.view.c.c.d.d.equals((Object)this.c.getState());
        this.c.a(false);
        this.onSeekEngaged();
    }

    public final void disengageSeek(VideoStartReason videoStartReason) {
        if (!this.l) {
            Log.w((String)d, (String)"disengageSeek called without engageSeek.");
            return;
        }
        this.l = false;
        if (this.m) {
            this.c.a(videoStartReason);
        }
        this.onSeekDisengaged();
    }

    public final void seekTo(@IntRange(from=0L) int n2) {
        if (!this.l) {
            Log.w((String)d, (String)"Seeking must be preceded by a call to engageSeek, and followed by a call to disengageSeek.");
            return;
        }
        this.c.a(n2);
    }

    @IntRange(from=0L)
    public final int getDuration() {
        return this.c.getDuration();
    }

    public final void setVolume(@FloatRange(from=0.0, to=1.0) float f2) {
        this.c.setVolume(f2);
    }

    @FloatRange(from=0.0, to=0.0)
    public final float getVolume() {
        return this.c.getVolume();
    }

    @Deprecated
    void setAutoplay(boolean bl) {
        this.n = bl;
    }

    @Deprecated
    void setAutoplayOnMobile(boolean bl) {
        this.o = bl;
    }

    public boolean shouldAutoplay() {
        if (this.c == null || this.c.getState() == com.facebook.ads.internal.view.c.c.d.g) {
            return false;
        }
        if (this.b == VideoAutoplayBehavior.DEFAULT) {
            return this.n && (this.o || com.facebook.ads.internal.k.a.a.c(this.getContext()) == a.a.c);
        }
        return this.b == VideoAutoplayBehavior.ON;
    }

    final void setAdEventManager(f f2) {
        this.c.setAdEventManager(f2);
    }

    final void setListener(com.facebook.ads.internal.view.q q2) {
        this.c.setListener(q2);
    }

    public void destroy() {
        this.c.k();
    }

    public void onPrepared() {
    }

    public void onPlayed() {
    }

    public void onPaused() {
    }

    public void onSeekEngaged() {
    }

    public void onSeek() {
    }

    public void onSeekDisengaged() {
    }

    public void onCompleted() {
    }

    public void onVolumeChanged() {
    }

    public void onError() {
    }

    public boolean shouldAllowBackgroundPlayback() {
        return false;
    }
}

