/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.CacheFlag;
import com.facebook.ads.internal.AdErrorType;
import com.facebook.ads.internal.adapters.AdAdapter;
import com.facebook.ads.internal.adapters.BannerAdapter;
import com.facebook.ads.internal.adapters.BannerAdapterListener;
import com.facebook.ads.internal.adapters.InterstitialAdapter;
import com.facebook.ads.internal.adapters.InterstitialAdapterListener;
import com.facebook.ads.internal.adapters.r;
import com.facebook.ads.internal.adapters.t;
import com.facebook.ads.internal.adapters.v;
import com.facebook.ads.internal.adapters.w;
import com.facebook.ads.internal.adapters.y;
import com.facebook.ads.internal.f.d;
import com.facebook.ads.internal.f.e;
import com.facebook.ads.internal.f.f;
import com.facebook.ads.internal.f.h;
import com.facebook.ads.internal.f.i;
import com.facebook.ads.internal.server.AdPlacementType;
import com.facebook.ads.internal.server.a;
import com.facebook.ads.internal.util.an;
import com.facebook.ads.internal.util.g;
import com.facebook.ads.internal.util.j;
import com.facebook.ads.internal.util.p;
import com.facebook.ads.internal.util.x;
import com.facebook.ads.internal.util.z;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisplayAdController
implements a.a {
    protected com.facebook.ads.internal.a a;
    private static final String b = DisplayAdController.class.getSimpleName();
    private final Context c;
    private final String d;
    private final AdPlacementType e;
    private final com.facebook.ads.internal.server.a f;
    private final Handler g = new Handler();
    private static final Handler h = new Handler(Looper.getMainLooper());
    private static boolean i = false;
    private final Runnable j;
    private final Runnable k;
    private volatile boolean l;
    private boolean m;
    private volatile boolean n;
    private AdAdapter o;
    private AdAdapter p;
    private View q;
    private d r;
    private f s;
    private com.facebook.ads.internal.f t;
    private com.facebook.ads.internal.d u;
    private AdSize v;
    private int w;
    private boolean x = false;
    private final c y;
    private boolean z;
    private final com.facebook.ads.internal.g.f A;
    private final EnumSet<CacheFlag> B;

    public DisplayAdController(Context context, String string, com.facebook.ads.internal.f f2, AdPlacementType adPlacementType, AdSize adSize, com.facebook.ads.internal.d d2, int n2, boolean bl) {
        this(context, string, f2, adPlacementType, adSize, d2, n2, bl, EnumSet.of(CacheFlag.NONE));
    }

    public DisplayAdController(Context context, String string, com.facebook.ads.internal.f f2, AdPlacementType adPlacementType, AdSize adSize, com.facebook.ads.internal.d d2, int n2, boolean bl, EnumSet<CacheFlag> enumSet) {
        this.c = context;
        this.d = string;
        this.t = f2;
        this.e = adPlacementType;
        this.v = adSize;
        this.u = d2;
        this.w = n2;
        this.y = new c();
        this.B = enumSet;
        this.f = new com.facebook.ads.internal.server.a(context);
        this.f.a(this);
        this.j = new a(this);
        this.k = new b(this);
        this.m = bl;
        this.h();
        try {
            CookieManager.getInstance();
            if (Build.VERSION.SDK_INT < 21) {
                CookieSyncManager.createInstance((Context)context);
            }
        }
        catch (Exception exception) {
            Log.w((String)b, (String)"Failed to initialize CookieManager.", (Throwable)exception);
        }
        com.facebook.ads.internal.d.a.a(context).a();
        this.A = com.facebook.ads.internal.g.g.a(context);
    }

    private void h() {
        if (this.m) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        this.c.registerReceiver((BroadcastReceiver)this.y, intentFilter);
        this.z = true;
    }

    private void i() {
        if (this.z) {
            try {
                this.c.unregisterReceiver((BroadcastReceiver)this.y);
                this.z = false;
            }
            catch (Exception exception) {
                com.facebook.ads.internal.util.c.a(com.facebook.ads.internal.util.b.a(exception, "Error unregistering screen state receiever"));
            }
        }
    }

    public void a(com.facebook.ads.internal.a a2) {
        this.a = a2;
    }

    public void a(boolean bl) {
        this.x = bl;
    }

    public e a() {
        if (this.r == null) {
            return null;
        }
        return this.r.a();
    }

    private void a(AdAdapter adAdapter) {
        if (adAdapter != null) {
            adAdapter.onDestroy();
        }
    }

    private AdPlacementType j() {
        if (this.e != null) {
            return this.e;
        }
        if (this.v == null) {
            return AdPlacementType.NATIVE;
        }
        if (this.v == AdSize.INTERSTITIAL) {
            return AdPlacementType.INTERSTITIAL;
        }
        return AdPlacementType.BANNER;
    }

    public void a(String string) {
        this.c(string);
    }

    private void c(String string) {
        j j2;
        try {
            j2 = new j(this.c, string, this.d, this.t);
        }
        catch (com.facebook.ads.internal.c c2) {
            this.a(c2.a());
            return;
        }
        this.s = new f(this.c, new h(this.c, false), this.d, this.v, this.t, this.u, this.w, AdSettings.isTestMode(this.c), j2);
        this.f.a(this.s);
    }

    public void b() {
        if (this.p == null) {
            throw new IllegalStateException("no adapter ready to start");
        }
        if (this.n) {
            throw new IllegalStateException("ad already started");
        }
        this.n = true;
        AdPlacementType adPlacementType = this.p.getPlacementType();
        switch (adPlacementType) {
            case INTERSTITIAL: {
                InterstitialAdapter interstitialAdapter = (InterstitialAdapter)this.p;
                interstitialAdapter.show();
                break;
            }
            case BANNER: {
                if (this.q == null) break;
                this.a.a(this.q);
                this.m();
                break;
            }
            case NATIVE: {
                v v2 = (v)this.p;
                if (!v2.b()) {
                    throw new IllegalStateException("ad is not ready or already displayed");
                }
                this.a.a(v2);
                break;
            }
            case INSTREAM: {
                r r2 = (r)this.p;
                r2.e();
                break;
            }
            case REWARDED_VIDEO: {
                com.facebook.ads.internal.adapters.x x2 = (com.facebook.ads.internal.adapters.x)this.p;
                x2.b();
                break;
            }
            default: {
                Log.e((String)b, (String)"start unexpected adapter type");
            }
        }
    }

    public void c() {
        this.b(false);
    }

    public void b(boolean bl) {
        this.i();
        if (!bl && !this.n) {
            return;
        }
        this.n();
        this.a(this.p);
        this.f.a();
        this.q = null;
        this.n = false;
    }

    public void d() {
        if (!this.n) {
            return;
        }
        this.n();
    }

    public void e() {
        if (!this.n) {
            return;
        }
        this.m();
    }

    public void b(String string) {
        this.n();
        this.c(string);
    }

    public void f() {
        this.m = true;
        this.n();
    }

    @Override
    public synchronized void a(final com.facebook.ads.internal.server.e e2) {
        this.o().post(new Runnable(){

            @Override
            public void run() {
                d d2 = e2.b();
                if (d2 == null || d2.a() == null) {
                    throw new IllegalStateException("invalid placement in response");
                }
                DisplayAdController.this.r = d2;
                DisplayAdController.this.k();
            }
        });
    }

    private synchronized void k() {
        h.post(new Runnable(){

            @Override
            public void run() {
                try {
                    DisplayAdController.this.l();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private void l() {
        this.o = null;
        d d2 = this.r;
        com.facebook.ads.internal.f.a a2 = d2.d();
        if (a2 == null) {
            this.a.a(AdErrorType.NO_FILL.getAdErrorWrapper(""));
            this.m();
            return;
        }
        String string = a2.a();
        AdAdapter adAdapter = com.facebook.ads.internal.adapters.d.a(string, d2.a().b());
        if (adAdapter == null) {
            Log.e((String)b, (String)("Adapter does not exist: " + string));
            this.k();
            return;
        }
        AdPlacementType adPlacementType = this.j();
        if (adPlacementType != adAdapter.getPlacementType()) {
            this.a.a(AdErrorType.INTERNAL_ERROR.getAdErrorWrapper(""));
            return;
        }
        this.o = adAdapter;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        e e2 = d2.a();
        hashMap.put("data", a2.b());
        hashMap.put("definition", e2);
        hashMap.put("placementId", this.d);
        hashMap.put("requestTime", e2.a());
        if (this.s == null) {
            com.facebook.ads.internal.b b2 = AdErrorType.UNKNOWN_ERROR.getAdErrorWrapper("environment is empty");
            this.a.a(b2);
            return;
        }
        switch (adAdapter.getPlacementType()) {
            case BANNER: {
                this.a((BannerAdapter)adAdapter, d2, hashMap);
                break;
            }
            case INTERSTITIAL: {
                this.a((InterstitialAdapter)adAdapter, d2, hashMap);
                break;
            }
            case NATIVE: {
                this.a((v)adAdapter, d2, a2, hashMap);
                break;
            }
            case INSTREAM: {
                this.a((r)adAdapter, d2, hashMap);
                break;
            }
            case REWARDED_VIDEO: {
                this.a((com.facebook.ads.internal.adapters.x)adAdapter, d2, hashMap);
                break;
            }
            default: {
                Log.e((String)b, (String)"attempt unexpected adapter type");
            }
        }
    }

    private void a(r r2, d d2, Map<String, Object> map) {
        r2.a(this.c, new com.facebook.ads.a.a(){

            @Override
            public void a(r r2) {
                DisplayAdController.this.p = r2;
                DisplayAdController.this.n = false;
                DisplayAdController.this.a.a(r2);
            }

            @Override
            public void a(r r2, View view) {
                DisplayAdController.this.a.a(view);
            }

            @Override
            public void a(r r2, AdError adError) {
                DisplayAdController.this.a.a(new com.facebook.ads.internal.b(adError.getErrorCode(), adError.getErrorMessage()));
            }

            @Override
            public void b(r r2) {
                DisplayAdController.this.a.a();
            }

            @Override
            public void c(r r2) {
                DisplayAdController.this.a.b();
            }

            @Override
            public void d(r r2) {
                DisplayAdController.this.a.c();
            }
        }, map, this.A, this.B);
    }

    private void a(com.facebook.ads.internal.adapters.x x2, d d2, Map<String, Object> map) {
        x2.a(this.c, new y(){

            @Override
            public void a(com.facebook.ads.internal.adapters.x x2) {
                DisplayAdController.this.p = x2;
                DisplayAdController.this.a.a(x2);
            }

            @Override
            public void a(com.facebook.ads.internal.adapters.x x2, AdError adError) {
                DisplayAdController.this.a.a(new com.facebook.ads.internal.b(AdErrorType.INTERNAL_ERROR, null));
                DisplayAdController.this.a(x2);
                DisplayAdController.this.k();
            }

            @Override
            public void b(com.facebook.ads.internal.adapters.x x2) {
                DisplayAdController.this.a.a();
            }

            @Override
            public void c(com.facebook.ads.internal.adapters.x x2) {
                DisplayAdController.this.a.b();
            }

            @Override
            public void d(com.facebook.ads.internal.adapters.x x2) {
                DisplayAdController.this.a.f();
            }

            @Override
            public void a() {
                DisplayAdController.this.a.g();
            }

            @Override
            public void e(com.facebook.ads.internal.adapters.x x2) {
                DisplayAdController.this.a.h();
            }

            @Override
            public void f(com.facebook.ads.internal.adapters.x x2) {
                DisplayAdController.this.a.i();
            }
        }, map, this.x);
    }

    private void a(final BannerAdapter bannerAdapter, d d2, Map<String, Object> map) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DisplayAdController.this.a(bannerAdapter);
                DisplayAdController.this.k();
            }
        };
        this.g.postDelayed(runnable, (long)d2.a().j());
        bannerAdapter.loadBannerAd(this.c, this.v, new BannerAdapterListener(){

            @Override
            public void onBannerAdLoaded(BannerAdapter bannerAdapter, View view) {
                if (bannerAdapter != DisplayAdController.this.o) {
                    return;
                }
                DisplayAdController.this.g.removeCallbacks(runnable);
                AdAdapter adAdapter = DisplayAdController.this.p;
                DisplayAdController.this.p = bannerAdapter;
                DisplayAdController.this.q = view;
                if (!DisplayAdController.this.n) {
                    DisplayAdController.this.a.a(bannerAdapter);
                } else {
                    DisplayAdController.this.a.a(view);
                    DisplayAdController.this.a(adAdapter);
                    DisplayAdController.this.m();
                }
            }

            @Override
            public void onBannerError(BannerAdapter bannerAdapter, AdError adError) {
                if (bannerAdapter != DisplayAdController.this.o) {
                    return;
                }
                DisplayAdController.this.g.removeCallbacks(runnable);
                DisplayAdController.this.a(bannerAdapter);
                DisplayAdController.this.k();
            }

            @Override
            public void onBannerLoggingImpression(BannerAdapter bannerAdapter) {
                DisplayAdController.this.a.b();
            }

            @Override
            public void onBannerAdClicked(BannerAdapter bannerAdapter) {
                DisplayAdController.this.a.a();
            }

            @Override
            public void onBannerAdExpanded(BannerAdapter bannerAdapter) {
                DisplayAdController.this.n();
            }

            @Override
            public void onBannerAdMinimized(BannerAdapter bannerAdapter) {
                DisplayAdController.this.m();
            }
        }, map);
    }

    private void a(final InterstitialAdapter interstitialAdapter, d d2, Map<String, Object> map) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DisplayAdController.this.a(interstitialAdapter);
                DisplayAdController.this.k();
            }
        };
        this.g.postDelayed(runnable, (long)d2.a().j());
        interstitialAdapter.loadInterstitialAd(this.c, new InterstitialAdapterListener(){

            @Override
            public void onInterstitialAdLoaded(InterstitialAdapter interstitialAdapter) {
                if (interstitialAdapter != DisplayAdController.this.o) {
                    return;
                }
                DisplayAdController.this.g.removeCallbacks(runnable);
                DisplayAdController.this.p = interstitialAdapter;
                DisplayAdController.this.a.a(interstitialAdapter);
                DisplayAdController.this.m();
            }

            @Override
            public void onInterstitialError(InterstitialAdapter interstitialAdapter, AdError adError) {
                if (interstitialAdapter != DisplayAdController.this.o) {
                    return;
                }
                DisplayAdController.this.g.removeCallbacks(runnable);
                DisplayAdController.this.a(interstitialAdapter);
                DisplayAdController.this.k();
                DisplayAdController.this.a.a(new com.facebook.ads.internal.b(adError.getErrorCode(), adError.getErrorMessage()));
            }

            @Override
            public void onInterstitialLoggingImpression(InterstitialAdapter interstitialAdapter) {
                DisplayAdController.this.a.b();
            }

            @Override
            public void onInterstitialAdClicked(InterstitialAdapter interstitialAdapter, String string, boolean bl) {
                boolean bl2;
                DisplayAdController.this.a.a();
                boolean bl3 = bl2 = !TextUtils.isEmpty((CharSequence)string);
                if (bl && bl2) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    if (!(((DisplayAdController)DisplayAdController.this).s.d instanceof Activity)) {
                        intent.addFlags(0x10000000);
                    }
                    intent.setData(Uri.parse((String)string));
                    ((DisplayAdController)DisplayAdController.this).s.d.startActivity(intent);
                }
            }

            @Override
            public void onInterstitialAdDisplayed(InterstitialAdapter interstitialAdapter) {
                DisplayAdController.this.a.d();
            }

            @Override
            public void onInterstitialAdDismissed(InterstitialAdapter interstitialAdapter) {
                DisplayAdController.this.a.e();
            }
        }, map, this.A, this.B);
    }

    private void a(final v v2, d d2, final com.facebook.ads.internal.f.a a2, Map<String, Object> map) {
        final long l2 = System.currentTimeMillis();
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DisplayAdController.this.a(v2);
                if (v2 instanceof t) {
                    com.facebook.ads.internal.util.g.a(DisplayAdController.this.c, com.facebook.ads.internal.util.x.a(((t)((Object)v2)).F()) + " Failed. Ad request timed out");
                }
                Map map = DisplayAdController.this.a(l2);
                map.put("error", "-1");
                map.put("msg", "timeout");
                DisplayAdController.this.a(a2.a(com.facebook.ads.internal.f.i.a), map);
                DisplayAdController.this.k();
            }
        };
        this.g.postDelayed(runnable, (long)d2.a().j());
        v2.a(this.c, new w(){
            boolean a = false;
            boolean b = false;
            boolean c = false;

            @Override
            public void a(v v2) {
                if (v2 != DisplayAdController.this.o) {
                    return;
                }
                DisplayAdController.this.g.removeCallbacks(runnable);
                DisplayAdController.this.p = v2;
                DisplayAdController.this.a.a((AdAdapter)v2);
                if (!this.a) {
                    this.a = true;
                    Map map = DisplayAdController.this.a(l2);
                    DisplayAdController.this.a(a2.a(com.facebook.ads.internal.f.i.a), map);
                }
            }

            @Override
            public void a(v v2, AdError adError) {
                if (v2 != DisplayAdController.this.o) {
                    return;
                }
                DisplayAdController.this.g.removeCallbacks(runnable);
                DisplayAdController.this.a(v2);
                if (!this.a) {
                    this.a = true;
                    Map map = DisplayAdController.this.a(l2);
                    map.put("error", String.valueOf(adError.getErrorCode()));
                    map.put("msg", String.valueOf(adError.getErrorMessage()));
                    DisplayAdController.this.a(a2.a(com.facebook.ads.internal.f.i.a), map);
                }
                DisplayAdController.this.k();
            }

            @Override
            public void b(v v2) {
                if (!this.b) {
                    this.b = true;
                    DisplayAdController.this.a(a2.a(com.facebook.ads.internal.f.i.b), null);
                }
            }

            @Override
            public void c(v v2) {
                if (!this.c) {
                    this.c = true;
                    DisplayAdController.this.a(a2.a(com.facebook.ads.internal.f.i.c), null);
                }
                if (DisplayAdController.this.a != null) {
                    DisplayAdController.this.a.a();
                }
            }
        }, this.A, map);
    }

    @Override
    public synchronized void a(final com.facebook.ads.internal.b b2) {
        this.o().post(new Runnable(){

            @Override
            public void run() {
                DisplayAdController.this.a.a(b2);
                if (DisplayAdController.this.m || DisplayAdController.this.l) {
                    return;
                }
                int n2 = b2.a().getErrorCode();
                switch (n2) {
                    case 1000: 
                    case 1002: {
                        switch (DisplayAdController.this.j()) {
                            case BANNER: {
                                DisplayAdController.this.g.postDelayed(DisplayAdController.this.j, 30000L);
                                DisplayAdController.this.l = true;
                            }
                        }
                    }
                }
            }
        });
    }

    private void m() {
        long l2;
        if (this.m || this.l) {
            return;
        }
        switch (this.j()) {
            case BANNER: {
                int n2 = this.r == null ? 1 : this.r.a().f();
                boolean bl = com.facebook.ads.internal.j.a.a(this.q, n2).a();
                if (this.q == null || bl) break;
                this.g.postDelayed(this.k, 1000L);
                return;
            }
            case INTERSTITIAL: {
                if (com.facebook.ads.internal.util.p.a(this.c)) break;
                this.g.postDelayed(this.k, 1000L);
                break;
            }
            default: {
                return;
            }
        }
        long l3 = l2 = this.r == null ? 30000L : this.r.a().c();
        if (l2 > 0L) {
            this.g.postDelayed(this.j, l2);
            this.l = true;
        }
    }

    private void n() {
        if (!this.l) {
            return;
        }
        this.g.removeCallbacks(this.j);
        this.l = false;
    }

    private void a(List<String> list, Map<String, String> map) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (String string : list) {
            new z(map).execute(new String[]{string});
        }
    }

    private Map<String, String> a(long l2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("delay", String.valueOf(System.currentTimeMillis() - l2));
        return hashMap;
    }

    private Handler o() {
        if (!DisplayAdController.p()) {
            return this.g;
        }
        return h;
    }

    private static synchronized boolean p() {
        return i;
    }

    protected static synchronized void setMainThreadForced(boolean bl) {
        Log.d((String)b, (String)("DisplayAdController changed main thread forced from " + i + " to " + bl));
        i = bl;
    }

    public AdAdapter g() {
        return this.p;
    }

    private class c
    extends BroadcastReceiver {
        private c() {
        }

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if ("android.intent.action.SCREEN_OFF".equals(string)) {
                DisplayAdController.this.n();
            } else if ("android.intent.action.SCREEN_ON".equals(string)) {
                DisplayAdController.this.m();
            }
        }
    }

    private static final class b
    extends an<DisplayAdController> {
        public b(DisplayAdController displayAdController) {
            super(displayAdController);
        }

        @Override
        public void run() {
            DisplayAdController displayAdController = (DisplayAdController)this.a();
            if (displayAdController == null) {
                return;
            }
            displayAdController.m();
        }
    }

    private static final class a
    extends an<DisplayAdController> {
        public a(DisplayAdController displayAdController) {
            super(displayAdController);
        }

        @Override
        public void run() {
            DisplayAdController displayAdController = (DisplayAdController)this.a();
            if (displayAdController == null) {
                return;
            }
            displayAdController.l = false;
            displayAdController.c(null);
        }
    }
}

