/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.facebook.ads.Ad;
import com.facebook.ads.AdChoicesView;
import com.facebook.ads.AdListener;
import com.facebook.ads.ImpressionListener;
import com.facebook.ads.NativeAdView;
import com.facebook.ads.NativeAdViewAttributes;
import com.facebook.ads.internal.DisplayAdController;
import com.facebook.ads.internal.adapters.e;
import com.facebook.ads.internal.adapters.s;
import com.facebook.ads.internal.d.d;
import com.facebook.ads.internal.e;
import com.facebook.ads.internal.extra.AdExtras;
import com.facebook.ads.internal.h;
import com.facebook.ads.internal.h.q;
import com.facebook.ads.internal.h.r;
import com.facebook.ads.internal.server.AdPlacementType;
import com.facebook.ads.internal.util.b;
import com.facebook.ads.internal.util.l;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.json.JSONObject;

public class NativeAd
implements Ad {
    private static final com.facebook.ads.internal.c a = com.facebook.ads.internal.c.a;
    private final long b;
    private static final String c = NativeAd.class.getSimpleName();
    private static WeakHashMap<View, WeakReference<NativeAd>> d = new WeakHashMap();
    private final Context e;
    private final String f;
    private final String g = UUID.randomUUID().toString();
    private final com.facebook.ads.internal.c.b h;
    private AdListener i;
    private ImpressionListener j;
    private DisplayAdController k;
    private volatile boolean l;
    private s m;
    private d n;
    private View o;
    private List<View> p = new ArrayList<View>();
    private View.OnTouchListener q;
    private com.facebook.ads.internal.adapters.e r;
    private com.facebook.ads.internal.adapters.r s;
    private a t;
    private b u;
    private r v;
    private NativeAdView.Type w;
    private boolean x;
    private boolean y;
    private boolean z;
    private long A;
    private String B;
    private boolean C = false;

    public NativeAd(Context context, String string) {
        this.e = context;
        this.f = string;
        this.b = com.facebook.ads.internal.h.b(context);
        this.h = new com.facebook.ads.internal.c.b(context);
    }

    public NativeAd(Context context, s s2, d d2) {
        this(context, null);
        this.n = d2;
        this.l = true;
        this.m = s2;
    }

    NativeAd(NativeAd nativeAd) {
        this(nativeAd.e, null);
        this.n = nativeAd.n;
        this.l = true;
        this.m = nativeAd.m;
    }

    s a() {
        return this.m;
    }

    public static void downloadAndDisplayImage(Image image, ImageView imageView) {
        if (image != null && imageView != null) {
            new l(imageView).a(image.getUrl());
        }
    }

    public void setAdListener(AdListener adListener) {
        this.i = adListener;
    }

    @Deprecated
    public void setImpressionListener(ImpressionListener impressionListener) {
        this.j = impressionListener;
    }

    @Override
    public void loadAd() {
        this.loadAd(EnumSet.of(MediaCacheFlag.NONE));
    }

    public void loadAd(final EnumSet<MediaCacheFlag> enumSet) {
        if (this.l) {
            throw new IllegalStateException("loadAd cannot be called more than once");
        }
        this.A = System.currentTimeMillis();
        this.l = true;
        e e2 = com.facebook.ads.internal.e.j;
        this.k = new DisplayAdController(this.e, this.f, e2, AdPlacementType.NATIVE, null, a, 1, true);
        this.k.a(new com.facebook.ads.internal.a(){

            @Override
            public void a(com.facebook.ads.internal.b b2) {
                if (NativeAd.this.i != null) {
                    NativeAd.this.i.onError(NativeAd.this, b2.b());
                }
            }

            @Override
            public void a() {
                if (NativeAd.this.k != null) {
                    NativeAd.this.k.c();
                }
            }

            @Override
            public void a(final s s2) {
                com.facebook.ads.internal.util.c.a(com.facebook.ads.internal.util.b.a(b.b.a, AdPlacementType.NATIVE, System.currentTimeMillis() - NativeAd.this.A, null));
                if (s2 == null) {
                    return;
                }
                if (enumSet.contains((Object)MediaCacheFlag.ICON) && s2.k() != null) {
                    NativeAd.this.h.a(s2.k().getUrl());
                }
                if (enumSet.contains((Object)MediaCacheFlag.IMAGE)) {
                    if (s2.l() != null) {
                        NativeAd.this.h.a(s2.l().getUrl());
                    }
                    if (s2.B() != null) {
                        for (NativeAd nativeAd : s2.B()) {
                            if (nativeAd.getAdCoverImage() == null) continue;
                            NativeAd.this.h.a(nativeAd.getAdCoverImage().getUrl());
                        }
                    }
                }
                if (enumSet.contains((Object)MediaCacheFlag.VIDEO) && !TextUtils.isEmpty((CharSequence)s2.w()) && com.facebook.ads.internal.h.c(NativeAd.this.e)) {
                    NativeAd.this.h.b(s2.w());
                }
                NativeAd.this.h.a(new com.facebook.ads.internal.c.a(){

                    @Override
                    public void a() {
                        NativeAd.this.m = s2;
                        NativeAd.this.l();
                        NativeAd.this.m();
                        if (NativeAd.this.i != null) {
                            NativeAd.this.i.onAdLoaded(NativeAd.this);
                        }
                    }
                });
                if (NativeAd.this.i != null && s2.B() != null) {
                    for (NativeAd nativeAd : s2.B()) {
                        nativeAd.setAdListener(NativeAd.this.i);
                    }
                }
            }

            @Override
            public void b() {
                if (NativeAd.this.i != null) {
                    NativeAd.this.i.onAdClicked(NativeAd.this);
                }
            }

            @Override
            public void c() {
                throw new IllegalStateException("Native ads manager their own impressions.");
            }
        });
        this.k.b();
    }

    @Override
    public void destroy() {
        if (this.u != null) {
            this.u.b();
            this.u = null;
        }
        if (this.k != null) {
            this.k.d();
            this.k = null;
        }
    }

    @Override
    public String getPlacementId() {
        return this.f;
    }

    public boolean isAdLoaded() {
        return this.m != null && this.m.b();
    }

    public boolean isNativeConfigEnabled() {
        return this.isAdLoaded() && this.m.f();
    }

    public Image getAdIcon() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.k();
    }

    public Image getAdCoverImage() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.l();
    }

    public NativeAdViewAttributes getAdViewAttributes() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.m();
    }

    public String getAdTitle() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.n();
    }

    public String getAdSubtitle() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.o();
    }

    public String getAdBody() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.p();
    }

    public String getAdCallToAction() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.q();
    }

    public String getAdSocialContext() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.r();
    }

    @Deprecated
    public Rating getAdStarRating() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.s();
    }

    public String getId() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.g;
    }

    public Image getAdChoicesIcon() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.t();
    }

    public String getAdChoicesLinkUrl() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.u();
    }

    String b() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.v();
    }

    public AdExtras getAdExtras() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.A();
    }

    String c() {
        if (!this.isAdLoaded()) {
            return null;
        }
        if (com.facebook.ads.internal.h.c(this.e) && !TextUtils.isEmpty((CharSequence)this.m.w())) {
            return this.h.c(this.m.w());
        }
        return this.m.w();
    }

    int d() {
        return this.m.x();
    }

    String e() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.y();
    }

    String f() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.z();
    }

    List<NativeAd> g() {
        if (!this.isAdLoaded()) {
            return null;
        }
        return this.m.B();
    }

    public void registerViewForInteraction(View view) {
        ArrayList<View> arrayList = new ArrayList<View>();
        this.a(arrayList, view);
        this.registerViewForInteraction(view, arrayList);
    }

    private void a(List<View> list, View view) {
        if (view instanceof com.facebook.ads.internal.h.d || view instanceof AdChoicesView || view instanceof com.facebook.ads.internal.h.b.c) {
            return;
        }
        list.add(view);
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i2 = 0; i2 < viewGroup.getChildCount(); ++i2) {
                this.a(list, viewGroup.getChildAt(i2));
            }
        }
    }

    public void registerViewForInteraction(View view, List<View> list) {
        if (view == null) {
            throw new IllegalArgumentException("Must provide a View");
        }
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("Invalid set of clickable views");
        }
        if (!this.isAdLoaded()) {
            Log.e((String)c, (String)"Ad not loaded");
            return;
        }
        if (this.o != null) {
            Log.w((String)c, (String)"Native Ad was already registered with a View. Auto unregistering and proceeding.");
            this.unregisterView();
        }
        if (d.containsKey(view)) {
            Log.w((String)c, (String)"View already registered with a NativeAd. Auto unregistering and proceeding.");
            ((NativeAd)d.get(view).get()).unregisterView();
        }
        this.t = new a();
        this.o = view;
        if (view instanceof ViewGroup) {
            this.v = new r(view.getContext(), new q(){

                @Override
                public void a(int n2) {
                    if (NativeAd.this.m != null) {
                        NativeAd.this.m.a(n2);
                    }
                }
            });
            ((ViewGroup)view).addView((View)this.v);
        }
        for (View view2 : list) {
            this.a(view2);
        }
        this.m.a(view, list);
        this.s = new com.facebook.ads.internal.adapters.r(this.e, new c(), this.m);
        this.s.a(list);
        int n2 = this.getMinViewabilityPercentage();
        this.r = new com.facebook.ads.internal.adapters.e(this.e, this.o, n2, new e.a(){

            @Override
            public void a() {
                if (NativeAd.this.s == null) {
                    if (NativeAd.this.r != null) {
                        NativeAd.this.r.b();
                        NativeAd.this.r = null;
                    }
                    return;
                }
                NativeAd.this.s.a(NativeAd.this.o);
                NativeAd.this.s.a(NativeAd.this.w);
                NativeAd.this.s.a(NativeAd.this.x);
                NativeAd.this.s.b(NativeAd.this.y);
                NativeAd.this.s.c(NativeAd.this.z);
                NativeAd.this.s.a();
                NativeAd.this.t.a();
            }
        });
        this.r.a(this.i());
        this.r.b(this.j());
        this.r.a();
        d.put(view, new WeakReference<NativeAd>(this));
    }

    private int getMinViewabilityPercentage() {
        int n2 = 1;
        if (this.n != null) {
            n2 = this.n.e();
        } else if (this.k != null && this.k.a() != null) {
            n2 = this.k.a().e();
        }
        return n2;
    }

    private int i() {
        if (this.n != null) {
            return this.n.e();
        }
        if (this.m != null) {
            return this.m.i();
        }
        if (this.k != null && this.k.a() != null) {
            return this.k.a().f();
        }
        return 0;
    }

    private int j() {
        if (this.n != null) {
            return this.n.g();
        }
        if (this.m != null) {
            return this.m.j();
        }
        if (this.k != null && this.k.a() != null) {
            return this.k.a().g();
        }
        return 1000;
    }

    void a(NativeAdView.Type type) {
        this.w = type;
    }

    void a(boolean bl) {
        this.x = bl;
    }

    void b(boolean bl) {
        this.y = bl;
    }

    public void setMediaViewAutoplay(boolean bl) {
        this.z = bl;
    }

    private void a(View view) {
        this.p.add(view);
        view.setOnClickListener((View.OnClickListener)this.t);
        view.setOnTouchListener((View.OnTouchListener)this.t);
    }

    public void unregisterView() {
        if (this.o == null) {
            return;
        }
        if (!d.containsKey(this.o) || d.get(this.o).get() != this) {
            throw new IllegalStateException("View not registered with this NativeAd");
        }
        if (this.o instanceof ViewGroup && this.v != null) {
            ((ViewGroup)this.o).removeView((View)this.v);
            this.v = null;
        }
        if (this.m != null) {
            this.m.a();
        }
        d.remove(this.o);
        this.k();
        this.o = null;
        if (this.r != null) {
            this.r.b();
            this.r = null;
        }
        this.s = null;
    }

    private void k() {
        for (View view : this.p) {
            view.setOnClickListener(null);
            view.setOnTouchListener(null);
        }
        this.p.clear();
    }

    private void l() {
        if (this.m != null && this.m.c()) {
            this.u = new b();
            this.u.a();
            this.s = new com.facebook.ads.internal.adapters.r(this.e, new com.facebook.ads.internal.adapters.b(){

                @Override
                public boolean a() {
                    return true;
                }
            }, this.m);
        }
    }

    private void registerExternalLogReceiver(String string) {
        this.C = true;
        this.B = string;
    }

    private void m() {
        if (this.C) {
            this.s = new com.facebook.ads.internal.adapters.r(this.e, new c(){

                @Override
                public boolean b() {
                    return true;
                }

                @Override
                public String c() {
                    return NativeAd.this.B;
                }
            }, this.m);
        }
    }

    private void logExternalImpression() {
        this.s.a();
    }

    private void logExternalClick(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("eil", true);
        hashMap.put("eil_source", string);
        this.m.b(hashMap);
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.q = onTouchListener;
    }

    private class b
    extends BroadcastReceiver {
        private boolean b;

        private b() {
        }

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            String[] stringArray = string.split(":");
            String string2 = stringArray[0];
            if ("com.facebook.ads.native.impression".equals(string2)) {
                NativeAd.this.s.a();
            } else if ("com.facebook.ads.native.click".equals(string2)) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("mil", true);
                NativeAd.this.m.b(hashMap);
            }
        }

        public void a() {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("com.facebook.ads.native.impression:" + NativeAd.this.g);
            intentFilter.addAction("com.facebook.ads.native.click:" + NativeAd.this.g);
            LocalBroadcastManager.getInstance((Context)NativeAd.this.e).registerReceiver((BroadcastReceiver)this, intentFilter);
            this.b = true;
        }

        public void b() {
            if (!this.b) {
                return;
            }
            try {
                LocalBroadcastManager.getInstance((Context)NativeAd.this.e).unregisterReceiver((BroadcastReceiver)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class a
    implements View.OnClickListener,
    View.OnTouchListener {
        private int b;
        private int c;
        private int d;
        private int e;
        private float f;
        private float g;
        private int h;
        private int i;
        private boolean j;
        private boolean k = false;
        private long l = System.currentTimeMillis();

        private a() {
        }

        public void onClick(View view) {
            if (System.currentTimeMillis() - this.l < NativeAd.this.b) {
                Log.v((String)c, (String)("Premature click event (threshold=" + NativeAd.this.b + ")."));
                return;
            }
            if (!this.j) {
                Log.e((String)"FBAudienceNetworkLog", (String)"No touch data recorded, please ensure touch events reach the ad View by returning false if you intercept the event.");
            }
            Map<String, Object> map = this.b();
            if (NativeAd.this.w != null) {
                map.put("nti", String.valueOf(NativeAd.this.w.getValue()));
            }
            if (NativeAd.this.x) {
                map.put("nhs", String.valueOf(NativeAd.this.x));
            }
            NativeAd.this.m.b(map);
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (motionEvent.getAction() == 0 && NativeAd.this.o != null) {
                this.d = NativeAd.this.o.getWidth();
                this.e = NativeAd.this.o.getHeight();
                int[] nArray = new int[2];
                NativeAd.this.o.getLocationInWindow(nArray);
                this.f = nArray[0];
                this.g = nArray[1];
                Rect rect = new Rect();
                NativeAd.this.o.getGlobalVisibleRect(rect);
                this.i = rect.width();
                this.h = rect.height();
                int[] nArray2 = new int[2];
                view.getLocationInWindow(nArray2);
                this.b = (int)motionEvent.getX() + nArray2[0] - nArray[0];
                this.c = (int)motionEvent.getY() + nArray2[1] - nArray[1];
                this.j = true;
            }
            return NativeAd.this.q != null && NativeAd.this.q.onTouch(view, motionEvent);
        }

        public void a() {
            if (!this.k) {
                this.l = System.currentTimeMillis();
                this.k = true;
            }
        }

        public Map<String, Object> b() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("clickX", this.b);
            hashMap.put("clickY", this.c);
            hashMap.put("width", this.d);
            hashMap.put("height", this.e);
            hashMap.put("adPositionX", Float.valueOf(this.f));
            hashMap.put("adPositionY", Float.valueOf(this.g));
            hashMap.put("visibleWidth", this.i);
            hashMap.put("visibleHeight", this.h);
            return hashMap;
        }
    }

    private class c
    extends com.facebook.ads.internal.adapters.b {
        private c() {
        }

        @Override
        public void d() {
            if (NativeAd.this.j != null) {
                NativeAd.this.j.onLoggingImpression(NativeAd.this);
            }
            if (NativeAd.this.i instanceof ImpressionListener && NativeAd.this.i != NativeAd.this.j) {
                ((ImpressionListener)((Object)NativeAd.this.i)).onLoggingImpression(NativeAd.this);
            }
        }

        @Override
        public void e() {
        }

        @Override
        public boolean a() {
            return false;
        }
    }

    public static enum MediaCacheFlag {
        NONE(0L),
        ICON(1L),
        IMAGE(2L),
        VIDEO(3L);

        public static final EnumSet<MediaCacheFlag> ALL;
        private final long a;

        private MediaCacheFlag(long l2) {
            this.a = l2;
        }

        public long getCacheFlagValue() {
            return this.a;
        }

        static {
            ALL = EnumSet.allOf(MediaCacheFlag.class);
        }
    }

    public static class Rating {
        private final double a;
        private final double b;

        public Rating(double d2, double d3) {
            this.a = d2;
            this.b = d3;
        }

        public double getValue() {
            return this.a;
        }

        public double getScale() {
            return this.b;
        }

        public static Rating fromJSONObject(JSONObject jSONObject) {
            if (jSONObject == null) {
                return null;
            }
            double d2 = jSONObject.optDouble("value", 0.0);
            double d3 = jSONObject.optDouble("scale", 0.0);
            if (d2 == 0.0 || d3 == 0.0) {
                return null;
            }
            return new Rating(d2, d3);
        }
    }

    public static class Image {
        private final String a;
        private final int b;
        private final int c;

        public Image(String string, int n2, int n3) {
            this.a = string;
            this.b = n2;
            this.c = n3;
        }

        public String getUrl() {
            return this.a;
        }

        public int getWidth() {
            return this.b;
        }

        public int getHeight() {
            return this.c;
        }

        public static Image fromJSONObject(JSONObject jSONObject) {
            if (jSONObject == null) {
                return null;
            }
            String string = jSONObject.optString("url");
            if (string == null) {
                return null;
            }
            int n2 = jSONObject.optInt("width", 0);
            int n3 = jSONObject.optInt("height", 0);
            return new Image(string, n2, n3);
        }
    }
}

