/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatButton;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import com.facebook.accountkit.R;
import com.facebook.accountkit.ui.CenteredImageSpan;

public class WhatsAppButton
extends AppCompatButton {
    private final int ICON_SIZE_DP = 20;

    public WhatsAppButton(Context context) {
        super(context);
        this.init();
    }

    public WhatsAppButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public WhatsAppButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.imageSpanColorReset();
    }

    public void imageSpanColorReset() {
        CharSequence buttonText = this.getText();
        if (buttonText instanceof SpannedString) {
            ImageSpan[] imageSpans;
            SpannedString buttonSpannable = (SpannedString)buttonText;
            for (ImageSpan imageSpan : imageSpans = (ImageSpan[])buttonSpannable.getSpans(0, buttonSpannable.length(), ImageSpan.class)) {
                if (imageSpan.getDrawable() == null) continue;
                DrawableCompat.setTint((Drawable)imageSpan.getDrawable(), (int)this.getCurrentTextColor());
            }
        }
    }

    private void init() {
        int imageStartIndex = this.getText().toString().indexOf(9711);
        if (imageStartIndex != -1) {
            SpannableString span = new SpannableString(this.getText());
            Drawable whatsAppLogo = DrawableCompat.wrap((Drawable)ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_button_icon_whatsapp));
            int[] iconSizes = this.getIconBoundary();
            whatsAppLogo.setBounds(0, 0, iconSizes[0], iconSizes[1]);
            CenteredImageSpan imageSpan = new CenteredImageSpan(whatsAppLogo);
            span.setSpan((Object)imageSpan, imageStartIndex, imageStartIndex + 1, 17);
            this.setText((CharSequence)span);
            this.imageSpanColorReset();
        }
    }

    private int[] getIconBoundary() {
        int height = (int)(20.0f * this.getResources().getDisplayMetrics().density);
        return new int[]{4 * height, height};
    }
}

