/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.View;
import com.facebook.accountkit.R;
import com.facebook.accountkit.UpdateFlowBroadcastReceiver;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.ConfirmationCodeContentController;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.PrivacyPolicyFragment;
import com.facebook.accountkit.ui.TitleFragmentFactory;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.ViewStateFragment;
import com.facebook.accountkit.ui.ViewUtility;
import java.io.Serializable;

final class UpdateConfirmationCodeContentController
extends ConfirmationCodeContentController {
    private OnCompleteListener onCompleteListener;

    UpdateConfirmationCodeContentController(AccountKitConfiguration configuration) {
        super(configuration);
    }

    @Override
    public TitleFragmentFactory.TitleFragment getHeaderFragment() {
        if (this.headerFragment == null) {
            this.setHeaderFragment(TitleFragment.create(this.configuration.getUIManager(), R.string.com_accountkit_confirmation_code_title, new String[0]));
        }
        return this.headerFragment;
    }

    @Override
    public void setHeaderFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        if (!(fragment instanceof TitleFragment)) {
            return;
        }
        this.headerFragment = (TitleFragment)fragment;
        this.headerFragment.setOnCompleteListener(this.getOnCompleteListener());
    }

    @Override
    public void setTopFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof ConfirmationCodeContentController.TopFragment)) {
            return;
        }
        this.topFragment = (ConfirmationCodeContentController.TopFragment)fragment;
        this.topFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)this.configuration.getUIManager());
        ConfirmationCodeContentController.TopFragment.OnConfirmationCodeChangedListener onConfirmationCodeChangedListener = new ConfirmationCodeContentController.TopFragment.OnConfirmationCodeChangedListener(){

            @Override
            public void onConfirmationCodeChanged() {
                UpdateConfirmationCodeContentController.this.updateNextButton();
            }
        };
        this.topFragment.setOnConfirmationCodeChangedListener(onConfirmationCodeChangedListener);
        this.topFragment.setOnCompleteListener(this.getOnCompleteListener());
    }

    @Override
    public void setBottomFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof PrivacyPolicyFragment)) {
            return;
        }
        this.bottomFragment = (PrivacyPolicyFragment)fragment;
        this.bottomFragment.setOnCompleteListener(this.getOnCompleteListener());
        this.bottomFragment.setRetryVisible(false);
        this.updateNextButton();
    }

    private OnCompleteListener getOnCompleteListener() {
        if (this.onCompleteListener == null) {
            this.onCompleteListener = new OnCompleteListener();
        }
        return this.onCompleteListener;
    }

    private class OnCompleteListener
    implements PrivacyPolicyFragment.OnCompleteListener,
    ConfirmationCodeContentController.TitleFragment.OnCompleteListener {
        private OnCompleteListener() {
        }

        @Override
        public void onNext(Context context, String buttonName) {
            if (UpdateConfirmationCodeContentController.this.topFragment == null || UpdateConfirmationCodeContentController.this.bottomFragment == null) {
                return;
            }
            String confirmationCode = UpdateConfirmationCodeContentController.this.topFragment.getConfirmationCode();
            Intent intent = new Intent(UpdateFlowBroadcastReceiver.ACTION_UPDATE).putExtra(UpdateFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)UpdateFlowBroadcastReceiver.Event.CONFIRMATION_CODE_COMPLETE)).putExtra(UpdateFlowBroadcastReceiver.EXTRA_CONFIRMATION_CODE, confirmationCode);
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
        }

        @Override
        public void onRetry(Context context) {
        }

        @Override
        public void onEdit(Context context) {
            Intent intent = new Intent(UpdateFlowBroadcastReceiver.ACTION_UPDATE).putExtra(UpdateFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)UpdateFlowBroadcastReceiver.Event.ERROR_UPDATE));
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
        }
    }

    public static final class TitleFragment
    extends ConfirmationCodeContentController.TitleFragment {
        public static TitleFragment create(UIManager uiManager, int titleResourceId, String ... args) {
            TitleFragment titleFragment = new TitleFragment();
            titleFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)uiManager);
            titleFragment.setTitleResourceId(titleResourceId, args);
            return titleFragment;
        }

        @Override
        void setPhoneNumberView() {
            if (!this.isAdded()) {
                return;
            }
            if (this.phoneNumber != null) {
                SpannableString span = new SpannableString((CharSequence)this.getString(R.string.com_accountkit_enter_code_sent_to, new Object[]{this.phoneNumber.toString()}));
                ClickableSpan clickSpan = new ClickableSpan(){

                    public void onClick(View widget) {
                        if (TitleFragment.this.onCompleteListener != null) {
                            TitleFragment.this.onCompleteListener.onEdit(widget.getContext());
                        }
                    }

                    public void updateDrawState(TextPaint ds) {
                        super.updateDrawState(ds);
                        ds.setColor(ViewUtility.getButtonColor((Context)TitleFragment.this.getActivity(), TitleFragment.this.getUIManager()));
                        ds.setUnderlineText(false);
                    }
                };
                int start = span.toString().indexOf(this.phoneNumber.toString());
                int end = start + this.phoneNumber.toString().length();
                span.setSpan((Object)clickSpan, start, end, 33);
                this.titleView.setText((CharSequence)span);
                this.titleView.setMovementMethod(LinkMovementMethod.getInstance());
            }
        }
    }
}

