/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.ui.LoginFragment;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.ViewStateFragment;

final class TitleFragmentFactory {
    TitleFragmentFactory() {
    }

    public static TitleFragment create(@NonNull UIManager uiManager) {
        TitleFragment titleFragment = new TitleFragment();
        titleFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)uiManager);
        return titleFragment;
    }

    public static TitleFragment create(@NonNull UIManager uiManager, int titleResourceId, String ... args) {
        TitleFragment titleFragment = TitleFragmentFactory.create(uiManager);
        titleFragment.setTitleResourceId(titleResourceId, args);
        return titleFragment;
    }

    public static class TitleFragment
    extends LoginFragment {
        private static final String TITLE_KEY = "title";
        private static final String TITLE_RESOURCE_ARGS_KEY = "titleResourceArgs";
        private static final String TITLE_RESOURCE_ID_KEY = "titleResourceId";
        protected TextView titleView;

        private String getTitle() {
            return this.getViewState().getString(TITLE_KEY);
        }

        public void setTitle(@Nullable String title) {
            this.getViewState().putString(TITLE_KEY, title);
            this.updateTitleView();
        }

        @Nullable
        private String[] getTitleResourceArgs() {
            return this.getViewState().getStringArray(TITLE_RESOURCE_ARGS_KEY);
        }

        private int getTitleResourceId() {
            return this.getViewState().getInt(TITLE_RESOURCE_ID_KEY);
        }

        public void setTitleResourceId(int titleResourceId, String ... args) {
            Bundle viewState = this.getViewState();
            viewState.putInt(TITLE_RESOURCE_ID_KEY, titleResourceId);
            viewState.putStringArray(TITLE_RESOURCE_ARGS_KEY, args);
            this.updateTitleView();
        }

        @Override
        protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            return inflater.inflate(R.layout.com_accountkit_fragment_title, container, false);
        }

        @Override
        protected void onViewReadyWithState(View view, Bundle viewState) {
            super.onViewReadyWithState(view, viewState);
            this.titleView = (TextView)view.findViewById(R.id.com_accountkit_title);
            this.updateTitleView();
        }

        private void updateTitleView() {
            if (this.titleView == null) {
                return;
            }
            String title = this.getTitle();
            int titleResourceId = 0;
            if (Utility.isNullOrEmpty(title)) {
                titleResourceId = this.getTitleResourceId();
                String[] titleResourceArgs = this.getTitleResourceArgs();
                if (titleResourceId > 0 && titleResourceArgs != null && titleResourceArgs.length != 0 && this.getActivity() != null) {
                    title = this.getString(titleResourceId, titleResourceArgs);
                    titleResourceId = 0;
                }
            }
            if (!Utility.isNullOrEmpty(title)) {
                this.titleView.setText((CharSequence)title);
                this.titleView.setVisibility(0);
            } else if (titleResourceId > 0) {
                this.titleView.setText(titleResourceId);
                this.titleView.setVisibility(0);
            } else {
                this.titleView.setVisibility(8);
            }
        }
    }
}

