/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.os.Bundle;
import android.text.Spanned;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.facebook.accountkit.R;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.CustomLinkMovement;

abstract class TextContentFragment
extends ContentFragment {
    private static final String CONTENT_PADDING_BOTTOM_KEY = "contentPaddingBottom";
    private static final String CONTENT_PADDING_TOP_KEY = "contentPaddingTop";
    private NextButtonTextProvider nextButtonTextProvider;
    private TextView textView;

    TextContentFragment() {
    }

    protected abstract Spanned getText(String var1);

    public int getContentPaddingBottom() {
        return this.getViewState().getInt(CONTENT_PADDING_BOTTOM_KEY, 0);
    }

    public void setContentPaddingBottom(int contentPaddingBottom) {
        this.getViewState().putInt(CONTENT_PADDING_BOTTOM_KEY, contentPaddingBottom);
        this.updateContentPadding();
    }

    public int getContentPaddingTop() {
        return this.getViewState().getInt(CONTENT_PADDING_TOP_KEY, 0);
    }

    public void setContentPaddingTop(int contentPaddingTop) {
        this.getViewState().putInt(CONTENT_PADDING_TOP_KEY, contentPaddingTop);
        this.updateContentPadding();
    }

    @Override
    protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.com_accountkit_fragment_phone_login_text, container, false);
    }

    public void setNextButtonTextProvider(NextButtonTextProvider nextButtonTextProvider) {
        this.nextButtonTextProvider = nextButtonTextProvider;
    }

    @Override
    protected void onViewReadyWithState(View view, Bundle viewState) {
        super.onViewReadyWithState(view, viewState);
        this.textView = (TextView)view.findViewById(R.id.com_accountkit_text);
        if (this.textView != null) {
            this.textView.setMovementMethod((MovementMethod)new CustomLinkMovement(new CustomLinkMovement.OnURLClickedListener(){

                @Override
                public void onURLClicked(String url) {
                }
            }));
        }
        this.updateContentPadding();
        this.updateText();
    }

    public void onStart() {
        super.onStart();
        this.updateText();
    }

    private void updateContentPadding() {
        if (this.textView == null) {
            return;
        }
        int contentPaddingTop = this.getContentPaddingTop();
        int contentPaddingBottom = this.getContentPaddingBottom();
        this.textView.setPadding(this.textView.getPaddingLeft(), contentPaddingTop, this.textView.getPaddingRight(), contentPaddingBottom);
    }

    void updateText() {
        if (this.textView == null || this.nextButtonTextProvider == null) {
            return;
        }
        if (this.getActivity() == null) {
            return;
        }
        this.textView.setText((CharSequence)this.getText(this.nextButtonTextProvider.getNextButtonText()));
    }

    public static interface NextButtonTextProvider {
        public String getNextButtonText();
    }
}

