/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.Context;
import android.graphics.drawable.Animatable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.facebook.accountkit.R;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.ViewStateFragment;
import com.facebook.accountkit.ui.ViewUtility;

final class StaticContentFragmentFactory {
    private static final String LAYOUT_RESOURCE_ID_KEY = "layoutResourceId";
    private static final String LOGIN_FLOW_STATE_KEY = "loginFlowState";

    StaticContentFragmentFactory() {
    }

    static StaticContentFragment create(@NonNull UIManager uiManager, LoginFlowState loginFlowState, int layoutResourceId) {
        StaticContentFragment fragment = StaticContentFragmentFactory.create(uiManager, loginFlowState);
        fragment.getViewState().putInt(LAYOUT_RESOURCE_ID_KEY, layoutResourceId);
        return fragment;
    }

    static StaticContentFragment create(@NonNull UIManager uiManager, LoginFlowState loginFlowState) {
        StaticContentFragment fragment = new StaticContentFragment();
        Bundle viewState = fragment.getViewState();
        viewState.putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)uiManager);
        viewState.putString(LOGIN_FLOW_STATE_KEY, loginFlowState.name());
        return fragment;
    }

    public static final class StaticContentFragment
    extends ContentFragment {
        @Override
        protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            return inflater.inflate(this.getViewState().getInt(StaticContentFragmentFactory.LAYOUT_RESOURCE_ID_KEY, R.layout.com_accountkit_fragment_static_content), container, false);
        }

        @Override
        LoginFlowState getLoginFlowState() {
            return LoginFlowState.valueOf(this.getViewState().getString(StaticContentFragmentFactory.LOGIN_FLOW_STATE_KEY, LoginFlowState.NONE.name()));
        }

        @Override
        boolean isKeyboardFragment() {
            return false;
        }

        @Override
        protected void onViewReadyWithState(View view, Bundle viewState) {
            super.onViewReadyWithState(view, viewState);
            View iconView = view.findViewById(R.id.com_accountkit_icon_view);
            if (iconView != null) {
                int color2;
                int n = color2 = ViewUtility.useLegacy(this.getUIManager()) ? ViewUtility.getColor((Context)this.getActivity(), R.attr.com_accountkit_icon_color, -1) : ViewUtility.getPrimaryColor((Context)this.getActivity(), this.getUIManager());
                if (iconView instanceof ImageView) {
                    ImageView iconImgView = (ImageView)iconView;
                    ViewUtility.applyThemeColor((Context)this.getActivity(), iconImgView, color2);
                    String loginState = viewState.getString(StaticContentFragmentFactory.LOGIN_FLOW_STATE_KEY);
                    if (iconImgView.getDrawable() instanceof Animatable) {
                        ((Animatable)iconImgView.getDrawable()).start();
                    }
                } else {
                    ViewUtility.applyThemeColor((Context)this.getActivity(), iconView.getBackground(), color2);
                }
            }
        }
    }
}

