/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.support.annotation.Nullable;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.R;
import com.facebook.accountkit.ui.AccountKitActivity;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.AccountVerifiedContentController;
import com.facebook.accountkit.ui.AdvancedUIManager;
import com.facebook.accountkit.ui.AdvancedUIManagerWrapper;
import com.facebook.accountkit.ui.BaseUIManager;
import com.facebook.accountkit.ui.ButtonContentController;
import com.facebook.accountkit.ui.ButtonType;
import com.facebook.accountkit.ui.ConfirmAccountVerifiedContentController;
import com.facebook.accountkit.ui.ContentController;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.EmailLoginContentController;
import com.facebook.accountkit.ui.EmailSentCodeContentController;
import com.facebook.accountkit.ui.EmailVerifyContentController;
import com.facebook.accountkit.ui.LoginConfirmationCodeContentController;
import com.facebook.accountkit.ui.LoginErrorContentController;
import com.facebook.accountkit.ui.LoginFlowManager;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.NotificationChannel;
import com.facebook.accountkit.ui.PhoneLoginContentController;
import com.facebook.accountkit.ui.PhoneLoginFlowManager;
import com.facebook.accountkit.ui.PhoneSentCodeContentController;
import com.facebook.accountkit.ui.ResendContentController;
import com.facebook.accountkit.ui.SendingCodeContentController;
import com.facebook.accountkit.ui.SkinManager;
import com.facebook.accountkit.ui.TextContentFragment;
import com.facebook.accountkit.ui.TextPosition;
import com.facebook.accountkit.ui.TitleFragmentFactory;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.VerifiedCodeContentController;
import com.facebook.accountkit.ui.VerifyingCodeContentController;
import com.facebook.accountkit.ui.ViewUtility;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class StateStackManager
implements UIManager.UIManagerListener,
AdvancedUIManager.AdvancedUIManagerListener,
FragmentManager.OnBackStackChangedListener {
    private final WeakReference<AccountKitActivity> activityRef;
    private final UIManager uiManager;
    private final AccountKitConfiguration configuration;
    private ContentController contentController;
    private final Map<LoginFlowState, ContentController> contentControllerMap = new HashMap<LoginFlowState, ContentController>();
    private final List<OnPopListener> onPopListeners = new ArrayList<OnPopListener>();
    private final List<OnPushListener> onPushListeners = new ArrayList<OnPushListener>();

    StateStackManager(AccountKitActivity activity, AccountKitConfiguration configuration) {
        this.activityRef = new WeakReference<AccountKitActivity>(activity);
        activity.getFragmentManager().addOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)this);
        this.configuration = configuration;
        UIManager uIManager = this.uiManager = configuration == null ? null : configuration.getUIManager();
        if (this.uiManager instanceof AdvancedUIManagerWrapper) {
            ((AdvancedUIManagerWrapper)this.uiManager).getAdvancedUIManager().setAdvancedUIManagerListener(this);
        } else if (this.uiManager != null) {
            this.uiManager.setUIManagerListener(this);
        }
    }

    @Override
    public void onBack() {
        AccountKitActivity activity = (AccountKitActivity)((Object)this.activityRef.get());
        if (activity == null) {
            return;
        }
        activity.onBackPressed();
    }

    public void onBackStackChanged() {
        AccountKitActivity activity = (AccountKitActivity)((Object)this.activityRef.get());
        if (activity == null) {
            return;
        }
        this.updateContentController(activity);
    }

    @Override
    public void onCancel() {
        AccountKitActivity activity = (AccountKitActivity)((Object)this.activityRef.get());
        if (activity == null) {
            return;
        }
        activity.sendCancelResult();
    }

    @Nullable
    ContentController getContentController() {
        return this.contentController;
    }

    void popBackStack(LoginFlowState toState, @Nullable OnPopListener onPopListener) {
        AccountKitActivity activity = (AccountKitActivity)((Object)this.activityRef.get());
        if (activity == null) {
            return;
        }
        if (onPopListener != null) {
            this.onPopListeners.add(onPopListener);
        }
        ContentController toContentController = this.ensureContentController(activity, toState, LoginFlowState.NONE, false);
        if (toState == LoginFlowState.PHONE_NUMBER_INPUT || toState == LoginFlowState.EMAIL_INPUT) {
            activity.getFragmentManager().popBackStack(0, 0);
        } else {
            activity.getFragmentManager().popBackStack();
        }
        activity.ensureNextButton(toContentController);
    }

    void multiPopBackStack(OnPopListener onPopListener) {
        AccountKitActivity activity = (AccountKitActivity)((Object)this.activityRef.get());
        if (activity == null) {
            return;
        }
        if (onPopListener != null) {
            this.onPopListeners.add(onPopListener);
        }
        activity.getFragmentManager().popBackStack();
        activity.ensureNextButton(null);
    }

    void pushError(AccountKitActivity activity, LoginFlowManager loginFlowManager, LoginFlowState returnState, AccountKitError error, @Nullable OnPushListener onPushListener) {
        this.uiManager.onError(error);
        this.pushState(activity, loginFlowManager, returnState, onPushListener);
    }

    OnPushListener getErrorOnPushListener(final @Nullable String errorMessage) {
        return new OnPushListener(){

            @Override
            public void onContentControllerReady(ContentController contentController) {
                if (contentController instanceof LoginErrorContentController) {
                    LoginErrorContentController loginErrorContentController = (LoginErrorContentController)contentController;
                    loginErrorContentController.setErrorMessage(errorMessage);
                }
            }

            @Override
            public void onContentPushed() {
            }
        };
    }

    void pushState(AccountKitActivity activity, LoginFlowManager loginFlowManager, @Nullable OnPushListener onPushListener) {
        this.pushState(activity, loginFlowManager, LoginFlowState.NONE, onPushListener);
    }

    private void pushState(AccountKitActivity activity, LoginFlowManager loginFlowManager, LoginFlowState returnState, @Nullable OnPushListener onPushListener) {
        ButtonType buttonType;
        LoginFlowState loginFlowState = loginFlowManager.getFlowState();
        ContentController fromContentController = this.getContentController();
        ContentController toContentController = this.ensureContentController(activity, loginFlowState, returnState, false);
        if (toContentController == null || fromContentController == toContentController) {
            return;
        }
        NotificationChannel notificationChannel = null;
        if (loginFlowManager instanceof PhoneLoginFlowManager) {
            notificationChannel = ((PhoneLoginFlowManager)loginFlowManager).getNotificationChannel();
        }
        TitleFragmentFactory.TitleFragment headerFragment = loginFlowState == LoginFlowState.RESEND && toContentController instanceof ResendContentController || loginFlowState == LoginFlowState.CODE_INPUT && toContentController instanceof LoginConfirmationCodeContentController || toContentController instanceof LoginErrorContentController ? toContentController.getHeaderFragment() : this.uiManager.getHeaderFragment(loginFlowState);
        Fragment contentCenterFragment = this.uiManager.getBodyFragment(loginFlowState);
        Fragment footerFragment = this.uiManager.getFooterFragment(loginFlowState);
        if (headerFragment == null) {
            headerFragment = BaseUIManager.getDefaultHeaderFragment(this.uiManager, loginFlowState, loginFlowManager.getLoginType(), notificationChannel);
        }
        if (contentCenterFragment == null) {
            contentCenterFragment = BaseUIManager.getDefaultBodyFragment(this.uiManager, loginFlowState);
        }
        if (footerFragment == null) {
            footerFragment = BaseUIManager.getDefaultFooterFragment(this.uiManager);
        }
        TextPosition textPosition = this.uiManager.getTextPosition(loginFlowState);
        if (toContentController instanceof ButtonContentController && (buttonType = this.uiManager.getButtonType(loginFlowState)) != null) {
            ((ButtonContentController)((Object)toContentController)).setButtonType(buttonType);
        }
        ContentFragment contentTopFragment = toContentController.getTopFragment();
        ContentFragment contentTextFragment = toContentController.getTextFragment();
        ContentFragment contentBottomFragment = toContentController.getBottomFragment();
        if (onPushListener != null) {
            this.onPushListeners.add(onPushListener);
            onPushListener.onContentControllerReady(toContentController);
        }
        if (textPosition == null) {
            textPosition = TextPosition.BELOW_BODY;
        }
        if (contentTextFragment != null) {
            int contentPaddingBottom;
            int contentPaddingTopResourceId;
            int contentPaddingBottomResourceId;
            switch (textPosition) {
                case ABOVE_BODY: {
                    contentPaddingBottomResourceId = 0;
                    contentPaddingTopResourceId = R.dimen.com_accountkit_vertical_spacer_small_height;
                    break;
                }
                case BELOW_BODY: {
                    contentPaddingBottomResourceId = R.dimen.com_accountkit_vertical_spacer_small_height;
                    contentPaddingTopResourceId = 0;
                    break;
                }
                default: {
                    contentPaddingBottomResourceId = 0;
                    contentPaddingTopResourceId = 0;
                }
            }
            int contentPaddingTop = contentPaddingTopResourceId == 0 ? 0 : activity.getResources().getDimensionPixelSize(contentPaddingTopResourceId);
            int n = contentPaddingBottom = contentPaddingBottomResourceId == 0 ? 0 : activity.getResources().getDimensionPixelSize(contentPaddingBottomResourceId);
            if (contentTextFragment instanceof TextContentFragment) {
                TextContentFragment textContentFragment = (TextContentFragment)contentTextFragment;
                textContentFragment.setContentPaddingTop(contentPaddingTop);
                textContentFragment.setContentPaddingBottom(contentPaddingBottom);
            }
        }
        FragmentManager fm = activity.getFragmentManager();
        if (fromContentController != null) {
            activity.onContentControllerDismissed(fromContentController);
            if (fromContentController.isTransient()) {
                fm.popBackStack();
            }
        }
        if (ViewUtility.isSkin(this.uiManager, SkinManager.Skin.CONTEMPORARY)) {
            activity.ensureNextButton(toContentController);
        }
        FragmentTransaction transaction = fm.beginTransaction();
        activity.replace(transaction, R.id.com_accountkit_header_fragment, headerFragment);
        activity.replace(transaction, R.id.com_accountkit_content_top_fragment, contentTopFragment);
        activity.replace(transaction, R.id.com_accountkit_content_top_text_fragment, textPosition == TextPosition.ABOVE_BODY ? contentTextFragment : null);
        activity.replace(transaction, R.id.com_accountkit_content_center_fragment, contentCenterFragment);
        activity.replace(transaction, R.id.com_accountkit_content_bottom_text_fragment, textPosition == TextPosition.BELOW_BODY ? contentTextFragment : null);
        if (!ViewUtility.isSkin(this.uiManager, SkinManager.Skin.CONTEMPORARY)) {
            activity.replace(transaction, R.id.com_accountkit_content_bottom_fragment, contentBottomFragment);
            activity.replace(transaction, R.id.com_accountkit_footer_fragment, footerFragment);
        }
        transaction.addToBackStack(null);
        ViewUtility.hideKeyboard((Activity)activity);
        transaction.commit();
        toContentController.onResume((Activity)activity);
    }

    void updateContentController(AccountKitActivity activity) {
        ContentFragment topFragment = this.getContentFragment(activity, R.id.com_accountkit_content_top_fragment);
        if (topFragment == null) {
            return;
        }
        LoginFlowState loginFlowState = topFragment.getLoginFlowState();
        ContentController contentController = this.ensureContentController(activity, loginFlowState, LoginFlowState.NONE, true);
        if (contentController == null) {
            return;
        }
        this.contentController = contentController;
        ArrayList<OnPopListener> onPopListeners = new ArrayList<OnPopListener>(this.onPopListeners);
        this.onPopListeners.clear();
        for (OnPopListener onPopListener : onPopListeners) {
            onPopListener.onContentPopped();
        }
        ArrayList<OnPushListener> onPushListeners = new ArrayList<OnPushListener>(this.onPushListeners);
        this.onPushListeners.clear();
        for (OnPushListener onPushListener : onPushListeners) {
            onPushListener.onContentPushed();
        }
    }

    @Nullable
    private ContentFragment getContentFragment(AccountKitActivity activity, int id2) {
        Fragment fragment = activity.getFragmentManager().findFragmentById(id2);
        if (!(fragment instanceof ContentFragment)) {
            return null;
        }
        return (ContentFragment)fragment;
    }

    @Nullable
    private ContentController ensureContentController(AccountKitActivity activity, LoginFlowState loginFlowState, LoginFlowState returnState, boolean updateFragments) {
        ContentController contentController = this.contentControllerMap.get((Object)loginFlowState);
        if (contentController != null) {
            return contentController;
        }
        block0 : switch (loginFlowState) {
            case NONE: {
                return null;
            }
            case PHONE_NUMBER_INPUT: {
                contentController = new PhoneLoginContentController(this.configuration);
                break;
            }
            case SENDING_CODE: {
                contentController = new SendingCodeContentController(this.configuration);
                break;
            }
            case SENT_CODE: {
                switch (this.configuration.getLoginType()) {
                    case PHONE: {
                        contentController = new PhoneSentCodeContentController(this.configuration);
                        break block0;
                    }
                    case EMAIL: {
                        contentController = new EmailSentCodeContentController(this.configuration);
                        break block0;
                    }
                }
                throw new RuntimeException("Unexpected login type: " + this.configuration.getLoginType().toString());
            }
            case ACCOUNT_VERIFIED: {
                contentController = new AccountVerifiedContentController(this.configuration);
                break;
            }
            case CONFIRM_ACCOUNT_VERIFIED: {
                contentController = new ConfirmAccountVerifiedContentController(this.configuration);
                break;
            }
            case CONFIRM_INSTANT_VERIFICATION_LOGIN: {
                contentController = new VerifyingCodeContentController(this.configuration);
                break;
            }
            case CODE_INPUT: {
                contentController = new LoginConfirmationCodeContentController(this.configuration);
                break;
            }
            case VERIFYING_CODE: {
                contentController = new VerifyingCodeContentController(this.configuration);
                break;
            }
            case VERIFIED: {
                contentController = new VerifiedCodeContentController(this.configuration);
                break;
            }
            case ERROR: {
                contentController = new LoginErrorContentController(returnState, this.configuration);
                break;
            }
            case EMAIL_INPUT: {
                contentController = new EmailLoginContentController(this.configuration);
                break;
            }
            case EMAIL_VERIFY: {
                contentController = new EmailVerifyContentController(this.configuration);
                break;
            }
            case RESEND: {
                contentController = new ResendContentController(this.configuration);
                break;
            }
            default: {
                return null;
            }
        }
        if (updateFragments) {
            Fragment headerFragment = activity.getFragmentManager().findFragmentById(R.id.com_accountkit_header_fragment);
            if (headerFragment instanceof TitleFragmentFactory.TitleFragment) {
                contentController.setHeaderFragment((TitleFragmentFactory.TitleFragment)headerFragment);
            }
            contentController.setTopFragment(this.getContentFragment(activity, R.id.com_accountkit_content_top_fragment));
            contentController.setCenterFragment(this.getContentFragment(activity, R.id.com_accountkit_content_center_fragment));
            contentController.setBottomFragment(this.getContentFragment(activity, R.id.com_accountkit_content_bottom_fragment));
            Fragment footerFragment = activity.getFragmentManager().findFragmentById(R.id.com_accountkit_footer_fragment);
            if (footerFragment instanceof TitleFragmentFactory.TitleFragment) {
                contentController.setFooterFragment((TitleFragmentFactory.TitleFragment)footerFragment);
            }
            contentController.onResume((Activity)activity);
        }
        this.contentControllerMap.put(loginFlowState, contentController);
        return contentController;
    }

    static interface OnPushListener {
        public void onContentControllerReady(ContentController var1);

        public void onContentPushed();
    }

    static interface OnPopListener {
        public void onContentPopped();
    }

    private static enum FragmentType {
        BODY,
        FOOTER,
        HEADER;

    }
}

