/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.app.Fragment;
import android.graphics.Color;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import com.facebook.accountkit.ui.BaseUIManager;
import com.facebook.accountkit.ui.ButtonType;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.TextPosition;

public final class SkinManager
extends BaseUIManager {
    private static final double MAXIMUM_TINT_INTENSITY = 0.85;
    private static final double MINIMUM_TINT_INTENSITY = 0.55;
    private static final double DISABLED_COLOR_ALPHA = 0.25;
    private final Skin skin;
    @ColorInt
    private final int primaryColor;
    @DrawableRes
    private final int backgroundImage;
    private final Tint tint;
    private final double tintIntensity;
    public static final Parcelable.Creator<SkinManager> CREATOR = new Parcelable.Creator<SkinManager>(){

        public SkinManager createFromParcel(Parcel source) {
            return new SkinManager(source);
        }

        public SkinManager[] newArray(int size) {
            return new SkinManager[size];
        }
    };

    public SkinManager(Skin skin, @ColorInt int primaryColor, @DrawableRes int backgroundImage, Tint tint, double tintIntensity) {
        super(-1);
        this.skin = skin;
        this.primaryColor = primaryColor;
        this.backgroundImage = backgroundImage;
        if (this.hasBackgroundImage()) {
            this.tint = tint;
            this.tintIntensity = Math.min(0.85, Math.max(0.55, tintIntensity));
        } else {
            this.tint = Tint.WHITE;
            this.tintIntensity = 0.55;
        }
    }

    public SkinManager(Skin skin, @ColorInt int primaryColor) {
        this(skin, primaryColor, -1, Tint.WHITE, 0.55);
    }

    private SkinManager(Parcel source) {
        super(source);
        this.skin = Skin.values()[source.readInt()];
        this.primaryColor = source.readInt();
        this.backgroundImage = source.readInt();
        this.tint = Tint.values()[source.readInt()];
        this.tintIntensity = source.readDouble();
    }

    public Skin getSkin() {
        return this.skin;
    }

    public boolean hasBackgroundImage() {
        return this.backgroundImage >= 0;
    }

    @DrawableRes
    int getBackgroundImageResId() {
        return this.backgroundImage;
    }

    public Tint getTint() {
        return this.tint;
    }

    public double getTintIntensity() {
        return this.tintIntensity;
    }

    @ColorInt
    int getDisabledColor(@ColorInt int color2) {
        int backgroundColor;
        switch (this.tint) {
            case WHITE: {
                backgroundColor = -1;
                break;
            }
            default: {
                backgroundColor = -16777216;
            }
        }
        double r = 0.25 * (double)Color.red((int)color2) + 0.75 * (double)Color.red((int)backgroundColor);
        double g = 0.25 * (double)Color.green((int)color2) + 0.75 * (double)Color.green((int)backgroundColor);
        double b = 0.25 * (double)Color.blue((int)color2) + 0.75 * (double)Color.blue((int)backgroundColor);
        return Color.rgb((int)((int)r), (int)((int)g), (int)((int)b));
    }

    @ColorInt
    public int getPrimaryColor() {
        return this.primaryColor;
    }

    @ColorInt
    int getTintColor() {
        int tintInt;
        switch (this.tint) {
            case WHITE: {
                tintInt = Color.argb((int)((int)(255.0 * this.tintIntensity)), (int)255, (int)255, (int)255);
                break;
            }
            default: {
                tintInt = Color.argb((int)((int)(255.0 * this.tintIntensity)), (int)0, (int)0, (int)0);
            }
        }
        return tintInt;
    }

    @ColorInt
    int getTextColor() {
        int textColor;
        switch (this.getTint()) {
            case BLACK: {
                textColor = -1;
                break;
            }
            default: {
                textColor = -16777216;
            }
        }
        return textColor;
    }

    @Override
    @Nullable
    public Fragment getBodyFragment(LoginFlowState state) {
        return super.getBodyFragment(state);
    }

    @Override
    @Nullable
    public ButtonType getButtonType(LoginFlowState state) {
        return super.getButtonType(state);
    }

    @Override
    @Nullable
    public Fragment getFooterFragment(LoginFlowState state) {
        return super.getFooterFragment(state);
    }

    @Override
    @Nullable
    public Fragment getHeaderFragment(LoginFlowState state) {
        return super.getHeaderFragment(state);
    }

    @Override
    @Nullable
    public TextPosition getTextPosition(LoginFlowState state) {
        return super.getTextPosition(state);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.skin.ordinal());
        dest.writeInt(this.primaryColor);
        dest.writeInt(this.backgroundImage);
        dest.writeInt(this.tint.ordinal());
        dest.writeDouble(this.tintIntensity);
    }

    public static enum Tint {
        WHITE,
        BLACK;

    }

    public static enum Skin {
        NONE,
        CLASSIC,
        CONTEMPORARY,
        TRANSLUCENT;

    }
}

