/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.support.annotation.Nullable;
import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import com.google.i18n.phonenumbers.AsYouTypeFormatter;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import java.util.Locale;

public class PhoneNumberTextWatcher
implements TextWatcher {
    private boolean mSelfChange = false;
    private AsYouTypeFormatter mFormatter;

    public PhoneNumberTextWatcher() {
        this(Locale.getDefault().getCountry());
    }

    public PhoneNumberTextWatcher(String countryCode) {
        if (countryCode == null) {
            throw new IllegalArgumentException();
        }
        this.mFormatter = PhoneNumberUtil.getInstance().getAsYouTypeFormatter(countryCode);
    }

    public synchronized void beforeTextChanged(CharSequence s, int start, int count, int after) {
        if (this.mSelfChange) {
            return;
        }
    }

    public synchronized void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.mSelfChange) {
            return;
        }
    }

    public synchronized void afterTextChanged(Editable s) {
        if (this.mSelfChange) {
            return;
        }
        String formatted = this.reformat((CharSequence)s, Selection.getSelectionEnd((CharSequence)s));
        if (formatted != null) {
            int rememberedPos = this.mFormatter.getRememberedPosition();
            this.mSelfChange = true;
            s.replace(0, s.length(), (CharSequence)formatted, 0, formatted.length());
            if (formatted.equals(s.toString())) {
                Selection.setSelection((Spannable)s, (int)rememberedPos);
            }
            this.mSelfChange = false;
        }
    }

    @Nullable
    private String reformat(CharSequence s, int cursor) {
        int curIndex = cursor - 1;
        String formatted = null;
        this.mFormatter.clear();
        char lastNonSeparator = '\u0000';
        boolean hasCursor = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (PhoneNumberUtils.isNonSeparator((char)c)) {
                if (lastNonSeparator != '\u0000') {
                    formatted = this.getFormattedNumber(lastNonSeparator, hasCursor);
                    hasCursor = false;
                }
                lastNonSeparator = c;
            }
            if (i != curIndex) continue;
            hasCursor = true;
        }
        if (lastNonSeparator != '\u0000') {
            formatted = this.getFormattedNumber(lastNonSeparator, hasCursor);
        }
        return formatted;
    }

    private String getFormattedNumber(char lastNonSeparator, boolean hasCursor) {
        return hasCursor ? this.mFormatter.inputDigitAndRememberPosition(lastNonSeparator) : this.mFormatter.inputDigit(lastNonSeparator);
    }
}

