/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.ui.AccountKitActivity;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.ActivityHandler;
import com.facebook.accountkit.ui.ActivityPhoneHandler;
import com.facebook.accountkit.ui.LoginFlowManager;
import com.facebook.accountkit.ui.LoginType;
import com.facebook.accountkit.ui.NotificationChannel;

class PhoneLoginFlowManager
extends LoginFlowManager {
    private PhoneNumber lastUsedPhoneNumber;
    private NotificationChannel notificationChannel = NotificationChannel.SMS;
    public static final Parcelable.Creator<PhoneLoginFlowManager> CREATOR = new Parcelable.Creator<PhoneLoginFlowManager>(){

        public PhoneLoginFlowManager createFromParcel(Parcel source) {
            return new PhoneLoginFlowManager(source);
        }

        public PhoneLoginFlowManager[] newArray(int size) {
            return new PhoneLoginFlowManager[size];
        }
    };

    PhoneLoginFlowManager(AccountKitConfiguration configuration) {
        super(LoginType.PHONE);
        this.activityHandler = new ActivityPhoneHandler(configuration);
    }

    private PhoneNumber getLastUsedPhoneNumber() {
        return this.lastUsedPhoneNumber;
    }

    void setLastUsedPhoneNumber(PhoneNumber lastUsedPhoneNumber) {
        this.lastUsedPhoneNumber = lastUsedPhoneNumber;
    }

    public void logInWithPhoneNumber(PhoneNumber phoneNumber, NotificationChannel notificationChannel, AccountKitActivity.ResponseType responseType, @Nullable String initialAuthState, boolean testSmsWithInfobip) {
        if (!this.isValid()) {
            return;
        }
        this.setLastUsedPhoneNumber(phoneNumber);
        AccountKitController.logInWithPhoneNumber(phoneNumber, notificationChannel, responseType.getValue(), initialAuthState, testSmsWithInfobip);
    }

    public void setNotificationChannel(NotificationChannel notificationChannel) {
        this.notificationChannel = notificationChannel;
    }

    public NotificationChannel getNotificationChannel() {
        return this.notificationChannel;
    }

    public void setConfirmationCode(String confirmationCode) {
        if (!this.isValid()) {
            return;
        }
        AccountKitController.continueLoginWithCode(confirmationCode);
    }

    @Override
    void confirmSeamlessLogin() {
        if (!this.isValid()) {
            return;
        }
        AccountKitController.continueSeamlessLogin();
    }

    PhoneLoginFlowManager(Parcel parcel) {
        super(parcel);
        this.activityHandler = (ActivityHandler)parcel.readParcelable(ActivityPhoneHandler.class.getClassLoader());
        this.setLastUsedPhoneNumber((PhoneNumber)parcel.readParcelable(PhoneNumber.class.getClassLoader()));
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.activityHandler, flags);
        dest.writeParcelable((Parcelable)this.getLastUsedPhoneNumber(), flags);
    }
}

