/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.Buttons;
import com.facebook.accountkit.ui.LoginFlowBroadcastReceiver;
import com.facebook.accountkit.ui.NotificationChannel;
import com.facebook.accountkit.ui.PhoneContentController;
import com.facebook.accountkit.ui.TitleFragmentFactory;
import java.io.Serializable;

final class PhoneLoginContentController
extends PhoneContentController {
    PhoneLoginContentController(AccountKitConfiguration configuration) {
        super(configuration);
        AccountKitController.initializeLogin();
    }

    @Override
    public TitleFragmentFactory.TitleFragment getHeaderFragment() {
        if (this.headerFragment == null) {
            this.setHeaderFragment(TitleFragmentFactory.create(this.configuration.getUIManager(), R.string.com_accountkit_phone_login_title, new String[0]));
        }
        return this.headerFragment;
    }

    void setRetry() {
        if (this.headerFragment != null) {
            this.headerFragment.setTitleResourceId(R.string.com_accountkit_phone_login_retry_title, new String[0]);
        }
        if (this.bottomFragment != null) {
            this.bottomFragment.setRetry(true);
        }
        if (this.textFragment != null) {
            this.textFragment.updateText();
        }
    }

    @Override
    PhoneContentController.OnCompleteListener getOnCompleteListener() {
        if (this.onCompleteListener == null) {
            this.onCompleteListener = new PhoneContentController.OnCompleteListener(){

                @Override
                public void onNext(Context context, Buttons button) {
                    if (PhoneLoginContentController.this.topFragment == null || PhoneLoginContentController.this.bottomFragment == null) {
                        return;
                    }
                    PhoneNumber phoneNumber = PhoneLoginContentController.this.topFragment.getPhoneNumber();
                    if (phoneNumber == null) {
                        return;
                    }
                    NotificationChannel notificationChannel = Buttons.PHONE_LOGIN_USE_WHATSAPP.equals((Object)button) ? NotificationChannel.WHATSAPP : NotificationChannel.SMS;
                    Intent intent = new Intent(LoginFlowBroadcastReceiver.ACTION_UPDATE).putExtra(LoginFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)LoginFlowBroadcastReceiver.Event.PHONE_LOGIN_COMPLETE)).putExtra(LoginFlowBroadcastReceiver.EXTRA_PHONE_NUMBER, (Parcelable)phoneNumber).putExtra(LoginFlowBroadcastReceiver.EXTRA_NOTIFICATION_CHANNEL, (Serializable)((Object)notificationChannel));
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                }
            };
        }
        return this.onCompleteListener;
    }
}

