/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.accountkit.R;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.ErrorContentController;
import com.facebook.accountkit.ui.LoginFlowBroadcastReceiver;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.ViewStateFragment;
import java.io.Serializable;

final class LoginErrorContentController
extends ErrorContentController {
    private static final LoginFlowState LOGIN_FLOW_STATE = LoginFlowState.ERROR;
    private final LoginFlowState returnState;
    private BottomFragment bottomFragment;

    LoginErrorContentController(LoginFlowState returnState, AccountKitConfiguration configuration) {
        super(configuration);
        this.returnState = returnState;
    }

    LoginFlowState getReturnState() {
        return this.returnState;
    }

    @Override
    public ContentFragment getBottomFragment() {
        if (this.bottomFragment == null) {
            this.setBottomFragment(new BottomFragment());
        }
        return this.bottomFragment;
    }

    @Override
    public void setBottomFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof BottomFragment)) {
            return;
        }
        this.bottomFragment = (BottomFragment)fragment;
        this.bottomFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)this.configuration.getUIManager());
        this.bottomFragment.getViewState().putInt(BottomFragment.RETURN_LOGIN_FLOW_STATE, this.returnState.ordinal());
    }

    public static final class BottomFragment
    extends ContentFragment {
        private static final String RETURN_LOGIN_FLOW_STATE = TAG + ".RETURN_LOGIN_FLOW_STATE";

        @Override
        protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            return inflater.inflate(R.layout.com_accountkit_fragment_error_bottom, container, false);
        }

        @Override
        LoginFlowState getLoginFlowState() {
            return LOGIN_FLOW_STATE;
        }

        @Override
        boolean isKeyboardFragment() {
            return false;
        }

        @Override
        protected void onViewReadyWithState(View view, final Bundle viewState) {
            super.onViewReadyWithState(view, viewState);
            View startOverButton = view.findViewById(R.id.com_accountkit_start_over_button);
            if (startOverButton != null) {
                startOverButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Intent intent = new Intent(LoginFlowBroadcastReceiver.ACTION_UPDATE);
                        intent.putExtra(LoginFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)LoginFlowBroadcastReceiver.Event.ERROR_RESTART));
                        intent.putExtra(LoginFlowBroadcastReceiver.EXTRA_RETURN_LOGIN_FLOW_STATE, (Serializable)((Integer)viewState.get(RETURN_LOGIN_FLOW_STATE)));
                        LocalBroadcastManager.getInstance((Context)v.getContext()).sendBroadcast(intent);
                    }
                });
            }
        }
    }
}

