/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewTreeObserver;
import com.facebook.accountkit.ui.ViewUtility;

final class KeyboardObserver {
    private static final int MINIMUM_KEYBOARD_HEIGHT_DP = 100 + (Build.VERSION.SDK_INT >= 21 ? 48 : 0);
    private boolean didCalculateVisibleFrame = false;
    private final Rect lastViewVisibleFrame = new Rect();
    private final Rect lastRootViewVisibleFrame = new Rect();
    private OnVisibleFrameChangedListener onVisibleFrameChangedListener;
    private final Rect rootViewVisibleFrame = new Rect();

    public KeyboardObserver(View view) {
        this.configureGlobalObserver(view);
    }

    public void setOnVisibleFrameChangedListener(@Nullable OnVisibleFrameChangedListener onVisibleFrameChangedListener) {
        this.onVisibleFrameChangedListener = onVisibleFrameChangedListener;
        if (this.didCalculateVisibleFrame && onVisibleFrameChangedListener != null) {
            onVisibleFrameChangedListener.onVisibleFrameChanged(this.lastViewVisibleFrame);
        }
    }

    private void configureGlobalObserver(final View view) {
        if (view == null) {
            return;
        }
        final View rootView = view.getRootView();
        if (rootView == null) {
            return;
        }
        ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                KeyboardObserver.this.checkVisibleFrame(view, rootView);
            }
        };
        rootView.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
        this.checkVisibleFrame(view, rootView);
    }

    private void checkVisibleFrame(View view, View rootView) {
        boolean keyboardIsVisible;
        int minimumKeyboardHeight = ViewUtility.getDimensionPixelSize(rootView.getContext(), MINIMUM_KEYBOARD_HEIGHT_DP);
        rootView.getWindowVisibleDisplayFrame(this.rootViewVisibleFrame);
        int viewHeight = rootView.getHeight();
        int visibleHeight = this.rootViewVisibleFrame.bottom - this.rootViewVisibleFrame.top;
        boolean bl = keyboardIsVisible = viewHeight - visibleHeight >= minimumKeyboardHeight;
        if (keyboardIsVisible && !this.rootViewVisibleFrame.equals((Object)this.lastRootViewVisibleFrame)) {
            this.lastRootViewVisibleFrame.set(this.rootViewVisibleFrame);
            view.getGlobalVisibleRect(this.lastViewVisibleFrame);
            this.didCalculateVisibleFrame = true;
            if (this.onVisibleFrameChangedListener != null) {
                this.onVisibleFrameChangedListener.onVisibleFrameChanged(this.lastViewVisibleFrame);
            }
        }
    }

    public static interface OnVisibleFrameChangedListener {
        public void onVisibleFrameChanged(Rect var1);
    }
}

