/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.PhoneLoginModel;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.facebook.accountkit.internal.LoginStatus;
import com.facebook.accountkit.ui.AccountKitActivity;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.ActivityPhoneHandler;
import com.facebook.accountkit.ui.NotificationChannel;
import com.facebook.accountkit.ui.PhoneLoginFlowManager;
import java.io.Serializable;
import java.util.Date;

final class DemoPhoneLoginFlowManager
extends PhoneLoginFlowManager {
    private static final String MOCK_CONFIRMATION_CODE = "123456";
    private static final int MOCK_NETWORK_DELAY_MS = 2000;
    private boolean isValid = true;
    private DemoPhoneLoginModel loginModel;
    private ActivityPhoneHandler phoneListeners;
    private AccountKitActivity activity;
    public static final Parcelable.Creator<DemoPhoneLoginFlowManager> CREATOR = new Parcelable.Creator<DemoPhoneLoginFlowManager>(){

        public DemoPhoneLoginFlowManager createFromParcel(Parcel source) {
            return new DemoPhoneLoginFlowManager(source);
        }

        public DemoPhoneLoginFlowManager[] newArray(int size) {
            return new DemoPhoneLoginFlowManager[size];
        }
    };

    public DemoPhoneLoginFlowManager(AccountKitConfiguration configuration, AccountKitActivity activity, ActivityPhoneHandler phoneListeners) {
        super(configuration);
        this.activity = activity;
        this.phoneListeners = phoneListeners;
    }

    @Override
    public void cancel() {
        this.isValid = false;
        this.broadcastLoginState(LoginStatus.CANCELLED, null);
    }

    @Override
    public AccessToken getAccessToken() {
        if (!this.isValid) {
            return null;
        }
        return new AccessToken("TEST_ACCESS_TOKEN", "TEST_ACCOUNT_ID", AccountKit.getApplicationId(), 300000L, new Date());
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void logInWithPhoneNumber(final PhoneNumber phoneNumber, NotificationChannel notificationChannel, AccountKitActivity.ResponseType responseType, String initialAuthState, boolean testSmsWithInfobip) {
        if (!this.isValid) {
            return;
        }
        String confirmationCode = responseType == AccountKitActivity.ResponseType.CODE ? "DEMOCODE" : null;
        AccessToken accessToken = responseType == AccountKitActivity.ResponseType.TOKEN ? this.getAccessToken() : null;
        this.loginModel = new DemoPhoneLoginModel(phoneNumber, initialAuthState, confirmationCode, accessToken);
        this.setLastUsedPhoneNumber(phoneNumber);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (phoneNumber.getPhoneNumber().length() == 10) {
                    DemoPhoneLoginFlowManager.this.broadcastLoginState(LoginStatus.PENDING, null);
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            DemoPhoneLoginFlowManager.this.phoneListeners.startSmsTrackerIfPossible(DemoPhoneLoginFlowManager.this.activity);
                            DemoPhoneLoginFlowManager.this.phoneListeners.getSmsTracker().confirmationCodeReceived(DemoPhoneLoginFlowManager.MOCK_CONFIRMATION_CODE);
                        }
                    }, 2000L);
                } else {
                    InternalAccountKitError internalError = new InternalAccountKitError(1948002, null, "[Demo] use a 10 digit number");
                    AccountKitError error = new AccountKitError(AccountKitError.Type.ARGUMENT_ERROR, internalError);
                    DemoPhoneLoginFlowManager.this.broadcastLoginState(LoginStatus.ERROR, error);
                }
            }
        }, 2000L);
    }

    @Override
    public void setConfirmationCode(final String confirmationCode) {
        if (!this.isValid) {
            return;
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (confirmationCode.equals(DemoPhoneLoginFlowManager.MOCK_CONFIRMATION_CODE)) {
                    DemoPhoneLoginFlowManager.this.broadcastLoginState(LoginStatus.SUCCESS, null);
                } else {
                    InternalAccountKitError internalError = new InternalAccountKitError(1948002, null, "[Demo] use confirmation code 123456");
                    AccountKitError error = new AccountKitError(AccountKitError.Type.ARGUMENT_ERROR, internalError);
                    DemoPhoneLoginFlowManager.this.broadcastLoginState(LoginStatus.ERROR, error);
                }
            }
        }, 2000L);
    }

    private void broadcastLoginState(LoginStatus status, AccountKitError error) {
        LocalBroadcastManager.getInstance((Context)AccountKitController.getApplicationContext()).sendBroadcast(new Intent("com.facebook.accountkit.sdk.ACTION_PHONE_LOGIN_STATE_CHANGED").putExtra("com.facebook.accountkit.sdk.EXTRA_LOGIN_MODEL", (Parcelable)this.loginModel).putExtra("com.facebook.accountkit.sdk.EXTRA_LOGIN_STATUS", (Serializable)((Object)status)).putExtra("com.facebook.accountkit.sdk.EXTRA_LOGIN_ERROR", (Parcelable)error));
    }

    private DemoPhoneLoginFlowManager(Parcel parcel) {
        super(parcel);
    }

    private static class DemoPhoneLoginModel
    implements PhoneLoginModel {
        private final AccessToken accessToken;
        private final String authState;
        private final String confirmationCode;
        private final PhoneNumber phoneNumber;
        public static final Parcelable.Creator<DemoPhoneLoginModel> CREATOR = new Parcelable.Creator<DemoPhoneLoginModel>(){

            public DemoPhoneLoginModel createFromParcel(Parcel source) {
                return new DemoPhoneLoginModel(source);
            }

            public DemoPhoneLoginModel[] newArray(int size) {
                return new DemoPhoneLoginModel[size];
            }
        };

        DemoPhoneLoginModel(PhoneNumber phoneNumber, String authState, String confirmationCode, AccessToken accessToken) {
            this.phoneNumber = phoneNumber;
            this.authState = authState;
            this.confirmationCode = confirmationCode;
            this.accessToken = accessToken;
        }

        @Override
        public String getConfirmationCode() {
            return this.confirmationCode;
        }

        @Override
        public PhoneNumber getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public String getPrivacyPolicy() {
            return null;
        }

        @Override
        public String getTermsOfService() {
            return null;
        }

        @Override
        public String getFinalAuthState() {
            return this.authState;
        }

        @Override
        public String getCode() {
            return this.confirmationCode;
        }

        @Override
        public AccessToken getAccessToken() {
            return this.accessToken;
        }

        @Override
        public NotificationChannel getNotificationChannel() {
            return NotificationChannel.SMS;
        }

        @Override
        public long getResendTime() {
            return System.currentTimeMillis();
        }

        DemoPhoneLoginModel(Parcel parcel) {
            this.accessToken = (AccessToken)parcel.readParcelable(AccessToken.class.getClassLoader());
            this.authState = parcel.readString();
            this.confirmationCode = parcel.readString();
            this.phoneNumber = (PhoneNumber)parcel.readParcelable(PhoneNumber.class.getClassLoader());
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.accessToken, flags);
            dest.writeString(this.authState);
            dest.writeString(this.confirmationCode);
            dest.writeParcelable((Parcelable)this.phoneNumber, flags);
        }
    }
}

