/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.text.Layout;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.view.MotionEvent;
import android.widget.TextView;

final class CustomLinkMovement
extends LinkMovementMethod {
    private final OnURLClickedListener listener;

    public CustomLinkMovement(OnURLClickedListener listener) {
        this.listener = listener;
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        if (event.getAction() == 1) {
            int line;
            int x = (int)event.getX() - widget.getTotalPaddingLeft() + widget.getScrollX();
            int y = (int)event.getY() - widget.getTotalPaddingTop() + widget.getScrollY();
            Layout layout2 = widget.getLayout();
            int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y), (float)x);
            URLSpan[] link = (URLSpan[])buffer.getSpans(off, off, URLSpan.class);
            if (link.length != 0) {
                String url = link[0].getURL();
                this.listener.onURLClicked(url);
            }
        }
        return super.onTouchEvent(widget, buffer, event);
    }

    static interface OnURLClickedListener {
        public void onURLClicked(String var1);
    }
}

