/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.facebook.accountkit.R;

public final class AspectFrameLayout
extends FrameLayout {
    private int aspectHeight;
    private int aspectWidth;
    private Point displaySize;

    public AspectFrameLayout(Context context) {
        super(context);
    }

    public AspectFrameLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AspectFrameLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public AspectFrameLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AspectFrameLayout);
        try {
            this.aspectWidth = a.getDimensionPixelSize(R.styleable.AspectFrameLayout_com_accountkit_aspect_width, 0);
            this.aspectHeight = a.getDimensionPixelSize(R.styleable.AspectFrameLayout_com_accountkit_aspect_height, 0);
        }
        finally {
            a.recycle();
        }
    }

    public float getAspectHeight() {
        return this.aspectHeight;
    }

    public void setAspectHeight(int aspectHeight) {
        if (this.aspectHeight == aspectHeight) {
            return;
        }
        this.aspectHeight = aspectHeight;
        this.requestLayout();
    }

    public float getAspectWidth() {
        return this.aspectWidth;
    }

    public void setAspectWidth(int aspectWidth) {
        if (this.aspectWidth == aspectWidth) {
            return;
        }
        this.aspectWidth = aspectWidth;
        this.requestLayout();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Point displaySize = new Point();
        ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getSize(displaySize);
        this.displaySize = displaySize;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        if (this.aspectWidth == 0 || this.aspectHeight == 0 || this.displaySize == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int scaledHeight = this.displaySize.x * this.aspectHeight / this.aspectWidth;
        if (scaledHeight > this.displaySize.y) {
            width = this.displaySize.x;
            height = scaledHeight;
        } else {
            width = this.displaySize.y * this.aspectWidth / this.aspectHeight;
            height = this.displaySize.y;
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }
}

