/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.app.Activity;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitException;
import com.facebook.accountkit.LoginResult;
import com.facebook.accountkit.PhoneLoginModel;
import com.facebook.accountkit.PhoneLoginTracker;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.ui.AccountKitActivity;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.ActivityHandler;
import com.facebook.accountkit.ui.ContentController;
import com.facebook.accountkit.ui.LoginConfirmationCodeContentController;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.NotificationChannel;
import com.facebook.accountkit.ui.PhoneLoginContentController;
import com.facebook.accountkit.ui.PhoneLoginFlowManager;
import com.facebook.accountkit.ui.ResendContentController;
import com.facebook.accountkit.ui.SendingCodeContentController;
import com.facebook.accountkit.ui.SentCodeContentController;
import com.facebook.accountkit.ui.SmsTracker;
import com.facebook.accountkit.ui.StateStackManager;
import com.facebook.accountkit.ui.VerifyingCodeContentController;

final class ActivityPhoneHandler
extends ActivityHandler {
    private SmsTracker smsTracker;
    public static final Parcelable.Creator<ActivityPhoneHandler> CREATOR = new Parcelable.Creator<ActivityPhoneHandler>(){

        public ActivityPhoneHandler createFromParcel(Parcel source) {
            return new ActivityPhoneHandler(source);
        }

        public ActivityPhoneHandler[] newArray(int size) {
            return new ActivityPhoneHandler[size];
        }
    };

    ActivityPhoneHandler(@NonNull AccountKitConfiguration configuration) {
        super(configuration);
    }

    @Override
    public PhoneLoginTracker getLoginTracker(final AccountKitActivity activity) {
        if (this.getPhoneTracker() == null) {
            this.tracker = new PhoneLoginTracker(){

                @Override
                protected void onStarted(PhoneLoginModel loginModel) {
                    ContentController contentController = activity.getContentController();
                    if (!(contentController instanceof SendingCodeContentController) && !(contentController instanceof VerifyingCodeContentController)) {
                        return;
                    }
                    if (loginModel.getNotificationChannel() == NotificationChannel.SMS || loginModel.getNotificationChannel() == NotificationChannel.WHATSAPP) {
                        ActivityPhoneHandler.this.startSmsTrackerIfPossible(activity);
                    }
                    if (contentController instanceof SendingCodeContentController) {
                        activity.pushState(LoginFlowState.SENT_CODE, null);
                    } else {
                        activity.popBackStack(LoginFlowState.CODE_INPUT, new StateStackManager.OnPopListener(){

                            @Override
                            public void onContentPopped() {
                                ContentController contentController = activity.getContentController();
                                if (!(contentController instanceof LoginConfirmationCodeContentController)) {
                                    return;
                                }
                                ((LoginConfirmationCodeContentController)contentController).setRetry(true);
                            }
                        });
                    }
                }

                @Override
                protected void onAccountVerified(PhoneLoginModel loginModel) {
                    ContentController contentController = activity.getContentController();
                    if (!(contentController instanceof SendingCodeContentController)) {
                        return;
                    }
                    activity.pushState(LoginFlowState.ACCOUNT_VERIFIED, null);
                }

                @Override
                protected void onSuccess(PhoneLoginModel loginModel) {
                    ContentController contentController = activity.getContentController();
                    if (!(contentController instanceof LoginConfirmationCodeContentController) && !(contentController instanceof VerifyingCodeContentController)) {
                        return;
                    }
                    activity.pushState(LoginFlowState.VERIFIED, null);
                    activity.setAuthorizationCode(loginModel.getCode());
                    activity.setAccessToken(loginModel.getAccessToken());
                    activity.setLoginResult(LoginResult.SUCCESS);
                    activity.setFinalAuthState(loginModel.getFinalAuthState());
                    AccessToken accessToken = loginModel.getAccessToken();
                    if (accessToken != null) {
                        activity.setTokenRefreshIntervalInSeconds(accessToken.getTokenRefreshIntervalSeconds());
                    }
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            this.finishActivity();
                        }
                    }, 2000L);
                }

                @Override
                protected void onError(AccountKitException exception) {
                    activity.pushError(exception.getError());
                }

                @Override
                protected void onCancel(PhoneLoginModel loginModel) {
                    activity.setNewLoginFlowManagerAndHandler(null);
                }

                private void finishActivity() {
                    activity.sendResult();
                }
            };
        }
        return this.getPhoneTracker();
    }

    void onConfirmationCodeComplete(AccountKitActivity activity, PhoneLoginFlowManager loginFlowManager, String confirmationCode) {
        activity.pushState(LoginFlowState.VERIFYING_CODE, null);
        loginFlowManager.setConfirmationCode(confirmationCode);
    }

    void onConfirmationCodeRetry(AccountKitActivity activity) {
        activity.pushState(LoginFlowState.RESEND, this.getResendOnPushListener());
    }

    private StateStackManager.OnPushListener getResendOnPushListener() {
        final PhoneLoginModel phoneLoginModel = AccountKit.getCurrentPhoneNumberLogInModel();
        final PhoneNumber phoneNumber = phoneLoginModel != null ? phoneLoginModel.getPhoneNumber() : null;
        final NotificationChannel loginType = phoneLoginModel != null ? phoneLoginModel.getNotificationChannel() : null;
        return phoneNumber == null ? null : new StateStackManager.OnPushListener(){

            @Override
            public void onContentControllerReady(ContentController contentController) {
                if (contentController instanceof ResendContentController) {
                    ResendContentController resendContentController = (ResendContentController)contentController;
                    resendContentController.setPhoneNumber(phoneNumber);
                    resendContentController.setNotificationChannels(ActivityPhoneHandler.this.configuration.getNotificationChannels());
                    resendContentController.setResendTime(phoneLoginModel.getResendTime());
                    resendContentController.setPhoneLoginType(loginType);
                }
            }

            @Override
            public void onContentPushed() {
            }
        };
    }

    void onPhoneLoginComplete(AccountKitActivity activity, PhoneLoginFlowManager phoneManager, PhoneNumber phoneNumber, NotificationChannel notificationChannel) {
        phoneManager.setNotificationChannel(notificationChannel);
        activity.pushState(LoginFlowState.SENDING_CODE, null);
        phoneManager.logInWithPhoneNumber(phoneNumber, notificationChannel, this.configuration.getResponseType(), this.configuration.getInitialAuthState(), this.configuration.getTestSmsWithInfobip());
    }

    void onResendSwitchLoginMethod(final AccountKitActivity activity, final @Nullable PhoneLoginFlowManager phoneManager, final PhoneNumber phoneNumber, final NotificationChannel notificationChannel) {
        if (phoneManager == null) {
            return;
        }
        activity.multiPopBackStack(new StateStackManager.OnPopListener(){

            @Override
            public void onContentPopped() {
                activity.popBackStack(LoginFlowState.SENT_CODE, new StateStackManager.OnPopListener(){

                    @Override
                    public void onContentPopped() {
                        activity.pushState(LoginFlowState.SENDING_CODE, null);
                        phoneManager.logInWithPhoneNumber(phoneNumber, notificationChannel, ActivityPhoneHandler.this.configuration.getResponseType(), ActivityPhoneHandler.this.configuration.getInitialAuthState(), ActivityPhoneHandler.this.configuration.getTestSmsWithInfobip());
                    }
                });
            }
        });
    }

    void onResend(AccountKitActivity activity) {
        AccountKit.cancelLogin();
        this.popToPhoneNumberInput(activity);
    }

    private void popToPhoneNumberInput(final AccountKitActivity activity) {
        ContentController contentController = activity.getContentController();
        if (contentController instanceof ResendContentController) {
            activity.multiPopBackStack(new StateStackManager.OnPopListener(){

                @Override
                public void onContentPopped() {
                    ActivityPhoneHandler.this.popToPhoneNumberInput(activity);
                }
            });
        } else if (contentController instanceof LoginConfirmationCodeContentController) {
            activity.popBackStack(LoginFlowState.PHONE_NUMBER_INPUT, new StateStackManager.OnPopListener(){

                @Override
                public void onContentPopped() {
                    ActivityPhoneHandler.this.resendSetRetry(activity);
                }
            });
        }
    }

    private void resendSetRetry(AccountKitActivity activity) {
        ContentController contentController = activity.getContentController();
        if (!(contentController instanceof PhoneLoginContentController)) {
            return;
        }
        ((PhoneLoginContentController)contentController).setRetry();
        contentController.onResume((Activity)activity);
    }

    void onResendFacebookNotification(final AccountKitActivity activity, final PhoneLoginFlowManager phoneManager) {
        PhoneLoginModel phoneLoginModel = AccountKit.getCurrentPhoneNumberLogInModel();
        if (phoneLoginModel == null) {
            return;
        }
        phoneManager.setNotificationChannel(NotificationChannel.FACEBOOK);
        final PhoneNumber phoneNumber = phoneLoginModel.getPhoneNumber();
        activity.multiPopBackStack(new StateStackManager.OnPopListener(){

            @Override
            public void onContentPopped() {
                activity.popBackStack(LoginFlowState.SENT_CODE, new StateStackManager.OnPopListener(){

                    @Override
                    public void onContentPopped() {
                        activity.pushState(LoginFlowState.SENDING_CODE, null);
                        phoneManager.logInWithPhoneNumber(phoneNumber, NotificationChannel.FACEBOOK, ActivityPhoneHandler.this.configuration.getResponseType(), ActivityPhoneHandler.this.configuration.getInitialAuthState(), ActivityPhoneHandler.this.configuration.getTestSmsWithInfobip());
                    }
                });
            }
        });
    }

    StateStackManager.OnPushListener getConfirmationCodePushListener(final AccountKitActivity activity) {
        return new StateStackManager.OnPushListener(){

            @Override
            public void onContentControllerReady(ContentController contentController) {
                if (!(contentController instanceof LoginConfirmationCodeContentController)) {
                    return;
                }
                PhoneLoginModel phoneLoginModel = AccountKit.getCurrentPhoneNumberLogInModel();
                if (phoneLoginModel == null) {
                    return;
                }
                LoginConfirmationCodeContentController confirmationCodeContentController = (LoginConfirmationCodeContentController)contentController;
                confirmationCodeContentController.setPhoneNumber(phoneLoginModel.getPhoneNumber());
                confirmationCodeContentController.setNotificationChannel(phoneLoginModel.getNotificationChannel());
                confirmationCodeContentController.setDetectedConfirmationCode(ActivityPhoneHandler.this.getLoginTracker(activity).getCode());
            }

            @Override
            public void onContentPushed() {
            }
        };
    }

    @Override
    public void onSentCodeComplete(AccountKitActivity activity) {
        activity.pushState(LoginFlowState.CODE_INPUT, null);
    }

    @Override
    public void onAccountVerifiedComplete(AccountKitActivity activity) {
        activity.pushState(LoginFlowState.CONFIRM_ACCOUNT_VERIFIED, null);
    }

    SmsTracker getSmsTracker() {
        return this.smsTracker;
    }

    void startSmsTrackerIfPossible(final AccountKitActivity activity) {
        if (!SmsTracker.canTrackSms(AccountKitController.getApplicationContext())) {
            return;
        }
        if (this.smsTracker == null) {
            this.smsTracker = new SmsTracker(){

                @Override
                protected void confirmationCodeReceived(String code) {
                    ContentController contentController = activity.getContentController();
                    if (contentController instanceof SendingCodeContentController || contentController instanceof SentCodeContentController) {
                        ActivityPhoneHandler.this.getPhoneTracker().setCode(code);
                    } else if (contentController instanceof LoginConfirmationCodeContentController) {
                        ((LoginConfirmationCodeContentController)contentController).setDetectedConfirmationCode(code);
                    }
                    ActivityPhoneHandler.this.smsTracker.stopTracking();
                }
            };
        }
        this.smsTracker.startTracking();
    }

    void pauseSmsTracker() {
        if (this.smsTracker != null) {
            this.smsTracker.pauseTracking();
        }
    }

    void stopSmsTracker() {
        if (this.smsTracker != null) {
            this.smsTracker.stopTracking();
        }
    }

    boolean isSmsTracking() {
        return this.smsTracker != null && this.smsTracker.isTracking();
    }

    private ActivityPhoneHandler(Parcel parcel) {
        super(parcel);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
    }

    private PhoneLoginTracker getPhoneTracker() {
        return (PhoneLoginTracker)this.tracker;
    }
}

