/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.view.View;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.ContentControllerBase;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.LoginFlowBroadcastReceiver;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.StaticContentFragmentFactory;
import com.facebook.accountkit.ui.TitleFragmentFactory;
import java.io.Serializable;

public class AccountVerifiedContentController
extends ContentControllerBase {
    private static final int COMPLETION_UI_DURATION_MS = 2000;
    private StaticContentFragmentFactory.StaticContentFragment bottomFragment;
    private StaticContentFragmentFactory.StaticContentFragment centerFragment;
    private TitleFragmentFactory.TitleFragment footerFragment;
    private TitleFragmentFactory.TitleFragment headerFragment;
    private StaticContentFragmentFactory.StaticContentFragment textFragment;
    private StaticContentFragmentFactory.StaticContentFragment topFragment;
    private Handler delayedTransitionHandler;
    private Runnable delayedTransitionRunnable;

    AccountVerifiedContentController(AccountKitConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void onResume(final Activity activity) {
        super.onResume(activity);
        this.cancelTransition();
        this.delayedTransitionHandler = new Handler();
        this.delayedTransitionRunnable = new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent(LoginFlowBroadcastReceiver.ACTION_UPDATE).putExtra(LoginFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)LoginFlowBroadcastReceiver.Event.ACCOUNT_VERIFIED_COMPLETE));
                LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
                AccountVerifiedContentController.this.delayedTransitionHandler = null;
                AccountVerifiedContentController.this.delayedTransitionRunnable = null;
            }
        };
        this.delayedTransitionHandler.postDelayed(this.delayedTransitionRunnable, 2000L);
    }

    @Override
    protected void logImpression() {
        AccountKitController.Logger.logUIAccountVerified(true, this.configuration.getLoginType());
    }

    @Override
    public void onPause(Activity activity) {
        this.cancelTransition();
        super.onPause(activity);
    }

    @Override
    public ContentFragment getBottomFragment() {
        if (this.bottomFragment == null) {
            this.setBottomFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState()));
        }
        return this.bottomFragment;
    }

    @Override
    public void setBottomFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.bottomFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    public ContentFragment getCenterFragment() {
        if (this.centerFragment == null) {
            this.setCenterFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState(), R.layout.com_accountkit_fragment_sent_code_center));
        }
        return this.centerFragment;
    }

    @Override
    public void setCenterFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.centerFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    @Nullable
    public View getFocusView() {
        return null;
    }

    @Override
    public TitleFragmentFactory.TitleFragment getFooterFragment() {
        if (this.footerFragment == null) {
            this.setFooterFragment(TitleFragmentFactory.create(this.configuration.getUIManager()));
        }
        return this.footerFragment;
    }

    @Override
    public void setFooterFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.footerFragment = fragment;
    }

    @Override
    public TitleFragmentFactory.TitleFragment getHeaderFragment() {
        if (this.headerFragment == null) {
            this.setHeaderFragment(TitleFragmentFactory.create(this.configuration.getUIManager(), R.string.com_accountkit_account_verified, new String[0]));
        }
        return this.headerFragment;
    }

    @Override
    public void setHeaderFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.headerFragment = fragment;
    }

    @Override
    public LoginFlowState getLoginFlowState() {
        return LoginFlowState.ACCOUNT_VERIFIED;
    }

    @Override
    public ContentFragment getTextFragment() {
        if (this.textFragment == null) {
            this.textFragment = StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState());
        }
        return this.textFragment;
    }

    @Override
    public void setTextFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.textFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    public ContentFragment getTopFragment() {
        if (this.topFragment == null) {
            this.setTopFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState()));
        }
        return this.topFragment;
    }

    @Override
    public void setTopFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.topFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    private void cancelTransition() {
        if (this.delayedTransitionHandler != null && this.delayedTransitionRunnable != null) {
            this.delayedTransitionHandler.removeCallbacks(this.delayedTransitionRunnable);
            this.delayedTransitionRunnable = null;
            this.delayedTransitionHandler = null;
        }
    }
}

