/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.view.KeyEvent;
import android.view.MenuItem;
import com.facebook.accountkit.AccountKitUpdateResult;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.ui.AccountKitActivityBase;
import com.facebook.accountkit.ui.AccountKitUpdateResultImpl;
import com.facebook.accountkit.ui.BaseUIManager;
import com.facebook.accountkit.ui.ContentController;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.SkinManager;
import com.facebook.accountkit.ui.TextContentFragment;
import com.facebook.accountkit.ui.TitleFragmentFactory;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.UpdateFlowState;
import com.facebook.accountkit.ui.UpdateStateStackManager;
import com.facebook.accountkit.ui.ViewUtility;

public final class AccountKitUpdateActivity
extends AccountKitActivityBase
implements UIManager.UIManagerListener {
    private static final IntentFilter UPDATE_FLOW_BROADCAST_RECEIVER_FILTER = UpdateStateStackManager.getIntentFilter();
    private String finalUpdateState;
    private AccountKitUpdateResult.UpdateResult result = AccountKitUpdateResult.UpdateResult.CANCELLED;
    private UpdateStateStackManager updateStateStackManager;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.uiManager.setUIManagerListener(this);
        this.updateStateStackManager = new UpdateStateStackManager(this, this.configuration);
        AccountKitController.onUpdateActivityCreate((Activity)this, savedInstanceState);
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.updateStateStackManager, UPDATE_FLOW_BROADCAST_RECEIVER_FILTER);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onPause() {
        super.onPause();
        ContentController contentController = this.updateStateStackManager.getContentController();
        if (contentController != null) {
            contentController.onPause((Activity)this);
        }
    }

    public void onBackPressed() {
        if (this.updateStateStackManager.getContentController() == null) {
            super.onBackPressed();
        } else {
            this.updateStateStackManager.popState();
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        AccountKitController.onUpdateActivitySaveInstanceState((Activity)this, outState);
        super.onSaveInstanceState(outState);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ContentController contentController = this.updateStateStackManager.getContentController();
        if (contentController != null) {
            contentController.onActivityResult(requestCode, resultCode, data);
        }
    }

    protected void onResume() {
        super.onResume();
        ContentController contentController = this.updateStateStackManager.getContentController();
        if (contentController != null) {
            contentController.onResume((Activity)this);
        }
    }

    @Override
    protected void onDestroy() {
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.updateStateStackManager);
        super.onDestroy();
        AccountKitController.onUpdateActivityDestroy((Activity)this);
    }

    @Override
    public void onBack() {
        this.onBackPressed();
    }

    @Override
    public void onCancel() {
        this.sendCancelResult();
    }

    @Override
    void sendResult() {
        int resultCode = this.result == AccountKitUpdateResult.UpdateResult.SUCCESS ? -1 : 0;
        this.sendResult(resultCode, new AccountKitUpdateResultImpl(this.finalUpdateState, this.error, false));
    }

    void sendCancelResult() {
        this.sendResult(0, new AccountKitUpdateResultImpl(null, null, true));
    }

    void setFinalUpdateState(String finalUpdateState) {
        this.finalUpdateState = finalUpdateState;
    }

    void setUpdateResult(AccountKitUpdateResult.UpdateResult result) {
        this.result = result;
    }

    void updateUI(UpdateFlowState updateFlowState, ContentController toContentController) {
        TitleFragmentFactory.TitleFragment headerFragment = updateFlowState == UpdateFlowState.CODE_INPUT_ERROR || updateFlowState == UpdateFlowState.PHONE_NUMBER_INPUT_ERROR ? toContentController.getHeaderFragment() : BaseUIManager.getDefaultHeaderFragment(this.uiManager, updateFlowState);
        Fragment contentCenterFragment = BaseUIManager.getDefaultBodyFragment(this.uiManager, updateFlowState);
        Fragment footerFragment = BaseUIManager.getDefaultFooterFragment(this.uiManager);
        ContentFragment contentTopFragment = toContentController.getTopFragment();
        ContentFragment contentTextFragment = toContentController.getTextFragment();
        ContentFragment contentBottomFragment = toContentController.getBottomFragment();
        if (contentTextFragment != null) {
            int contentPaddingTopResourceId = R.dimen.com_accountkit_vertical_spacer_small_height;
            int contentPaddingTop = this.getResources().getDimensionPixelSize(contentPaddingTopResourceId);
            boolean contentPaddingBottom = false;
            if (contentTextFragment instanceof TextContentFragment) {
                TextContentFragment textContentFragment = (TextContentFragment)contentTextFragment;
                textContentFragment.setContentPaddingTop(contentPaddingTop);
                textContentFragment.setContentPaddingBottom(0);
            }
        }
        this.ensureNextButton(toContentController);
        FragmentTransaction transaction = this.getFragmentManager().beginTransaction();
        this.replace(transaction, R.id.com_accountkit_header_fragment, headerFragment);
        this.replace(transaction, R.id.com_accountkit_content_top_fragment, contentTopFragment);
        this.replace(transaction, R.id.com_accountkit_content_top_text_fragment, null);
        this.replace(transaction, R.id.com_accountkit_content_center_fragment, contentCenterFragment);
        this.replace(transaction, R.id.com_accountkit_content_bottom_text_fragment, contentTextFragment);
        if (!ViewUtility.isSkin(this.uiManager, SkinManager.Skin.CONTEMPORARY)) {
            this.replace(transaction, R.id.com_accountkit_content_bottom_fragment, contentBottomFragment);
            this.replace(transaction, R.id.com_accountkit_footer_fragment, footerFragment);
        }
        transaction.addToBackStack(null);
        ViewUtility.hideKeyboard((Activity)this);
        transaction.commit();
        toContentController.onResume((Activity)this);
    }

    private void sendResult(int resultCode, AccountKitUpdateResultImpl loginResult) {
        Intent data = new Intent();
        data.putExtra("account_kit_update_result", (Parcelable)loginResult);
        this.setResult(resultCode, data);
        this.finish();
    }
}

