/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.app.AppCompatDelegate;
import android.view.View;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.AccountKitUpdateActivity;
import com.facebook.accountkit.ui.ConstrainedLinearLayout;
import com.facebook.accountkit.ui.ContentController;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.KeyboardObserver;
import com.facebook.accountkit.ui.SkinManager;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.ViewUtility;

abstract class AccountKitActivityBase
extends AppCompatActivity {
    public static final String ACCOUNT_KIT_ACTIVITY_CONFIGURATION = AccountKitConfiguration.TAG;
    private static final String TAG = AccountKitUpdateActivity.class.getSimpleName();
    private static final String VIEW_STATE_KEY = TAG + ".viewState";
    private KeyboardObserver keyboardObserver;
    private final Bundle viewState = new Bundle();
    @Nullable
    AccountKitConfiguration configuration;
    UIManager uiManager;
    AccountKitError error;

    AccountKitActivityBase() {
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        View rootView;
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.configuration = (AccountKitConfiguration)intent.getParcelableExtra(ACCOUNT_KIT_ACTIVITY_CONFIGURATION);
        if (this.configuration == null) {
            this.error = new AccountKitError(AccountKitError.Type.INITIALIZATION_ERROR, InternalAccountKitError.INVALID_INTENT_EXTRAS_CONFIGURATION);
            this.sendResult();
            return;
        }
        this.uiManager = this.configuration.getUIManager();
        if (!ViewUtility.doesTextColorContrast((Context)this, this.configuration.getUIManager())) {
            this.error = new AccountKitError(AccountKitError.Type.INITIALIZATION_ERROR, InternalAccountKitError.INVALID_BACKGROUND_CONTRACT);
            this.sendResult();
            return;
        }
        int themeId = this.configuration.getUIManager().getThemeId();
        if (themeId != -1) {
            this.setTheme(themeId);
        }
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
        if (!ViewUtility.isTablet((Context)this)) {
            this.setRequestedOrientation(1);
        }
        this.setContentView(R.layout.com_accountkit_activity_layout);
        final ConstrainedLinearLayout contentView = (ConstrainedLinearLayout)this.findViewById(R.id.com_accountkit_content_view);
        View scrollView = this.findViewById(R.id.com_accountkit_scroll_view);
        if (contentView != null && scrollView != null && contentView.getMinHeight() < 0 && (rootView = contentView.getRootView()) != null) {
            this.keyboardObserver = new KeyboardObserver(scrollView);
            KeyboardObserver.OnVisibleFrameChangedListener onVisibleFrameChangedListener = new KeyboardObserver.OnVisibleFrameChangedListener(){

                @Override
                public void onVisibleFrameChanged(Rect visibleFrame) {
                    int minHeight = visibleFrame.height();
                    if (minHeight >= 0) {
                        contentView.setMinHeight(minHeight);
                    }
                }
            };
            this.keyboardObserver.setOnVisibleFrameChangedListener(onVisibleFrameChangedListener);
        }
        if (savedInstanceState != null) {
            this.viewState.putAll(savedInstanceState.getBundle(VIEW_STATE_KEY));
        }
        ViewUtility.applyThemeBackground((Context)this, this.configuration.getUIManager(), this.findViewById(R.id.com_accountkit_background));
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putBundle(VIEW_STATE_KEY, this.viewState);
        super.onSaveInstanceState(outState);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.keyboardObserver != null) {
            this.keyboardObserver.setOnVisibleFrameChangedListener(null);
            this.keyboardObserver = null;
        }
    }

    abstract void sendResult();

    void ensureNextButton(ContentController contentController) {
        if (!ViewUtility.isSkin(this.uiManager, SkinManager.Skin.CONTEMPORARY)) {
            return;
        }
        FragmentManager fm = this.getFragmentManager();
        if (contentController == null) {
            FragmentTransaction removeBtnTransaction = fm.beginTransaction();
            Fragment fragment = this.remove(removeBtnTransaction, R.id.com_accountkit_content_bottom_fragment);
            if (fragment == null) {
                this.remove(removeBtnTransaction, R.id.com_accountkit_content_bottom_keyboard_fragment);
            }
            removeBtnTransaction.commit();
            return;
        }
        ContentFragment contentBottomFragment = contentController.getBottomFragment();
        FragmentTransaction btnTransaction = fm.beginTransaction();
        if (contentBottomFragment.isKeyboardFragment()) {
            this.remove(btnTransaction, R.id.com_accountkit_content_bottom_fragment);
            this.replace(btnTransaction, R.id.com_accountkit_content_bottom_keyboard_fragment, contentBottomFragment);
        } else {
            this.remove(btnTransaction, R.id.com_accountkit_content_bottom_keyboard_fragment);
            this.replace(btnTransaction, R.id.com_accountkit_content_bottom_fragment, contentBottomFragment);
        }
        btnTransaction.commit();
    }

    void replace(FragmentTransaction transaction, int containerViewId, Fragment fragment) {
        FragmentManager fragmentManager = this.getFragmentManager();
        Fragment oldFragment = fragmentManager.findFragmentById(containerViewId);
        if (oldFragment != fragment) {
            transaction.replace(containerViewId, fragment);
        }
    }

    Fragment remove(FragmentTransaction transaction, int containerViewId) {
        FragmentManager fragmentManager = this.getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentById(containerViewId);
        if (fragment != null) {
            transaction.remove(fragment);
        }
        return fragment;
    }
}

