/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Looper;
import android.os.StatFs;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.PermissionChecker;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.Patterns;
import android.view.Display;
import android.view.WindowManager;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.internal.AccountKitRequestError;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class Utility {
    private static final String TAG = Utility.class.getName();
    private static final ScheduledThreadPoolExecutor BACKGROUND_EXECUTOR = new ScheduledThreadPoolExecutor(1);
    private static final String HASH_ALGORITHM_SHA1 = "SHA-1";
    private static final String EXTRA_APP_EVENTS_INFO_FORMAT_VERSION = "a2";
    private static final String NO_CARRIER = "NoCarrier";
    private static final int REFRESH_TIME_FOR_EXTENDED_DEVICE_INFO_MILLIS = 1800000;
    private static long availableExternalStorageGB = -1L;
    private static String carrierName = "NoCarrier";
    private static String deviceTimezone = "";
    private static int numCPUCores = 0;
    private static long timestampOfLastCheck = -1L;
    private static long totalExternalStorageGB = -1L;

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    static ScheduledThreadPoolExecutor getBackgroundExecutor() {
        return BACKGROUND_EXECUTOR;
    }

    public static Executor getThreadPoolExecutor() {
        return AccountKit.getExecutor();
    }

    static boolean isDebuggable(Context context) {
        try {
            return (context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).applicationInfo.flags & 2) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    static Object getStringPropertyAsJSON(JSONObject jsonObject, String key) throws JSONException {
        Object value = jsonObject.opt(key);
        if (value != null && value instanceof String) {
            value = new JSONTokener((String)value).nextValue();
        }
        return value;
    }

    static boolean hasReadPhoneStatePermissions(@NonNull Context context) {
        return Utility.hasPermission(context, "android.permission.READ_PHONE_STATE");
    }

    static boolean hasGetAccountsPermissions(@NonNull Context context) {
        return Utility.hasPermission(context, "android.permission.GET_ACCOUNTS");
    }

    private static boolean hasPermission(Context context, String permission2) {
        try {
            return 0 == PermissionChecker.checkCallingOrSelfPermission((Context)context, (String)permission2);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<String> getDeviceEmailsIfAvailable(Context context) {
        if (Utility.hasGetAccountsPermissions(context)) {
            Account[] accounts;
            ArrayList<String> emails = new ArrayList<String>();
            for (Account account : accounts = AccountManager.get((Context)context).getAccounts()) {
                if (Utility.isNullOrEmpty(account.name) || !Patterns.EMAIL_ADDRESS.matcher(account.name).matches() || emails.contains(account.name)) continue;
                emails.add(account.name);
            }
            return emails;
        }
        return null;
    }

    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public static String readPhoneNumberIfAvailable(Context context) {
        TelephonyManager telephonyManager;
        if (Utility.hasReadPhoneStatePermissions(context) && (telephonyManager = (TelephonyManager)context.getSystemService("phone")) != null) {
            return telephonyManager.getLine1Number();
        }
        return null;
    }

    public static boolean hasGooglePlayServices(Context context) {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int googlePlayServicesAvailable = apiAvailability.isGooglePlayServicesAvailable(context);
        return googlePlayServicesAvailable == 0;
    }

    @Nullable
    public static Phonenumber.PhoneNumber createI8nPhoneNumber(@Nullable String phone) {
        if (Utility.isNullOrEmpty(phone)) {
            return null;
        }
        if (!phone.startsWith("+")) {
            phone = "+" + phone;
        }
        try {
            return PhoneNumberUtil.getInstance().parse((CharSequence)phone, "");
        }
        catch (NumberParseException numberParseException) {
            return null;
        }
    }

    @Nullable
    public static PhoneNumber convertI8nPhoneNumber(@Nullable Phonenumber.PhoneNumber phoneNumber) {
        if (phoneNumber == null || !PhoneNumberUtil.getInstance().isValidNumber(phoneNumber)) {
            return null;
        }
        return new PhoneNumber(String.valueOf(phoneNumber.getCountryCode()), String.valueOf(phoneNumber.getNationalNumber()), PhoneNumberUtil.getInstance().getRegionCodeForNumber(phoneNumber));
    }

    @Nullable
    public static PhoneNumber createPhoneNumber(@Nullable String phone) {
        return Utility.convertI8nPhoneNumber(Utility.createI8nPhoneNumber(phone));
    }

    @Nullable
    public static String getCountryCode(String phone) {
        if (Utility.isNullOrEmpty(phone)) {
            return null;
        }
        if (phone.startsWith("+")) {
            phone = phone.substring(1);
        }
        String region = null;
        try {
            StringBuilder sb = new StringBuilder(phone.length());
            for (int i = 0; i < phone.length() && region == null; ++i) {
                sb.append(phone.charAt(i));
                region = PhoneNumberUtil.getInstance().getRegionCodeForCountryCode(Integer.valueOf(sb.toString()).intValue());
                if (!region.equals("ZZ")) continue;
                region = null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return region;
    }

    public static String cleanPhoneNumberString(String input) {
        if (Utility.isNullOrEmpty(input)) {
            return "";
        }
        return input.replaceAll("[^\\d]", "");
    }

    static void putNonNullString(Bundle bundle, String key, String value) {
        if (bundle != null && key != null && value != null) {
            bundle.putString(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readStreamToString(InputStream inputStream) throws IOException {
        String string;
        BufferedInputStream bufferedInputStream = null;
        InputStreamReader reader = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(inputStream);
            reader = new InputStreamReader(bufferedInputStream);
            StringBuilder stringBuilder = new StringBuilder();
            int bufferSize = 2048;
            char[] buffer = new char[2048];
            while ((n = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, n);
            }
            string = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Utility.closeQuietly(bufferedInputStream);
            Utility.closeQuietly(reader);
            throw throwable;
        }
        Utility.closeQuietly(bufferedInputStream);
        Utility.closeQuietly(reader);
        return string;
    }

    static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getCurrentCountry(Context context) {
        try {
            String networkCountry;
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            String simCountry = tm.getSimCountryIso();
            if (simCountry != null && simCountry.length() == 2) {
                return simCountry.toLowerCase(Locale.US);
            }
            if (tm.getPhoneType() != 2 && (networkCountry = tm.getNetworkCountryIso()) != null && networkCountry.length() == 2) {
                return networkCountry.toLowerCase(Locale.US);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static void disconnectQuietly(URLConnection connection) {
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int copyAndCloseInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        int totalBytes = 0;
        try {
            int bytesRead;
            bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] buffer = new byte[8192];
            while ((bytesRead = bufferedInputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                totalBytes += bytesRead;
            }
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return totalBytes;
    }

    static boolean notEquals(Object o1, Object o2) {
        return o1 == null || !o1.equals(o2);
    }

    public static <T> boolean areObjectsEqual(T a, T b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static int getHashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    static String sha1hash(byte[] bytes) {
        MessageDigest hash;
        try {
            hash = MessageDigest.getInstance(HASH_ALGORITHM_SHA1);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        return Utility.hashBytes(hash, bytes);
    }

    private static String hashBytes(MessageDigest hash, byte[] bytes) {
        hash.update(bytes);
        byte[] digest = hash.digest();
        StringBuilder builder = new StringBuilder();
        for (byte b : digest) {
            builder.append(Integer.toHexString(b >> 4 & 0xF));
            builder.append(Integer.toHexString(b & 0xF));
        }
        return builder.toString();
    }

    static String getMetadataApplicationId() {
        return AccountKit.getApplicationId();
    }

    static void logd(String tag, Exception e) {
        if (tag != null && e != null) {
            Log.d((String)tag, (String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    static void logd(String tag, String msg, Throwable t) {
        if (!Utility.isNullOrEmpty(tag)) {
            Log.d((String)tag, (String)msg, (Throwable)t);
        }
    }

    static void assertUIThread() {
        if (!Looper.getMainLooper().equals(Looper.myLooper())) {
            Log.w((String)TAG, (String)"This method should be called from the UI thread");
        }
    }

    static Pair<AccountKitError, InternalAccountKitError> createErrorFromServerError(AccountKitRequestError graphError) {
        AccountKitError error;
        int errorCode = graphError.getErrorCode();
        if (graphError.getSubErrorCode() == 1550001) {
            errorCode = 605;
        }
        InternalAccountKitError internalError = new InternalAccountKitError(errorCode, graphError.getErrorMessage(), graphError.getUserErrorMessage());
        switch (graphError.getErrorCode()) {
            case 1948001: {
                error = new AccountKitError(AccountKitError.Type.LOGIN_INVALIDATED, internalError);
                break;
            }
            case 1948002: {
                error = new AccountKitError(AccountKitError.Type.ARGUMENT_ERROR, internalError);
                break;
            }
            case 1948003: {
                error = new AccountKitError(AccountKitError.Type.SERVER_ERROR, internalError);
                break;
            }
            case 100: {
                error = new AccountKitError(AccountKitError.Type.ARGUMENT_ERROR, internalError);
                break;
            }
            case 15003: {
                error = new AccountKitError(AccountKitError.Type.ARGUMENT_ERROR, internalError);
                break;
            }
            case 101: {
                error = new AccountKitError(AccountKitError.Type.NETWORK_CONNECTION_ERROR, internalError);
                break;
            }
            default: {
                error = new AccountKitError(AccountKitError.Type.SERVER_ERROR, internalError);
            }
        }
        return new Pair((Object)error, (Object)internalError);
    }

    static boolean isConfirmationCodeRetryable(InternalAccountKitError internalAccountKitError) {
        return internalAccountKitError != null && internalAccountKitError.getCode() == 15003;
    }

    static void setAppEventAttributionParameters(JSONObject params, String anonymousAppDeviceGUID) throws JSONException {
        params.put("anon_id", (Object)anonymousAppDeviceGUID);
    }

    static void setAppEventExtendedDeviceInfoParameters(JSONObject params, Context appContext) throws JSONException {
        Locale locale;
        JSONArray extraInfoArray = new JSONArray();
        extraInfoArray.put((Object)EXTRA_APP_EVENTS_INFO_FORMAT_VERSION);
        Utility.refreshPeriodicExtendedDeviceInfo(appContext);
        String pkgName = appContext.getPackageName();
        int versionCode = -1;
        String versionName = "";
        try {
            PackageInfo pi = appContext.getPackageManager().getPackageInfo(pkgName, 0);
            versionCode = pi.versionCode;
            versionName = pi.versionName;
        }
        catch (PackageManager.NameNotFoundException pi) {
            // empty catch block
        }
        extraInfoArray.put((Object)pkgName);
        extraInfoArray.put(versionCode);
        extraInfoArray.put((Object)versionName);
        extraInfoArray.put((Object)Build.VERSION.RELEASE);
        extraInfoArray.put((Object)Build.MODEL);
        try {
            locale = appContext.getResources().getConfiguration().locale;
        }
        catch (Exception e) {
            locale = Locale.getDefault();
        }
        extraInfoArray.put((Object)(locale.getLanguage() + "_" + locale.getCountry()));
        extraInfoArray.put((Object)deviceTimezone);
        extraInfoArray.put((Object)carrierName);
        int width = 0;
        int height = 0;
        double density = 0.0;
        try {
            WindowManager wm = (WindowManager)appContext.getSystemService("window");
            if (wm != null) {
                Display display = wm.getDefaultDisplay();
                DisplayMetrics displayMetrics = new DisplayMetrics();
                display.getMetrics(displayMetrics);
                width = displayMetrics.widthPixels;
                height = displayMetrics.heightPixels;
                density = displayMetrics.density;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        extraInfoArray.put(width);
        extraInfoArray.put(height);
        extraInfoArray.put((Object)String.format(Locale.ENGLISH, "%.2f", density));
        extraInfoArray.put(Utility.refreshBestGuessNumberOfCPUCores());
        extraInfoArray.put(totalExternalStorageGB);
        extraInfoArray.put(availableExternalStorageGB);
        params.put("extinfo", (Object)extraInfoArray.toString());
    }

    public static String getRedirectURL() {
        return "ak" + AccountKit.getApplicationId() + "://authorize";
    }

    private static int refreshBestGuessNumberOfCPUCores() {
        if (numCPUCores > 0) {
            return numCPUCores;
        }
        try {
            File cpuDir = new File("/sys/devices/system/cpu/");
            File[] cpuFiles = cpuDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String fileName) {
                    return Pattern.matches("cpu[0-9]+", fileName);
                }
            });
            numCPUCores = cpuFiles.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (numCPUCores <= 0) {
            numCPUCores = Math.max(Runtime.getRuntime().availableProcessors(), 1);
        }
        return numCPUCores;
    }

    private static void refreshPeriodicExtendedDeviceInfo(Context appContext) {
        if (timestampOfLastCheck == -1L || System.currentTimeMillis() - timestampOfLastCheck >= 1800000L) {
            timestampOfLastCheck = System.currentTimeMillis();
            Utility.refreshTimezone();
            Utility.refreshCarrierName(appContext);
            Utility.refreshTotalExternalStorage();
            Utility.refreshAvailableExternalStorage();
        }
    }

    private static void refreshTimezone() {
        try {
            TimeZone tz = TimeZone.getDefault();
            deviceTimezone = tz.getDisplayName(tz.inDaylightTime(new Date()), 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void refreshCarrierName(Context appContext) {
        if (carrierName.equals(NO_CARRIER)) {
            try {
                TelephonyManager telephonyManager = (TelephonyManager)appContext.getSystemService("phone");
                carrierName = telephonyManager.getNetworkOperatorName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void refreshAvailableExternalStorage() {
        try {
            if (Utility.externalStorageExists()) {
                File path = Environment.getExternalStorageDirectory();
                StatFs stat = new StatFs(path.getPath());
                availableExternalStorageGB = (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
            }
            availableExternalStorageGB = Utility.convertBytesToGB(availableExternalStorageGB);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void refreshTotalExternalStorage() {
        try {
            if (Utility.externalStorageExists()) {
                File path = Environment.getExternalStorageDirectory();
                StatFs stat = new StatFs(path.getPath());
                totalExternalStorageGB = (long)stat.getBlockCount() * (long)stat.getBlockSize();
            }
            totalExternalStorageGB = Utility.convertBytesToGB(totalExternalStorageGB);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean externalStorageExists() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    private static long convertBytesToGB(double bytes) {
        return Math.round(bytes / 1.073741824E9);
    }
}

