/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.app.Activity;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitException;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.AccountKitGraphRequestAsyncTask;
import com.facebook.accountkit.internal.InternalLogger;
import com.facebook.accountkit.internal.PhoneUpdateController;
import com.facebook.accountkit.internal.PhoneUpdateModelImpl;
import com.facebook.accountkit.internal.Utility;

final class UpdateManager {
    private static final String SAVED_UPDATE_MODEL = "accountkitUpdateModel";
    @Nullable
    private volatile PhoneUpdateController currentPhoneUpdateController;
    @Nullable
    private volatile Activity currentActivity;
    private volatile boolean isActivityAvailable = false;
    private final InternalLogger logger;
    private final LocalBroadcastManager localBroadcastManager;

    UpdateManager(InternalLogger internalLogger, LocalBroadcastManager localBroadcastManager) {
        this.logger = internalLogger;
        this.localBroadcastManager = localBroadcastManager;
    }

    @Nullable
    PhoneUpdateModelImpl updatePhoneNumber(PhoneNumber phoneNumber, @Nullable String initialAuthState) {
        Utility.assertUIThread();
        AccessToken accessToken = AccountKit.getCurrentAccessToken();
        if (accessToken == null) {
            return null;
        }
        this.cancelExisting();
        PhoneUpdateModelImpl updateModel = new PhoneUpdateModelImpl(phoneNumber);
        PhoneUpdateController updateHandler = new PhoneUpdateController(this, updateModel);
        updateHandler.update(initialAuthState);
        this.currentPhoneUpdateController = updateHandler;
        return updateModel;
    }

    void continueWithCode(String code) {
        block4: {
            Utility.assertUIThread();
            AccessToken accessToken = AccountKit.getCurrentAccessToken();
            if (accessToken == null) {
                return;
            }
            PhoneUpdateModelImpl updateModel = this.getCurrentUpdateModel();
            if (updateModel == null) {
                return;
            }
            try {
                updateModel.setConfirmationCode(code);
                this.handle(updateModel);
            }
            catch (AccountKitException e) {
                if (!Utility.isDebuggable(AccountKitController.getApplicationContext())) break block4;
                throw e;
            }
        }
    }

    void cancelExisting() {
        if (this.currentPhoneUpdateController != null) {
            this.currentPhoneUpdateController.onCancel();
        }
    }

    InternalLogger getLogger() {
        return this.logger;
    }

    void onActivityCreate(Activity activity, Bundle savedInstanceState) {
        PhoneUpdateModelImpl updateModel;
        this.isActivityAvailable = true;
        this.currentActivity = activity;
        this.logger.onActivityCreate(savedInstanceState);
        if (savedInstanceState != null && (updateModel = (PhoneUpdateModelImpl)savedInstanceState.getParcelable(SAVED_UPDATE_MODEL)) != null) {
            this.continueWith(updateModel);
        }
    }

    void onActivityDestroy(Activity activity) {
        if (this.currentActivity != activity) {
            return;
        }
        this.isActivityAvailable = false;
        this.currentActivity = null;
        this.currentPhoneUpdateController = null;
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
        AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(null);
    }

    void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        if (this.currentActivity != activity) {
            return;
        }
        this.logger.saveInstanceState(outState);
        if (this.currentPhoneUpdateController != null) {
            outState.putParcelable(SAVED_UPDATE_MODEL, (Parcelable)this.currentPhoneUpdateController.getUpdateModel());
        }
    }

    boolean isActivityAvailable() {
        return this.isActivityAvailable;
    }

    void clearUpdate() {
        this.currentPhoneUpdateController = null;
    }

    LocalBroadcastManager getLocalBroadcastManager() {
        return this.localBroadcastManager;
    }

    private void handle(PhoneUpdateModelImpl updateModel) {
        Utility.assertUIThread();
        if (this.currentPhoneUpdateController == null) {
            return;
        }
        switch (updateModel.getStatus()) {
            case EMPTY: {
                break;
            }
            case PENDING: {
                this.currentPhoneUpdateController.onPending();
                break;
            }
            case SUCCESS: {
                break;
            }
            case CANCELLED: {
                this.currentPhoneUpdateController.onCancel();
                break;
            }
            case ERROR: {
                this.currentPhoneUpdateController.onError(updateModel.getError());
            }
        }
    }

    @Nullable
    private PhoneUpdateModelImpl getCurrentUpdateModel() {
        if (this.currentPhoneUpdateController == null) {
            return null;
        }
        return this.currentPhoneUpdateController.getUpdateModel();
    }

    private void continueWith(PhoneUpdateModelImpl updateModel) {
        Utility.assertUIThread();
        this.currentPhoneUpdateController = new PhoneUpdateController(this, updateModel);
        this.handle(updateModel);
    }
}

