/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.PhoneUpdateModel;
import com.facebook.accountkit.internal.UpdateStatus;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.internal.Validate;
import java.util.HashMap;
import java.util.Map;

final class PhoneUpdateModelImpl
implements PhoneUpdateModel {
    private PhoneNumber phoneNumber;
    private long resendTime;
    private long expiresInSeconds;
    private String confirmationCode;
    private String updateRequestCode;
    private String initialUpdateState;
    private String finalUpdateState;
    private UpdateStatus status = UpdateStatus.EMPTY;
    private AccountKitError error;
    private Map<String, String> fields = new HashMap<String, String>();
    public static final Parcelable.Creator<PhoneUpdateModelImpl> CREATOR = new Parcelable.Creator<PhoneUpdateModelImpl>(){

        public PhoneUpdateModelImpl createFromParcel(Parcel source) {
            return new PhoneUpdateModelImpl(source);
        }

        public PhoneUpdateModelImpl[] newArray(int size) {
            return new PhoneUpdateModelImpl[size];
        }
    };

    PhoneUpdateModelImpl(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Override
    public PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String getConfirmationCode() {
        return this.confirmationCode;
    }

    @Override
    public String getInitialUpdateState() {
        return this.initialUpdateState;
    }

    @Override
    public String getFinalUpdateState() {
        return this.finalUpdateState;
    }

    @Override
    public String getUpdateRequestCode() {
        return this.updateRequestCode;
    }

    @Override
    public long getResendTime() {
        return this.resendTime;
    }

    @Override
    public UpdateStatus getStatus() {
        return this.status;
    }

    @Override
    public AccountKitError getError() {
        return this.error;
    }

    void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    void setConfirmationCode(String confirmationCode) {
        Validate.isEquals((Object)this.getStatus(), (Object)UpdateStatus.PENDING, "Phone status");
        Validate.sdkInitialized();
        this.confirmationCode = confirmationCode;
    }

    void setInitialUpdateState(String initialUpdateState) {
        this.initialUpdateState = initialUpdateState;
    }

    void setFinalUpdateState(String finalUpdateState) {
        this.finalUpdateState = finalUpdateState;
    }

    void setUpdateRequestCode(String updateRequestCode) {
        this.updateRequestCode = updateRequestCode;
    }

    void setExpiresInSeconds(long expiresInSeconds) {
        this.expiresInSeconds = expiresInSeconds;
    }

    void setResendTime(long resendTime) {
        this.resendTime = resendTime;
    }

    void setStatus(UpdateStatus status) {
        this.status = status;
    }

    void setError(AccountKitError error) {
        this.error = error;
    }

    void putField(String key, String value) {
        this.fields.put(key, value);
    }

    @Override
    @Nullable
    public String getPrivacyPolicy() {
        return this.fields.get("privacy_policy");
    }

    @Override
    @Nullable
    public String getTermsOfService() {
        return this.fields.get("terms_of_service");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PhoneUpdateModelImpl)) {
            return false;
        }
        PhoneUpdateModelImpl o = (PhoneUpdateModelImpl)other;
        return this.expiresInSeconds == o.expiresInSeconds && this.resendTime == o.resendTime && Utility.areObjectsEqual(this.error, o.error) && Utility.areObjectsEqual(this.status, o.status) && Utility.areObjectsEqual(this.phoneNumber, o.phoneNumber) && Utility.areObjectsEqual(this.updateRequestCode, o.updateRequestCode) && Utility.areObjectsEqual(this.finalUpdateState, o.finalUpdateState) && Utility.areObjectsEqual(this.confirmationCode, o.confirmationCode);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.phoneNumber.hashCode();
        result = result * 31 + Long.valueOf(this.resendTime).hashCode();
        result = result * 31 + Long.valueOf(this.expiresInSeconds).hashCode();
        result = result * 31 + this.error.hashCode();
        result = result * 31 + this.status.hashCode();
        result = result * 31 + this.updateRequestCode.hashCode();
        result = result * 31 + this.finalUpdateState.hashCode();
        result = result * 31 + this.confirmationCode.hashCode();
        return result;
    }

    private PhoneUpdateModelImpl(Parcel parcel) {
        this.phoneNumber = (PhoneNumber)parcel.readParcelable(PhoneNumber.class.getClassLoader());
        this.resendTime = parcel.readLong();
        this.expiresInSeconds = parcel.readLong();
        this.confirmationCode = parcel.readString();
        this.updateRequestCode = parcel.readString();
        this.finalUpdateState = parcel.readString();
        this.error = (AccountKitError)parcel.readParcelable(AccountKitError.class.getClassLoader());
        this.status = UpdateStatus.valueOf(parcel.readString());
        this.fields = new HashMap<String, String>();
        int size = parcel.readInt();
        for (int i = 0; i < size; ++i) {
            String key = parcel.readString();
            String value = parcel.readString();
            this.fields.put(key, value);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.phoneNumber, flags);
        dest.writeLong(this.resendTime);
        dest.writeLong(this.expiresInSeconds);
        dest.writeString(this.confirmationCode);
        dest.writeString(this.updateRequestCode);
        dest.writeString(this.finalUpdateState);
        dest.writeParcelable((Parcelable)this.error, flags);
        dest.writeString(this.status.name());
        dest.writeInt(this.fields.size());
        for (String key : this.fields.keySet()) {
            dest.writeString(key);
            dest.writeString(this.fields.get(key));
        }
    }
}

