/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.UpdateFlowBroadcastReceiver;
import com.facebook.accountkit.internal.AccountKitGraphRequest;
import com.facebook.accountkit.internal.AccountKitGraphRequestAsyncTask;
import com.facebook.accountkit.internal.AccountKitGraphResponse;
import com.facebook.accountkit.internal.HttpMethod;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.facebook.accountkit.internal.PhoneUpdateModelImpl;
import com.facebook.accountkit.internal.UpdateManager;
import com.facebook.accountkit.internal.UpdateStatus;
import com.facebook.accountkit.internal.Utility;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

final class PhoneUpdateController {
    private static final String GRAPH_PATH_START_UPDATE = "start_update";
    private static final String GRAPH_PATH_CONFIRM_UPDATE = "confirm_update";
    private static final String PARAMETER_STATE = "state";
    private static final String PARAMETER_PHONE = "phone_number";
    private static final String PARAMETER_EXTRAS_TYPE = "extras";
    private static final String PARAMETER_CREDENTIALS_TYPE = "credentials_type";
    private static final String PARAMETER_CONFIRMATION_CODE = "confirmation_code";
    private static final String PARAMETER_UPDATE_REQUEST_CODE = "update_request_code";
    private final WeakReference<UpdateManager> updateManagerRef;
    private final PhoneUpdateModelImpl updateModel;

    PhoneUpdateController(UpdateManager updateManager, PhoneUpdateModelImpl updateModel) {
        this.updateManagerRef = new WeakReference<UpdateManager>(updateManager);
        this.updateModel = updateModel;
    }

    void update(String initialUpdateState) {
        AccountKitGraphRequest.Callback requestCallback = new AccountKitGraphRequest.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted(AccountKitGraphResponse response) {
                UpdateManager updateManager = PhoneUpdateController.this.getUpdateManager();
                if (updateManager == null || response == null) {
                    return;
                }
                Pair<AccountKitError, InternalAccountKitError> error = null;
                try {
                    String termsOfService;
                    if (response.getError() != null) {
                        error = Utility.createErrorFromServerError(response.getError());
                        PhoneUpdateController.this.setError((AccountKitError)error.first);
                        return;
                    }
                    JSONObject result = response.getResponseObject();
                    if (result == null) {
                        PhoneUpdateController.this.setError(AccountKitError.Type.UPDATE_INVALIDATED, InternalAccountKitError.NO_RESULT_FOUND);
                        return;
                    }
                    String privacyPolicy = result.optString("privacy_policy");
                    if (!Utility.isNullOrEmpty(privacyPolicy)) {
                        PhoneUpdateController.this.updateModel.putField("privacy_policy", privacyPolicy);
                    }
                    if (!Utility.isNullOrEmpty(termsOfService = result.optString("terms_of_service"))) {
                        PhoneUpdateController.this.updateModel.putField("terms_of_service", termsOfService);
                    }
                    try {
                        String updateRequestCode = result.getString(PhoneUpdateController.PARAMETER_UPDATE_REQUEST_CODE);
                        String expiresInString = result.getString("expires_in_sec");
                        long expiresIn = Long.parseLong(expiresInString);
                        PhoneUpdateController.this.updateModel.setExpiresInSeconds(expiresIn);
                        String minResendIntervalSecString = result.optString("min_resend_interval_sec");
                        long minResendIntervalSec = Long.parseLong(minResendIntervalSecString);
                        PhoneUpdateController.this.updateModel.setResendTime(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(minResendIntervalSec));
                        PhoneUpdateController.this.updateModel.setStatus(UpdateStatus.PENDING);
                        PhoneUpdateController.this.updateModel.setUpdateRequestCode(updateRequestCode);
                    }
                    catch (NumberFormatException | JSONException e) {
                        PhoneUpdateController.this.setError(AccountKitError.Type.UPDATE_INVALIDATED, InternalAccountKitError.INVALID_GRAPH_RESULTS_FORMAT);
                    }
                }
                finally {
                    Intent intent = new Intent(UpdateFlowBroadcastReceiver.ACTION_UPDATE);
                    if (PhoneUpdateController.this.updateModel.getStatus() == UpdateStatus.PENDING) {
                        intent.putExtra(UpdateFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)UpdateFlowBroadcastReceiver.Event.SENT_CODE));
                    } else if (PhoneUpdateController.this.updateModel.getStatus() == UpdateStatus.ERROR) {
                        intent.putExtra(UpdateFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)UpdateFlowBroadcastReceiver.Event.ERROR_UPDATE));
                        if (error != null) {
                            intent.putExtra(UpdateFlowBroadcastReceiver.EXTRA_ERROR_MESSAGE, ((AccountKitError)error.first).getUserFacingMessage());
                        }
                    }
                    updateManager.getLocalBroadcastManager().sendBroadcast(intent);
                }
            }
        };
        String phoneNumberString = this.updateModel.getPhoneNumber().toString();
        Bundle parameters = new Bundle();
        Utility.putNonNullString(parameters, PARAMETER_PHONE, phoneNumberString);
        Utility.putNonNullString(parameters, PARAMETER_STATE, initialUpdateState);
        Utility.putNonNullString(parameters, PARAMETER_EXTRAS_TYPE, "terms_of_service,privacy_policy");
        this.updateModel.setInitialUpdateState(initialUpdateState);
        AccountKitGraphRequest request = this.buildGraphRequest(GRAPH_PATH_START_UPDATE, parameters);
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
        AccountKitGraphRequestAsyncTask task = AccountKitGraphRequest.executeAsync(request, requestCallback);
        AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(task);
    }

    void onPending() {
        if (Utility.isNullOrEmpty(this.updateModel.getConfirmationCode())) {
            return;
        }
        AccountKitGraphRequest.Callback requestCallback = new AccountKitGraphRequest.Callback(){

            @Override
            public void onCompleted(AccountKitGraphResponse response) {
                UpdateManager updateManager = PhoneUpdateController.this.getUpdateManager();
                if (updateManager == null || response == null) {
                    return;
                }
                Intent intent = new Intent(UpdateFlowBroadcastReceiver.ACTION_UPDATE);
                if (response.getError() != null) {
                    Pair<AccountKitError, InternalAccountKitError> error = Utility.createErrorFromServerError(response.getError());
                    if (Utility.isConfirmationCodeRetryable((InternalAccountKitError)error.second)) {
                        PhoneUpdateController.this.updateModel.setStatus(UpdateStatus.PENDING);
                        PhoneUpdateController.this.updateModel.setError(null);
                        intent.putExtra(UpdateFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)UpdateFlowBroadcastReceiver.Event.RETRY_CONFIRMATION_CODE));
                    } else {
                        PhoneUpdateController.this.setError((AccountKitError)error.first);
                        updateManager.clearUpdate();
                        intent.putExtra(UpdateFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)UpdateFlowBroadcastReceiver.Event.ERROR_CONFIRMATION_CODE));
                        intent.putExtra(UpdateFlowBroadcastReceiver.EXTRA_ERROR_MESSAGE, ((AccountKitError)error.first).getUserFacingMessage());
                    }
                } else {
                    JSONObject result = response.getResponseObject();
                    if (result == null) {
                        PhoneUpdateController.this.setError(AccountKitError.Type.UPDATE_INVALIDATED, InternalAccountKitError.NO_RESULT_FOUND);
                        intent.putExtra(UpdateFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)UpdateFlowBroadcastReceiver.Event.ERROR_CONFIRMATION_CODE));
                    } else {
                        String finalAuthState = result.optString(PhoneUpdateController.PARAMETER_STATE);
                        PhoneUpdateController.this.updateModel.setFinalUpdateState(finalAuthState);
                        PhoneUpdateController.this.updateModel.setStatus(UpdateStatus.SUCCESS);
                        intent.putExtra(UpdateFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)UpdateFlowBroadcastReceiver.Event.ACCOUNT_UPDATE_COMPLETE));
                        intent.putExtra(UpdateFlowBroadcastReceiver.EXTRA_UPDATE_STATE, PhoneUpdateController.this.updateModel.getFinalUpdateState());
                    }
                    updateManager.clearUpdate();
                }
                updateManager.getLocalBroadcastManager().sendBroadcast(intent);
            }
        };
        Bundle parameters = new Bundle();
        Utility.putNonNullString(parameters, PARAMETER_CONFIRMATION_CODE, this.updateModel.getConfirmationCode());
        Utility.putNonNullString(parameters, PARAMETER_PHONE, this.updateModel.getPhoneNumber().toString());
        AccountKitGraphRequest request = this.buildGraphRequest(GRAPH_PATH_CONFIRM_UPDATE, parameters);
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
        AccountKitGraphRequestAsyncTask task = AccountKitGraphRequest.executeAsync(request, requestCallback);
        AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(task);
    }

    public void onCancel() {
        this.updateModel.setStatus(UpdateStatus.CANCELLED);
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
        AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(null);
        UpdateManager updateManager = this.getUpdateManager();
        if (updateManager != null) {
            updateManager.clearUpdate();
        }
    }

    public void onError(AccountKitError error) {
        this.updateModel.setError(error);
        this.updateModel.setStatus(UpdateStatus.ERROR);
        UpdateManager updateManager = this.getUpdateManager();
        if (updateManager != null) {
            updateManager.clearUpdate();
        }
    }

    PhoneUpdateModelImpl getUpdateModel() {
        return this.updateModel;
    }

    private void setError(AccountKitError error) {
        this.updateModel.setError(error);
        this.updateModel.setStatus(UpdateStatus.ERROR);
    }

    private void setError(AccountKitError.Type errorType, InternalAccountKitError internalError) {
        this.setError(new AccountKitError(errorType, internalError));
    }

    private String getCredentialsType() {
        return PARAMETER_PHONE;
    }

    private AccountKitGraphRequest buildGraphRequest(String graphPath, Bundle extraParameters) {
        Bundle parameters = new Bundle();
        Utility.putNonNullString(parameters, PARAMETER_CREDENTIALS_TYPE, this.getCredentialsType());
        Utility.putNonNullString(parameters, PARAMETER_UPDATE_REQUEST_CODE, this.updateModel.getUpdateRequestCode());
        parameters.putAll(extraParameters);
        return new AccountKitGraphRequest(AccountKit.getCurrentAccessToken(), graphPath, parameters, false, HttpMethod.POST);
    }

    @Nullable
    private UpdateManager getUpdateManager() {
        UpdateManager updateManager = (UpdateManager)this.updateManagerRef.get();
        if (updateManager == null) {
            return null;
        }
        if (!updateManager.isActivityAvailable()) {
            return null;
        }
        return updateManager;
    }
}

