/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.Pair;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.internal.AccessTokenManager;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.AccountKitGraphRequest;
import com.facebook.accountkit.internal.AccountKitGraphRequestAsyncTask;
import com.facebook.accountkit.internal.AccountKitGraphResponse;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.facebook.accountkit.internal.LoginController;
import com.facebook.accountkit.internal.LoginManager;
import com.facebook.accountkit.internal.LoginStatus;
import com.facebook.accountkit.internal.PackageUtils;
import com.facebook.accountkit.internal.PhoneLoginModelImpl;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.internal.Validate;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.auth.api.phone.SmsRetrieverClient;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

final class PhoneLoginController
extends LoginController<PhoneLoginModelImpl> {
    private static final String TAG = PhoneLoginController.class.getName();
    private static final String PARAMETER_CONFIRMATION_CODE = "confirmation_code";
    private static final String PARAMETER_PHONE = "phone_number";
    private static final String PARAMETER_USER_TOKEN = "fb_user_token";

    PhoneLoginController(AccessTokenManager accessTokenManager, LoginManager loginManager, PhoneLoginModelImpl loginModel) {
        super(accessTokenManager, loginManager, loginModel);
    }

    @Override
    protected String getCredentialsType() {
        return PARAMETER_PHONE;
    }

    @Override
    protected String getLoginStateChangedIntentName() {
        return "com.facebook.accountkit.sdk.ACTION_PHONE_LOGIN_STATE_CHANGED";
    }

    @Override
    public void logIn(@Nullable String initialAuthState) {
        LoginManager loginManager;
        AccountKitGraphRequest.Callback requestCallback = new AccountKitGraphRequest.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted(AccountKitGraphResponse response) {
                LoginManager loginManager = PhoneLoginController.this.getLoginManager();
                if (loginManager == null || response == null) {
                    return;
                }
                try {
                    String termsOfService;
                    if (response.getError() != null) {
                        Pair<AccountKitError, InternalAccountKitError> error = Utility.createErrorFromServerError(response.getError());
                        PhoneLoginController.this.onError((AccountKitError)error.first);
                        return;
                    }
                    JSONObject result = response.getResponseObject();
                    if (result == null) {
                        PhoneLoginController.this.onError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.NO_RESULT_FOUND);
                        return;
                    }
                    String privacyPolicy = result.optString("privacy_policy");
                    if (!Utility.isNullOrEmpty(privacyPolicy)) {
                        ((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).putField("privacy_policy", privacyPolicy);
                    }
                    if (!Utility.isNullOrEmpty(termsOfService = result.optString("terms_of_service"))) {
                        ((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).putField("terms_of_service", termsOfService);
                    }
                    try {
                        boolean canSkipCode = result.getBoolean("can_attempt_seamless_login");
                        String expiresAtString = result.getString("expires_at");
                        long expiresAtMillis = Long.parseLong(expiresAtString) * 1000L;
                        if (canSkipCode && expiresAtMillis > System.currentTimeMillis()) {
                            ((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).setStatus(LoginStatus.ACCOUNT_VERIFIED);
                            return;
                        }
                    }
                    catch (JSONException canSkipCode) {
                        // empty catch block
                    }
                    try {
                        String loginModelCode = result.getString("login_request_code");
                        String expiresInString = result.getString("expires_in_sec");
                        long expiresIn = Long.parseLong(expiresInString);
                        ((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).setExpiresInSeconds(expiresIn);
                        String minResendIntervalSecString = result.optString("min_resend_interval_sec");
                        if (!Utility.isNullOrEmpty(minResendIntervalSecString)) {
                            long minResendIntervalSec = Long.parseLong(minResendIntervalSecString);
                            ((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).setResendTime(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(minResendIntervalSec));
                        } else {
                            ((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).setResendTime(System.currentTimeMillis());
                        }
                        ((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).setStatus(LoginStatus.PENDING);
                        ((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).setLoginCode(loginModelCode);
                    }
                    catch (NumberFormatException | JSONException e) {
                        PhoneLoginController.this.onError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.INVALID_GRAPH_RESULTS_FORMAT);
                    }
                }
                finally {
                    PhoneLoginController.this.broadcastLoginStateChange();
                }
            }
        };
        String phoneNumberString = ((PhoneLoginModelImpl)this.loginModel).getPhoneNumber().toString();
        Bundle parameters = new Bundle();
        Utility.putNonNullString(parameters, PARAMETER_PHONE, phoneNumberString);
        Utility.putNonNullString(parameters, "state", initialAuthState);
        Utility.putNonNullString(parameters, "response_type", ((PhoneLoginModelImpl)this.loginModel).getResponseType());
        Utility.putNonNullString(parameters, "fields", "terms_of_service,privacy_policy");
        switch (((PhoneLoginModelImpl)this.loginModel).getNotificationChannel()) {
            case FACEBOOK: {
                Utility.putNonNullString(parameters, "notif_medium", "facebook");
                break;
            }
            case SMS: {
                Utility.putNonNullString(parameters, "notif_medium", "sms");
                Utility.putNonNullString(parameters, "sms_provider", ((PhoneLoginModelImpl)this.loginModel).getTestSmsWithInfobip() ? "infobip" : "facebook");
                break;
            }
            case WHATSAPP: {
                Utility.putNonNullString(parameters, "notif_medium", "whatsapp");
            }
        }
        String appSpecificSmsToken = PhoneLoginController.createSmsToken(AccountKitController.getApplicationContext());
        if (appSpecificSmsToken != null) {
            Utility.putNonNullString(parameters, "sms_token", appSpecificSmsToken);
        }
        if ((loginManager = this.getLoginManager()) != null && !loginManager.isSeamlessLoginRunning()) {
            Utility.putNonNullString(parameters, PARAMETER_USER_TOKEN, loginManager.getSeamlessLoginToken());
        }
        ((PhoneLoginModelImpl)this.loginModel).setInitialAuthState(initialAuthState);
        AccountKitGraphRequest request = this.buildGraphRequest("start_login", parameters);
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
        AccountKitGraphRequestAsyncTask task = AccountKitGraphRequest.executeAsync(request, requestCallback);
        AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(task);
    }

    @Nullable
    private static String createSmsToken(Context context) {
        String appSpecificSmsToken = null;
        if (Utility.hasGooglePlayServices(context)) {
            String packageHash = PackageUtils.computePackageHash(context, context.getPackageName());
            appSpecificSmsToken = packageHash.substring(0, 11);
            SmsRetrieverClient client = SmsRetriever.getClient((Context)context);
            client.startSmsRetriever();
        }
        return appSpecificSmsToken;
    }

    @Override
    public void onCancel() {
        ((PhoneLoginModelImpl)this.loginModel).setStatus(LoginStatus.CANCELLED);
        this.broadcastLoginStateChange();
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
    }

    @Override
    public void onPending() {
        if (Utility.isNullOrEmpty(((PhoneLoginModelImpl)this.loginModel).getConfirmationCode())) {
            return;
        }
        Validate.loginModelInProgress(this.loginModel);
        final LoginManager loginManager = this.getLoginManager();
        if (loginManager == null) {
            return;
        }
        loginManager.onLoginVerify(this.loginModel);
        AccountKitGraphRequest.Callback requestCallback = new AccountKitGraphRequest.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted(AccountKitGraphResponse response) {
                if (!loginManager.isActivityAvailable()) {
                    Log.w((String)TAG, (String)"Warning: Callback issues while activity not available.");
                    return;
                }
                if (response == null) {
                    return;
                }
                Pair<AccountKitError, InternalAccountKitError> error = null;
                try {
                    if (response.getError() != null) {
                        error = Utility.createErrorFromServerError(response.getError());
                        if (!Utility.isConfirmationCodeRetryable((InternalAccountKitError)error.second)) {
                            PhoneLoginController.this.onError((AccountKitError)error.first);
                        }
                        return;
                    }
                    JSONObject result = response.getResponseObject();
                    if (result == null) {
                        PhoneLoginController.this.onError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.NO_RESULT_FOUND);
                        return;
                    }
                    try {
                        PhoneLoginController.this.extractAccessTokenOrCodeIntoModel(result);
                    }
                    catch (NumberFormatException | JSONException e) {
                        PhoneLoginController.this.onError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.INVALID_GRAPH_RESULTS_FORMAT);
                    }
                }
                finally {
                    if (((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).getStatus() == LoginStatus.ERROR && error != null && Utility.isConfirmationCodeRetryable((InternalAccountKitError)error.second)) {
                        ((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).setStatus(LoginStatus.PENDING);
                        ((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).setError(null);
                    }
                    PhoneLoginController.this.broadcastLoginStateChange();
                    loginManager.onLoginComplete(PhoneLoginController.this.loginModel);
                    if (((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).getStatus() == LoginStatus.SUCCESS || ((PhoneLoginModelImpl)PhoneLoginController.this.loginModel).getStatus() == LoginStatus.ERROR) {
                        loginManager.clearLogIn();
                    }
                }
            }
        };
        Bundle parameters = new Bundle();
        Utility.putNonNullString(parameters, PARAMETER_CONFIRMATION_CODE, ((PhoneLoginModelImpl)this.loginModel).getConfirmationCode());
        Utility.putNonNullString(parameters, PARAMETER_PHONE, ((PhoneLoginModelImpl)this.loginModel).getPhoneNumber().toString());
        AccountKitGraphRequest request = this.buildGraphRequest("confirm_login", parameters);
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
        AccountKitGraphRequestAsyncTask task = AccountKitGraphRequest.executeAsync(request, requestCallback);
        AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(task);
    }

    @Override
    public void onAccountVerified() {
        Validate.loginModelInProgress(this.loginModel);
        LoginManager loginManager = this.getLoginManager();
        if (loginManager == null) {
            return;
        }
        loginManager.onSeamlessLoginPending(this.loginModel);
        LoginController.AccountVerifedCallback requestCallback = new LoginController.AccountVerifedCallback(loginManager);
        Bundle parameters = new Bundle();
        Utility.putNonNullString(parameters, PARAMETER_USER_TOKEN, loginManager.getSeamlessLoginTokenRegardlessTimeOut());
        Utility.putNonNullString(parameters, PARAMETER_PHONE, ((PhoneLoginModelImpl)this.loginModel).getPhoneNumber().toString());
        Utility.putNonNullString(parameters, "response_type", ((PhoneLoginModelImpl)this.loginModel).getResponseType());
        Utility.putNonNullString(parameters, "state", ((PhoneLoginModelImpl)this.loginModel).getInitialAuthState());
        AccountKitGraphRequest request = this.buildGraphRequest("instant_verification_login", parameters);
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
        AccountKitGraphRequestAsyncTask task = AccountKitGraphRequest.executeAsync(request, requestCallback);
        AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(task);
    }
}

