/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.Nullable;
import android.util.Base64;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PackageUtils {
    @Nullable
    public static String computePackageHash(Context context, String packageName) {
        return PackageUtils.computePackageHash(context, packageName, 0);
    }

    @Nullable
    public static String computePackageHash(Context context, String packageName, int encodingFlags) {
        byte[] pkghash = PackageUtils.getPackageSig(context, packageName);
        if (pkghash == null) {
            return null;
        }
        return Base64.encodeToString((byte[])pkghash, (int)encodingFlags);
    }

    @Nullable
    private static byte[] getPackageSig(Context context, String pkg) {
        MessageDigest md;
        PackageInfo pinfo;
        PackageManager pm = context.getPackageManager();
        try {
            pinfo = pm.getPackageInfo(pkg, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        String s = pkg + " " + pinfo.signatures[0].toCharsString();
        md.update(s.trim().getBytes(Charset.forName("US-ASCII")));
        return md.digest();
    }
}

