/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.facebook.accountkit.internal.NativeAppInfo;
import com.facebook.accountkit.internal.Utility;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

final class NativeProtocol {
    private static final String INTENT_ACTION_PLATFORM_SERVICE = "com.facebook.platform.PLATFORM_SERVICE";
    private static final String INTENT_ACTION_FBLITE_PLATFORM_SERVICE = "com.facebook.lite.platform.PLATFORM_SERVICE";
    static final int PROTOCOL_VERSION_20161017 = 20161017;
    static final String CONTENT_SCHEME = "content://";
    static final String PLATFORM_PROVIDER = ".provider.PlatformProvider";
    static final String PLATFORM_PROVIDER_VERSIONS = ".provider.PlatformProvider/versions";
    static final String PLATFORM_PROVIDER_VERSION_COLUMN = "version";
    static final int MESSAGE_GET_AK_SEAMLESS_TOKEN_REQUEST = 65544;
    static final int MESSAGE_GET_AK_SEAMLESS_TOKEN_REPLY = 65545;
    static final String EXTRA_APPLICATION_ID = "com.facebook.platform.extra.APPLICATION_ID";
    static final String EXTRA_SEAMLESS_LOGIN_TOKEN = "com.facebook.platform.extra.SEAMLESS_LOGIN_TOKEN";
    static final String EXTRA_EXPIRES_SECONDS_SINCE_EPOCH = "com.facebook.platform.extra.EXPIRES_SECONDS_SINCE_EPOCH";
    static final String STATUS_ERROR_TYPE = "com.facebook.platform.status.ERROR_TYPE";
    private static AtomicBoolean protocolVersionsAsyncUpdating = new AtomicBoolean(false);
    private static List<NativeAppInfo> facebookAppInfoList = Arrays.asList(new KatanaAppInfo(), new WakizashiAppInfo(), new FBLiteAppInfo());

    NativeProtocol() {
    }

    static boolean validateApplicationForService() {
        for (NativeAppInfo appInfo : facebookAppInfoList) {
            if (!appInfo.isAppInstalled()) continue;
            return true;
        }
        return false;
    }

    static boolean validateProtocolVersionForService(int version) {
        for (NativeAppInfo appInfo : facebookAppInfoList) {
            if (!appInfo.getAvailableVersions().contains(version)) continue;
            return true;
        }
        return false;
    }

    static void updateAllAvailableProtocolVersionsAsync() {
        if (!protocolVersionsAsyncUpdating.compareAndSet(false, true)) {
            return;
        }
        Utility.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    for (NativeAppInfo appInfo : facebookAppInfoList) {
                        appInfo.fetchAvailableVersions(true);
                    }
                }
                finally {
                    protocolVersionsAsyncUpdating.set(false);
                }
            }
        });
    }

    static Intent createPlatformServiceIntent(Context context) {
        for (NativeAppInfo appInfo : facebookAppInfoList) {
            Intent intent = appInfo.getPlatformServiceIntent().addCategory("android.intent.category.DEFAULT");
            if ((intent = NativeProtocol.validateServiceIntent(context, intent, appInfo)) == null) continue;
            return intent;
        }
        return null;
    }

    private static Intent validateServiceIntent(Context context, Intent intent, NativeAppInfo appInfo) {
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
        if (resolveInfo == null) {
            return null;
        }
        if (!appInfo.validateSignature(context, resolveInfo.serviceInfo.packageName)) {
            return null;
        }
        return intent;
    }

    private static class FBLiteAppInfo
    extends NativeAppInfo {
        private static final String FBLITE_PACKAGE = "com.facebook.lite";

        private FBLiteAppInfo() {
        }

        @Override
        protected String getPackage() {
            return FBLITE_PACKAGE;
        }

        @Override
        protected Intent getPlatformServiceIntent() {
            return new Intent(NativeProtocol.INTENT_ACTION_FBLITE_PLATFORM_SERVICE).setPackage(this.getPackage());
        }
    }

    private static class WakizashiAppInfo
    extends NativeAppInfo {
        private static final String WAKIZASHI_PACKAGE = "com.facebook.wakizashi";

        private WakizashiAppInfo() {
        }

        @Override
        protected String getPackage() {
            return WAKIZASHI_PACKAGE;
        }

        @Override
        protected Intent getPlatformServiceIntent() {
            return new Intent(NativeProtocol.INTENT_ACTION_PLATFORM_SERVICE).setPackage(this.getPackage());
        }
    }

    private static class KatanaAppInfo
    extends NativeAppInfo {
        private static final String KATANA_PACKAGE = "com.facebook.katana";

        private KatanaAppInfo() {
        }

        @Override
        protected String getPackage() {
            return KATANA_PACKAGE;
        }

        @Override
        protected Intent getPlatformServiceIntent() {
            return new Intent(NativeProtocol.INTENT_ACTION_PLATFORM_SERVICE).setPackage(this.getPackage());
        }
    }
}

