/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.util.Pair;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.Account;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitCallback;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.AccountKitException;
import com.facebook.accountkit.LoginModel;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.internal.AccessTokenManager;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.AccountKitGraphRequest;
import com.facebook.accountkit.internal.AccountKitGraphRequestAsyncTask;
import com.facebook.accountkit.internal.AccountKitGraphResponse;
import com.facebook.accountkit.internal.EmailLoginController;
import com.facebook.accountkit.internal.EmailLoginModelImpl;
import com.facebook.accountkit.internal.HttpMethod;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.facebook.accountkit.internal.InternalLogger;
import com.facebook.accountkit.internal.LoginController;
import com.facebook.accountkit.internal.LoginModelImpl;
import com.facebook.accountkit.internal.LoginStatus;
import com.facebook.accountkit.internal.PhoneLoginController;
import com.facebook.accountkit.internal.PhoneLoginModelImpl;
import com.facebook.accountkit.internal.SeamlessLoginClient;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.internal.Validate;
import com.facebook.accountkit.ui.NotificationChannel;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

final class LoginManager {
    private static final String TAG = LoginManager.class.getName();
    private static final String LOGOUT_PATH = "logout/";
    private static final String SAVED_LOGIN_MODEL = "accountkitLoginModel";
    private final AccessTokenManager accessTokenManager;
    private volatile Activity currentActivity;
    @Nullable
    private volatile LoginController currentLoginController;
    private volatile boolean isActivityAvailable = false;
    private final LocalBroadcastManager localBroadcastManager;
    private final InternalLogger logger;
    private String requestInstanceToken;
    private SeamlessLoginClient seamlessLoginClient;
    private String seamlessLoginToken;
    private long seamlessLoginExpirationMillis;

    LoginManager(InternalLogger internalLogger, AccessTokenManager accessTokenManager, @NonNull LocalBroadcastManager localBroadcastManager) {
        this.accessTokenManager = accessTokenManager;
        this.localBroadcastManager = localBroadcastManager;
        this.logger = internalLogger;
        this.resetRequestInstanceToken();
    }

    void continueWithCode(String code) {
        PhoneLoginModelImpl loginModel = this.getCurrentPhoneNumberLogInModel();
        if (loginModel == null) {
            return;
        }
        try {
            loginModel.setConfirmationCode(code);
            this.handle(loginModel);
        }
        catch (AccountKitException e) {
            if (!Utility.isDebuggable(AccountKitController.getApplicationContext())) {
                this.logger.logLoginModel("ak_confirmation_code_set", loginModel);
            }
            throw e;
        }
    }

    void continueSeamlessLogin() {
        LoginModelImpl loginModel = this.getCurrentLogInModel();
        if (loginModel == null) {
            return;
        }
        try {
            this.handle(loginModel);
        }
        catch (AccountKitException e) {
            if (!Utility.isDebuggable(AccountKitController.getApplicationContext())) {
                this.logger.logLoginModel("ak_seamless_pending", loginModel);
            }
            throw e;
        }
    }

    void onActivityCreate(Activity activity, Bundle savedInstanceState) {
        LoginModelImpl loginModel;
        this.isActivityAvailable = true;
        this.currentActivity = activity;
        this.logger.onActivityCreate(savedInstanceState);
        if (savedInstanceState != null && (loginModel = (LoginModelImpl)savedInstanceState.getParcelable(SAVED_LOGIN_MODEL)) != null) {
            this.startWith(loginModel);
        }
    }

    void onActivityDestroy(Activity activity) {
        if (this.currentActivity != activity) {
            return;
        }
        this.isActivityAvailable = false;
        this.currentLoginController = null;
        this.currentActivity = null;
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
        AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(null);
    }

    void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        if (this.currentActivity != activity) {
            return;
        }
        this.logger.saveInstanceState(outState);
        if (this.currentLoginController != null) {
            outState.putParcelable(SAVED_LOGIN_MODEL, this.currentLoginController.getLoginModel());
        }
    }

    InternalLogger getLogger() {
        return this.logger;
    }

    void handle(LoginModelImpl loginModel) {
        if (this.currentLoginController == null) {
            return;
        }
        Validate.loginModelsEqual(loginModel, this.currentLoginController.getLoginModel());
        Utility.assertUIThread();
        switch (loginModel.getStatus()) {
            case PENDING: {
                this.currentLoginController.onPending();
                break;
            }
            case ACCOUNT_VERIFIED: {
                this.currentLoginController.onAccountVerified();
                break;
            }
            case ERROR: {
                this.currentLoginController.onError(loginModel.getError());
                break;
            }
            case CANCELLED: {
                this.currentLoginController.onCancel();
                break;
            }
            case SUCCESS: {
                break;
            }
        }
    }

    private void onLoginStart(LoginModelImpl loginModel) {
        this.logger.logLoginModel("ak_login_start", loginModel);
    }

    void onLoginVerify(LoginModelImpl loginModel) {
        this.logger.logLoginModel("ak_login_verify", loginModel);
    }

    void onSeamlessLoginPending(LoginModelImpl loginModel) {
        this.logger.logLoginModel("ak_seamless_pending", loginModel);
    }

    void onLoginComplete(LoginModelImpl loginModel) {
        this.logger.logLoginModel("ak_login_complete", loginModel);
    }

    EmailLoginModelImpl getCurrentEmailLogInModel() {
        if (this.currentLoginController == null) {
            return null;
        }
        Object loginModel = this.currentLoginController.getLoginModel();
        if (!(loginModel instanceof EmailLoginModelImpl)) {
            return null;
        }
        return (EmailLoginModelImpl)loginModel;
    }

    PhoneLoginModelImpl getCurrentPhoneNumberLogInModel() {
        if (this.currentLoginController == null) {
            return null;
        }
        Object loginModel = this.currentLoginController.getLoginModel();
        if (!(loginModel instanceof PhoneLoginModelImpl)) {
            return null;
        }
        return (PhoneLoginModelImpl)loginModel;
    }

    @Nullable
    private LoginModelImpl getCurrentLogInModel() {
        if (this.currentLoginController == null) {
            return null;
        }
        return this.currentLoginController.getLoginModel();
    }

    void cancelLogin() {
        AccountKitGraphRequestAsyncTask currentAsyncTask;
        Utility.assertUIThread();
        this.resetRequestInstanceToken();
        if (this.currentLoginController != null) {
            this.currentLoginController.onCancel();
            AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(null);
            this.currentLoginController = null;
        }
        if ((currentAsyncTask = AccountKitGraphRequestAsyncTask.getCurrentAsyncTask()) != null) {
            currentAsyncTask.cancel(true);
            AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(null);
        }
    }

    String getRequestInstanceToken() {
        return this.requestInstanceToken;
    }

    void initializeLogin() {
        this.seamlessLoginToken = null;
        this.seamlessLoginClient = new SeamlessLoginClient(AccountKitController.getApplicationContext(), AccountKit.getApplicationId(), this.logger);
        if (!this.seamlessLoginClient.start()) {
            return;
        }
        SeamlessLoginClient.CompletedListener callback = new SeamlessLoginClient.CompletedListener(){

            @Override
            public void completed(Bundle result) {
                LoginManager.this.seamlessLoginCompleted(result);
            }
        };
        this.seamlessLoginClient.setCompletedListener(callback);
    }

    private void seamlessLoginCompleted(Bundle result) {
        if (result != null) {
            this.seamlessLoginExpirationMillis = result.getLong("com.facebook.platform.extra.EXPIRES_SECONDS_SINCE_EPOCH") * 1000L;
            this.seamlessLoginToken = result.getString("com.facebook.platform.extra.SEAMLESS_LOGIN_TOKEN");
        }
    }

    String getSeamlessLoginToken() {
        if (this.seamlessLoginExpirationMillis < System.currentTimeMillis()) {
            this.seamlessLoginToken = null;
        }
        return this.seamlessLoginToken;
    }

    String getSeamlessLoginTokenRegardlessTimeOut() {
        return this.seamlessLoginToken;
    }

    boolean isSeamlessLoginRunning() {
        return this.seamlessLoginToken == null && this.seamlessLoginClient != null && this.seamlessLoginClient.isRunning();
    }

    EmailLoginModelImpl logInWithEmail(@NonNull String email, @NonNull String responseType, @Nullable String initialAuthState) {
        Utility.assertUIThread();
        this.cancelExisting();
        EmailLoginModelImpl loginModel = new EmailLoginModelImpl(email, responseType);
        EmailLoginController loginHandler = new EmailLoginController(this.accessTokenManager, this, loginModel);
        loginHandler.logIn(initialAuthState);
        this.onLoginStart(loginModel);
        this.currentLoginController = loginHandler;
        return loginModel;
    }

    PhoneLoginModelImpl logInWithPhoneNumber(@NonNull PhoneNumber phoneNumber, @NonNull NotificationChannel notificationChannel, @NonNull String responseType, @Nullable String initialAuthState) {
        return this.logInWithPhoneNumber(phoneNumber, notificationChannel, responseType, initialAuthState, false);
    }

    PhoneLoginModelImpl logInWithPhoneNumber(@NonNull PhoneNumber phoneNumber, @NonNull NotificationChannel notificationChannel, @NonNull String responseType, @Nullable String initialAuthState, boolean testSmsWithInfobip) {
        Utility.assertUIThread();
        if (notificationChannel == NotificationChannel.SMS || notificationChannel == NotificationChannel.WHATSAPP) {
            this.cancelCurrentRequest();
        }
        PhoneLoginModelImpl loginModel = new PhoneLoginModelImpl(phoneNumber, notificationChannel, responseType);
        loginModel.setTestSmsWithInfobip(testSmsWithInfobip);
        PhoneLoginController loginHandler = new PhoneLoginController(this.accessTokenManager, this, loginModel);
        loginHandler.logIn(initialAuthState);
        this.onLoginStart(loginModel);
        this.currentLoginController = loginHandler;
        return loginModel;
    }

    void logOut() {
        this.logOut(null);
        this.accessTokenManager.setCurrentAccessToken(null);
    }

    void logOut(final @Nullable AccountKitCallback<Void> callback) {
        AccessToken accessToken = AccountKit.getCurrentAccessToken();
        if (accessToken == null) {
            Log.w((String)TAG, (String)"No access token: cannot log out");
            if (callback != null) {
                callback.onSuccess(null);
            }
            return;
        }
        AccountKitGraphRequest.Callback requestCallback = new AccountKitGraphRequest.Callback(){

            @Override
            public void onCompleted(AccountKitGraphResponse response) {
                if (response.getError() != null) {
                    Pair<AccountKitError, InternalAccountKitError> error = Utility.createErrorFromServerError(response.getError());
                    if (callback != null) {
                        callback.onError((AccountKitError)error.first);
                    }
                } else {
                    LoginManager.this.accessTokenManager.setCurrentAccessToken(null);
                    if (callback != null) {
                        callback.onSuccess(null);
                    }
                }
            }
        };
        AccountKitGraphRequest graphRequest = new AccountKitGraphRequest(accessToken, LOGOUT_PATH, null, false, HttpMethod.POST);
        AccountKitGraphRequest.executeAsync(graphRequest, requestCallback);
    }

    void clearLogIn() {
        this.currentLoginController = null;
    }

    private void cancelExisting() {
        if (this.currentLoginController == null) {
            return;
        }
        Object loginModel = this.currentLoginController.getLoginModel();
        ((LoginModelImpl)loginModel).setStatus(LoginStatus.CANCELLED);
        this.currentLoginController.onCancel();
    }

    boolean isActivityAvailable() {
        return this.isActivityAvailable;
    }

    LocalBroadcastManager getLocalBroadcastManager() {
        return this.localBroadcastManager;
    }

    boolean isLoginInProgress() {
        return this.currentLoginController != null;
    }

    private void cancelCurrentRequest() {
        this.currentLoginController = null;
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
        AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(null);
    }

    void cancel(LoginModel loginModel) {
        this.seamlessLoginToken = null;
        if (this.currentLoginController == null) {
            return;
        }
        if (!Utility.areObjectsEqual(loginModel, this.currentLoginController.getLoginModel())) {
            return;
        }
        this.cancelCurrentRequest();
    }

    private void startWith(@NonNull LoginModelImpl loginModel) {
        Utility.assertUIThread();
        if (loginModel instanceof EmailLoginModelImpl) {
            this.currentLoginController = new EmailLoginController(this.accessTokenManager, this, (EmailLoginModelImpl)loginModel);
        } else if (loginModel instanceof PhoneLoginModelImpl) {
            this.currentLoginController = new PhoneLoginController(this.accessTokenManager, this, (PhoneLoginModelImpl)loginModel);
        } else {
            throw new AccountKitException(AccountKitError.Type.ARGUMENT_ERROR, InternalAccountKitError.INVALID_LOGIN_TYPE, loginModel.getClass().getName());
        }
        this.handle(loginModel);
    }

    void getCurrentAccount(final AccountKitCallback<Account> callback) {
        final AccessToken accessToken = AccountKit.getCurrentAccessToken();
        if (accessToken == null) {
            Log.w((String)TAG, (String)"No access token: cannot retrieve account");
            callback.onError(new AccountKitError(AccountKitError.Type.INTERNAL_ERROR, InternalAccountKitError.CANNOT_RETRIEVE_ACCESS_TOKEN_NO_ACCOUNT));
            return;
        }
        AccountKitGraphRequest.Callback requestCallback = new AccountKitGraphRequest.Callback(){

            @Override
            public void onCompleted(AccountKitGraphResponse response) {
                if (response.getError() != null) {
                    Pair<AccountKitError, InternalAccountKitError> error = Utility.createErrorFromServerError(response.getError());
                    callback.onError((AccountKitError)error.first);
                    return;
                }
                JSONObject result = response.getResponseObject();
                if (result == null) {
                    callback.onError(new AccountKitError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.NO_RESULT_FOUND));
                    return;
                }
                try {
                    AccessToken currentAccessToken;
                    String accountId = result.getString("id");
                    JSONObject emailBundle = result.optJSONObject("email");
                    String email = null;
                    if (emailBundle != null) {
                        email = emailBundle.getString("address");
                    }
                    JSONObject phoneNumberBundle = result.optJSONObject("phone");
                    String nationalPhoneNumber = null;
                    String countryCode = null;
                    if (phoneNumberBundle != null) {
                        nationalPhoneNumber = phoneNumberBundle.getString("national_number");
                        countryCode = phoneNumberBundle.getString("country_prefix");
                    }
                    if (countryCode == null && nationalPhoneNumber == null && email == null) {
                        callback.onError(new AccountKitError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.NO_ACCOUNT_FOUND));
                        return;
                    }
                    if (countryCode == null && nationalPhoneNumber != null || countryCode != null && nationalPhoneNumber == null) {
                        callback.onError(new AccountKitError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.NO_ACCOUNT_FOUND));
                        return;
                    }
                    PhoneNumber phoneNumber = null;
                    if (countryCode != null) {
                        phoneNumber = new PhoneNumber(countryCode, nationalPhoneNumber, null);
                    }
                    if ((currentAccessToken = AccountKit.getCurrentAccessToken()) != null && accessToken.equals(currentAccessToken)) {
                        LoginManager.this.accessTokenManager.refreshCurrentAccessToken(currentAccessToken);
                    }
                    Account account = new Account(accountId, phoneNumber, email);
                    callback.onSuccess(account);
                }
                catch (JSONException e) {
                    callback.onError(new AccountKitError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.INVALID_GRAPH_RESULTS_FORMAT));
                }
            }
        };
        AccountKitGraphRequest graphRequest = new AccountKitGraphRequest(accessToken, accessToken.getAccountId(), null, false, HttpMethod.GET);
        AccountKitGraphRequest.executeAsync(graphRequest, requestCallback);
    }

    private void resetRequestInstanceToken() {
        this.requestInstanceToken = UUID.randomUUID().toString();
    }
}

