/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.content.Context;
import android.os.Bundle;
import com.facebook.accountkit.internal.Utility;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

final class FacebookAppEventLogger {
    private static final String TAG = FacebookAppEventLogger.class.getCanonicalName();
    private static final String FB_EVENT_NAME_LOGIN_ATTEMPT = "fb_ak_login_attempt";
    private static final String FB_EVENT_NAME_LOGIN_COMPLETE = "fb_ak_login_complete";
    private static final String FB_EVENT_NAME_LOGIN_DIALOG_IMPRESSION = "fb_ak_login_dialog_impression";
    private static final String FB_EVENT_NAME_LOGIN_START = "fb_ak_login_start";
    private static final String FB_EVENT_NAME_LOGIN_CONFIRMATION_VIEW = "fb_ak_login_confirmation_view";
    private static final Map<String, String> eventNameMap = new HashMap<String, String>(){
        {
            this.put("ak_email_login_view", FacebookAppEventLogger.FB_EVENT_NAME_LOGIN_DIALOG_IMPRESSION);
            this.put("ak_phone_login_view", FacebookAppEventLogger.FB_EVENT_NAME_LOGIN_DIALOG_IMPRESSION);
            this.put("ak_login_start", FacebookAppEventLogger.FB_EVENT_NAME_LOGIN_START);
            this.put("ak_confirmation_code_view", FacebookAppEventLogger.FB_EVENT_NAME_LOGIN_CONFIRMATION_VIEW);
            this.put("ak_account_verified_view", FacebookAppEventLogger.FB_EVENT_NAME_LOGIN_CONFIRMATION_VIEW);
            this.put("ak_email_sent_view", FacebookAppEventLogger.FB_EVENT_NAME_LOGIN_CONFIRMATION_VIEW);
            this.put("ak_login_verify", FacebookAppEventLogger.FB_EVENT_NAME_LOGIN_ATTEMPT);
            this.put("ak_seamless_pending", FacebookAppEventLogger.FB_EVENT_NAME_LOGIN_ATTEMPT);
            this.put("ak_login_complete", FacebookAppEventLogger.FB_EVENT_NAME_LOGIN_COMPLETE);
        }
    };
    private Object fbAppEventLogger = null;

    FacebookAppEventLogger(Context applicationContext) {
        if (FacebookAppEventLogger.isFacebookSDKInitialized()) {
            try {
                Class<?> fbAppEventClass = Class.forName("com.facebook.appevents.AppEventsLogger");
                try {
                    Method logSDKEventMethod = fbAppEventClass.getMethod("newLogger", Context.class);
                    try {
                        this.fbAppEventLogger = logSDKEventMethod.invoke(null, applicationContext);
                    }
                    catch (Exception e) {
                        Utility.logd(TAG, e);
                    }
                }
                catch (NoSuchMethodException e) {
                    Utility.logd(TAG, e);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public void logImpression(String eventName, Bundle parameters, boolean isPresented) {
        if (isPresented) {
            this.logFacebookAppEvents(eventName, null, parameters);
        }
    }

    void logFacebookAppEvents(String eventName, Double valueToSum, Bundle parameters) {
        String fbEventName = eventNameMap.get(eventName);
        if (fbEventName == null) {
            return;
        }
        if (this.fbAppEventLogger != null) {
            try {
                Method logSDKEventMethod = this.fbAppEventLogger.getClass().getMethod("logSdkEvent", String.class, Double.class, Bundle.class);
                try {
                    logSDKEventMethod.invoke(this.fbAppEventLogger, fbEventName, valueToSum, parameters);
                }
                catch (Exception e) {
                    Utility.logd(TAG, e);
                }
            }
            catch (NoSuchMethodException e) {
                Utility.logd(TAG, e);
            }
        }
    }

    static boolean isFacebookSDKInitialized() {
        try {
            Class<?> fbSDKClass = Class.forName("com.facebook.FacebookSdk");
            try {
                Method initializedMethod = fbSDKClass.getMethod("isInitialized", new Class[0]);
                try {
                    Object result = initializedMethod.invoke(null, new Object[0]);
                    return (Boolean)result;
                }
                catch (Exception e) {
                    Utility.logd(TAG, e);
                }
            }
            catch (NoSuchMethodException e) {
                Utility.logd(TAG, e);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

