/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.facebook.accountkit.internal.AccountKitGraphRequest;
import com.facebook.accountkit.internal.AccountKitGraphRequestAsyncTask;
import com.facebook.accountkit.internal.AccountKitGraphResponse;
import com.facebook.accountkit.internal.ExperimentationConfiguration;
import com.facebook.accountkit.internal.HttpMethod;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.internal.Validate;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class ExperimentationConfigurator {
    private static final String GRAPH_PATH_GET_CONFIGURATION = "experimentation_configuration";
    private static final String PARAMETER_UNIT_IDENTIFIER = "unit_id";
    private static final String RESPONSE_PARAMETER_UNIT_ID = "unit_id";
    private static final String RESPONSE_PARAMETER_DATA = "data";
    private static final String RESPONSE_PARAMETER_CREATE_TIME = "create_time";
    private static final String RESPONSE_PARAMETER_TTL = "ttl";
    private static final String RESPONSE_PARAMETER_FEATURE_SET = "feature_set";
    private static final String FEATURE_PARAMETER_KEY = "key";
    private static final String FEATURE_PARAMETER_VALUE = "value";
    private Context applicationContext;

    ExperimentationConfigurator() {
    }

    void initialize(@NonNull Context context) {
        Validate.checkInternetPermissionAndThrow(context);
        this.applicationContext = context.getApplicationContext();
        Utility.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ExperimentationConfiguration ec = ExperimentationConfigurator.this.getExperimentationConfiguration();
                if (!ec.exists() || ec.isStale()) {
                    ExperimentationConfigurator.this.downloadExperimentationConfiguration(ec.getUnitID());
                }
            }
        });
    }

    ExperimentationConfiguration getExperimentationConfiguration() {
        return new ExperimentationConfiguration(this.applicationContext);
    }

    private void downloadExperimentationConfiguration(final @Nullable String unitID) {
        Utility.getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AccountKitGraphRequest graphRequest = ExperimentationConfigurator.this.buildGraphRequest(ExperimentationConfigurator.GRAPH_PATH_GET_CONFIGURATION, unitID);
                AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
                AccountKitGraphRequest.Callback callback = new AccountKitGraphRequest.Callback(){

                    @Override
                    public void onCompleted(AccountKitGraphResponse response) {
                        if (response == null || response.getResponseObject() == null || response.getError() != null) {
                            return;
                        }
                        try {
                            JSONObject responseObject = response.getResponseObject().getJSONArray(ExperimentationConfigurator.RESPONSE_PARAMETER_DATA).getJSONObject(0);
                            Long createTime = null;
                            Long ttl = null;
                            String unitID = null;
                            if (responseObject.has(ExperimentationConfigurator.RESPONSE_PARAMETER_CREATE_TIME)) {
                                createTime = responseObject.getLong(ExperimentationConfigurator.RESPONSE_PARAMETER_CREATE_TIME);
                            }
                            if (responseObject.has("unit_id")) {
                                unitID = responseObject.getString("unit_id");
                            }
                            if (responseObject.has(ExperimentationConfigurator.RESPONSE_PARAMETER_TTL)) {
                                ttl = responseObject.getLong(ExperimentationConfigurator.RESPONSE_PARAMETER_TTL);
                            }
                            JSONArray payload = responseObject.getJSONArray(ExperimentationConfigurator.RESPONSE_PARAMETER_FEATURE_SET);
                            HashMap<Integer, Integer> featureSet = new HashMap<Integer, Integer>(payload.length());
                            for (int i = 0; i < payload.length(); ++i) {
                                JSONObject elem = payload.getJSONObject(i);
                                featureSet.put(elem.getInt(ExperimentationConfigurator.FEATURE_PARAMETER_KEY), elem.getInt(ExperimentationConfigurator.FEATURE_PARAMETER_VALUE));
                            }
                            ExperimentationConfiguration.load(ExperimentationConfigurator.this.applicationContext, unitID, createTime, ttl, featureSet);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                };
                AccountKitGraphRequestAsyncTask task = AccountKitGraphRequest.executeAsync(graphRequest, callback);
                AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(task);
            }
        });
    }

    private AccountKitGraphRequest buildGraphRequest(String graphPath, @Nullable String unitID) {
        Bundle parameters = new Bundle();
        Utility.putNonNullString(parameters, "unit_id", unitID);
        return new AccountKitGraphRequest(null, graphPath, parameters, false, HttpMethod.GET);
    }
}

