/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.Pair;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.internal.AccessTokenManager;
import com.facebook.accountkit.internal.AccountKitGraphRequest;
import com.facebook.accountkit.internal.AccountKitGraphRequestAsyncTask;
import com.facebook.accountkit.internal.AccountKitGraphResponse;
import com.facebook.accountkit.internal.EmailLoginModelImpl;
import com.facebook.accountkit.internal.InternalAccountKitError;
import com.facebook.accountkit.internal.LoginController;
import com.facebook.accountkit.internal.LoginManager;
import com.facebook.accountkit.internal.LoginStatus;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.internal.Validate;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

final class EmailLoginController
extends LoginController<EmailLoginModelImpl> {
    private static final int SECONDS_TO_MILLIS = 1000;
    private static final String PARAMETER_EMAIL = "email";
    private static final String TAG = EmailLoginController.class.getName();

    EmailLoginController(AccessTokenManager accessTokenManager, LoginManager loginManager, EmailLoginModelImpl loginModel) {
        super(accessTokenManager, loginManager, loginModel);
    }

    @Override
    protected String getCredentialsType() {
        return PARAMETER_EMAIL;
    }

    @Override
    protected String getLoginStateChangedIntentName() {
        return "com.facebook.accountkit.sdk.ACTION_EMAIL_LOGIN_STATE_CHANGED";
    }

    @Override
    public void logIn(@Nullable String initialAuthState) {
        AccountKitGraphRequest.Callback requestCallback = new AccountKitGraphRequest.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted(AccountKitGraphResponse response) {
                LoginManager loginManager = EmailLoginController.this.getLoginManager();
                if (loginManager == null) {
                    return;
                }
                try {
                    String termsOfService;
                    if (response.getError() != null) {
                        Pair<AccountKitError, InternalAccountKitError> error = Utility.createErrorFromServerError(response.getError());
                        EmailLoginController.this.onError((AccountKitError)error.first);
                        return;
                    }
                    JSONObject result = response.getResponseObject();
                    if (result == null) {
                        EmailLoginController.this.onError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.NO_RESULT_FOUND);
                        return;
                    }
                    String privacyPolicy = result.optString("privacy_policy");
                    if (!Utility.isNullOrEmpty(privacyPolicy)) {
                        ((EmailLoginModelImpl)EmailLoginController.this.loginModel).putField("privacy_policy", privacyPolicy);
                    }
                    if (!Utility.isNullOrEmpty(termsOfService = result.optString("terms_of_service"))) {
                        ((EmailLoginModelImpl)EmailLoginController.this.loginModel).putField("terms_of_service", termsOfService);
                    }
                    try {
                        boolean canSkipCode = result.getBoolean("can_attempt_seamless_login");
                        String expireAtString = result.getString("expires_at");
                        long expireAtMillis = Long.parseLong(expireAtString) * 1000L;
                        if (canSkipCode && expireAtMillis > System.currentTimeMillis()) {
                            ((EmailLoginModelImpl)EmailLoginController.this.loginModel).setStatus(LoginStatus.ACCOUNT_VERIFIED);
                            return;
                        }
                    }
                    catch (JSONException canSkipCode) {
                        // empty catch block
                    }
                    try {
                        String loginAttemptCode = result.getString("login_request_code");
                        ((EmailLoginModelImpl)EmailLoginController.this.loginModel).setLoginCode(loginAttemptCode);
                        String expiresInString = result.getString("expires_in_sec");
                        long expiresIn = Long.parseLong(expiresInString);
                        ((EmailLoginModelImpl)EmailLoginController.this.loginModel).setExpiresInSeconds(expiresIn);
                        String intervalSecondsString = result.getString("interval_sec");
                        int intervalSeconds = Integer.parseInt(intervalSecondsString);
                        ((EmailLoginModelImpl)EmailLoginController.this.loginModel).setInterval(intervalSeconds);
                        ((EmailLoginModelImpl)EmailLoginController.this.loginModel).setStatus(LoginStatus.PENDING);
                        loginManager.handle(EmailLoginController.this.loginModel);
                    }
                    catch (NumberFormatException | JSONException e) {
                        EmailLoginController.this.onError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.INVALID_GRAPH_RESULTS_FORMAT);
                    }
                }
                finally {
                    EmailLoginController.this.broadcastLoginStateChange();
                }
            }
        };
        Bundle parameters = new Bundle();
        Utility.putNonNullString(parameters, PARAMETER_EMAIL, ((EmailLoginModelImpl)this.loginModel).getEmail());
        Utility.putNonNullString(parameters, "redirect_uri", Utility.getRedirectURL());
        Utility.putNonNullString(parameters, "state", initialAuthState);
        Utility.putNonNullString(parameters, "response_type", ((EmailLoginModelImpl)this.loginModel).getResponseType());
        Utility.putNonNullString(parameters, "fields", "terms_of_service,privacy_policy");
        LoginManager loginManager = this.getLoginManager();
        if (loginManager != null && !loginManager.isSeamlessLoginRunning()) {
            Utility.putNonNullString(parameters, "fb_user_token", loginManager.getSeamlessLoginToken());
        }
        ((EmailLoginModelImpl)this.loginModel).setInitialAuthState(initialAuthState);
        AccountKitGraphRequest graphRequest = this.buildGraphRequest("start_login", parameters);
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
        AccountKitGraphRequestAsyncTask task = AccountKitGraphRequest.executeAsync(graphRequest, requestCallback);
        AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(task);
    }

    @Override
    public void onCancel() {
        ((EmailLoginModelImpl)this.loginModel).setStatus(LoginStatus.CANCELLED);
        this.broadcastLoginStateChange();
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
    }

    @Override
    public void onPending() {
        LoginManager loginManager = this.getLoginManager();
        if (loginManager == null) {
            return;
        }
        if (!loginManager.isActivityAvailable()) {
            return;
        }
        LoginModelCodeCallback loginCallback = new LoginModelCodeCallback((EmailLoginModelImpl)this.loginModel);
        Runnable poll = this.createPolling((EmailLoginModelImpl)this.loginModel, loginCallback);
        if (poll == null) {
            return;
        }
        new Handler().postDelayed(poll, (long)(((EmailLoginModelImpl)this.loginModel).getInterval() * 1000));
    }

    @Override
    public void onAccountVerified() {
        Validate.loginModelInProgress(this.loginModel);
        LoginManager loginManager = this.getLoginManager();
        if (loginManager == null) {
            return;
        }
        loginManager.onSeamlessLoginPending(this.loginModel);
        LoginController.AccountVerifedCallback requestCallback = new LoginController.AccountVerifedCallback(this, loginManager);
        Bundle parameters = new Bundle();
        Utility.putNonNullString(parameters, "fb_user_token", loginManager.getSeamlessLoginTokenRegardlessTimeOut());
        Utility.putNonNullString(parameters, PARAMETER_EMAIL, ((EmailLoginModelImpl)this.loginModel).getEmail());
        Utility.putNonNullString(parameters, "response_type", ((EmailLoginModelImpl)this.loginModel).getResponseType());
        Utility.putNonNullString(parameters, "state", ((EmailLoginModelImpl)this.loginModel).getInitialAuthState());
        AccountKitGraphRequest request = this.buildGraphRequest("instant_verification_login", parameters);
        AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
        AccountKitGraphRequestAsyncTask task = AccountKitGraphRequest.executeAsync(request, requestCallback);
        AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(task);
    }

    @Nullable
    private Runnable createPolling(final EmailLoginModelImpl loginModel, final AccountKitGraphRequest.Callback callback) {
        LoginManager loginManager = this.getLoginManager();
        if (loginManager == null) {
            return null;
        }
        final String requestInstanceToken = loginManager.getRequestInstanceToken();
        return new Runnable(){

            @Override
            public void run() {
                Utility.assertUIThread();
                if (!this.checkLoginManager()) {
                    return;
                }
                Bundle parameters = new Bundle();
                Utility.putNonNullString(parameters, EmailLoginController.PARAMETER_EMAIL, loginModel.getEmail());
                AccountKitGraphRequest graphRequest = EmailLoginController.this.buildGraphRequest("poll_login", parameters);
                AccountKitGraphRequestAsyncTask.cancelCurrentAsyncTask();
                AccountKitGraphRequest.Callback callbackWrapper = new AccountKitGraphRequest.Callback(){

                    @Override
                    public void onCompleted(AccountKitGraphResponse response) {
                        callback.onCompleted(response);
                    }
                };
                AccountKitGraphRequestAsyncTask task = AccountKitGraphRequest.executeAsync(graphRequest, callbackWrapper);
                AccountKitGraphRequestAsyncTask.setCurrentAsyncTask(task);
            }

            private boolean checkLoginManager() {
                LoginManager loginManager = EmailLoginController.this.getLoginManager();
                return loginManager != null && requestInstanceToken.equals(loginManager.getRequestInstanceToken()) && loginManager.isLoginInProgress();
            }
        };
    }

    static /* synthetic */ String access$000() {
        return TAG;
    }

    static /* synthetic */ Runnable access$100(EmailLoginController x0, EmailLoginModelImpl x1, AccountKitGraphRequest.Callback x2) {
        return x0.createPolling(x1, x2);
    }

    private class LoginModelCodeCallback
    implements AccountKitGraphRequest.Callback {
        final EmailLoginModelImpl loginModel;

        LoginModelCodeCallback(EmailLoginModelImpl loginModel) {
            this.loginModel = loginModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void onCompleted(AccountKitGraphResponse response) {
            block40: {
                block38: {
                    block39: {
                        block36: {
                            block37: {
                                block34: {
                                    block35: {
                                        block32: {
                                            block33: {
                                                Utility.assertUIThread();
                                                loginManager = EmailLoginController.this.getLoginManager();
                                                if (loginManager == null) {
                                                    return;
                                                }
                                                if (!loginManager.isActivityAvailable() || !loginManager.isLoginInProgress()) {
                                                    Log.w((String)EmailLoginController.access$000(), (String)"Warning: Callback issues while activity not available.");
                                                    return;
                                                }
                                                if (response.getError() == null) break block32;
                                                error = Utility.createErrorFromServerError(response.getError());
                                                EmailLoginController.this.onError((AccountKitError)error.first);
                                                if (this.loginModel == null) break block33;
                                                switch (3.$SwitchMap$com$facebook$accountkit$internal$LoginStatus[this.loginModel.getStatus().ordinal()]) {
                                                    case 1: 
                                                    case 2: {
                                                        loginManager.onLoginComplete(this.loginModel);
                                                        EmailLoginController.this.broadcastLoginStateChange();
                                                        loginManager.clearLogIn();
                                                    }
                                                }
                                            }
                                            return;
                                        }
                                        result = response.getResponseObject();
                                        if (result != null) break block34;
                                        EmailLoginController.this.onError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.NO_RESULT_FOUND);
                                        if (this.loginModel == null) break block35;
                                        switch (3.$SwitchMap$com$facebook$accountkit$internal$LoginStatus[this.loginModel.getStatus().ordinal()]) {
                                            case 1: 
                                            case 2: {
                                                loginManager.onLoginComplete(this.loginModel);
                                                EmailLoginController.this.broadcastLoginStateChange();
                                                loginManager.clearLogIn();
                                            }
                                        }
                                    }
                                    return;
                                }
                                status = result.getString("status");
                                if (!status.equals("pending")) ** GOTO lbl75
                                poll = EmailLoginController.access$100(EmailLoginController.this, this.loginModel, new LoginModelCodeCallback(this.loginModel));
                                if (poll != null) break block36;
                                if (this.loginModel == null) break block37;
                                switch (3.$SwitchMap$com$facebook$accountkit$internal$LoginStatus[this.loginModel.getStatus().ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        loginManager.onLoginComplete(this.loginModel);
                                        EmailLoginController.this.broadcastLoginStateChange();
                                        loginManager.clearLogIn();
                                    }
                                }
                            }
                            return;
                        }
                        intervalSecondsString = result.getString("interval_sec");
                        intervalSeconds = Integer.parseInt(intervalSecondsString);
                        this.loginModel.setInterval(intervalSeconds);
                        expiresInString = result.getString("expires_in_sec");
                        expiresIn = Long.parseLong(expiresInString);
                        this.loginModel.setExpiresInSeconds(expiresIn);
                        if (expiresIn >= (long)this.loginModel.getInterval()) break block38;
                        EmailLoginController.this.onError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.EXPIRED_EMAIL_REQUEST);
                        if (this.loginModel == null) break block39;
                        switch (3.$SwitchMap$com$facebook$accountkit$internal$LoginStatus[this.loginModel.getStatus().ordinal()]) {
                            case 1: 
                            case 2: {
                                loginManager.onLoginComplete(this.loginModel);
                                EmailLoginController.this.broadcastLoginStateChange();
                                loginManager.clearLogIn();
                            }
                        }
                    }
                    return;
                }
                try {
                    try {
                        if (loginManager.isActivityAvailable() || loginManager.isLoginInProgress()) {
                            new Handler().postDelayed(poll, (long)(this.loginModel.getInterval() * 1000));
                        }
                        break block40;
lbl75:
                        // 1 sources

                        if (Utility.areObjectsEqual(this.loginModel.getResponseType(), "token")) {
                            accessToken = result.getString("access_token");
                            accountId = result.getString("id");
                            tokenRefreshIntervalString = result.getString("token_refresh_interval_sec");
                            tokenRefreshIntervalInSeconds = Long.parseLong(tokenRefreshIntervalString);
                            token = new AccessToken(accessToken, accountId, AccountKit.getApplicationId(), tokenRefreshIntervalInSeconds, new Date());
                            EmailLoginController.this.accessTokenManager.setCurrentAccessToken(token);
                            finalAuthState = result.optString("state");
                            this.loginModel.setFinalAuthState(finalAuthState);
                            this.loginModel.setAccessToken(token);
                            this.loginModel.setStatus(LoginStatus.SUCCESS);
                            break block40;
                        }
                        code = result.getString("code");
                        this.loginModel.setCode(code);
                        finalAuthState = result.optString("state");
                        this.loginModel.setFinalAuthState(finalAuthState);
                        this.loginModel.setStatus(LoginStatus.SUCCESS);
                    }
                    catch (NumberFormatException | JSONException e) {
                        EmailLoginController.this.onError(AccountKitError.Type.LOGIN_INVALIDATED, InternalAccountKitError.INVALID_GRAPH_RESULTS_FORMAT);
                    }
                }
                finally {
                    if (this.loginModel != null) {
                        switch (3.$SwitchMap$com$facebook$accountkit$internal$LoginStatus[this.loginModel.getStatus().ordinal()]) {
                            case 1: 
                            case 2: {
                                loginManager.onLoginComplete(this.loginModel);
                                EmailLoginController.this.broadcastLoginStateChange();
                                loginManager.clearLogIn();
                            }
                        }
                    }
                }
            }
        }
    }
}

