/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.internal;

import android.support.annotation.NonNull;
import android.util.Log;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.LoggingBehavior;

final class ConsoleLogger {
    private static final String LOG_TAG_BASE = "AccountKitSDK.";
    private static final String NEWLINE = "\n";
    private final LoggingBehavior behavior;
    private StringBuilder contents;
    private final String tag;

    public static void log(LoggingBehavior behavior, String tag, String string) {
        ConsoleLogger.log(behavior, 3, tag, string);
    }

    public static void log(LoggingBehavior behavior, String tag, String format, Object ... args) {
        String string = String.format(format, args);
        ConsoleLogger.log(behavior, 3, tag, string);
    }

    public static void log(LoggingBehavior behavior, int priority, String tag, String format, Object ... args) {
        String string = String.format(format, args);
        ConsoleLogger.log(behavior, priority, tag, string);
    }

    private static void log(LoggingBehavior behavior, int priority, String tag, String string) {
        if (AccountKit.getLoggingBehaviors().isEnabled(behavior)) {
            if (!tag.startsWith(LOG_TAG_BASE)) {
                tag = LOG_TAG_BASE + tag;
            }
            Log.println((int)priority, (String)tag, (String)string);
            if (behavior == LoggingBehavior.DEVELOPER_ERRORS) {
                new Exception().printStackTrace();
            }
        }
    }

    ConsoleLogger(LoggingBehavior behavior, @NonNull String tag) {
        this.behavior = behavior;
        this.tag = LOG_TAG_BASE + tag;
        this.contents = new StringBuilder();
    }

    public void log() {
        ConsoleLogger.log(this.behavior, 3, this.tag, this.contents.toString());
        this.contents = new StringBuilder();
    }

    void appendLine(String string) {
        if (this.shouldLog()) {
            this.contents.append(string).append(NEWLINE);
        }
    }

    private void append(String toFormat, Object ... args) {
        if (this.shouldLog()) {
            this.contents.append(String.format(toFormat, args));
        }
    }

    void appendKeyValue(String key, Object value) {
        this.append("  %s:\t%s\n", key, value);
    }

    private boolean shouldLog() {
        return AccountKit.getLoggingBehaviors().isEnabled(this.behavior);
    }
}

